/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.medialist.EventApi;
import uk.co.caprica.vlcj.medialist.MediaApi;
import uk.co.caprica.vlcj.medialist.MediaListRef;

public final class MediaList {
    protected final libvlc_instance_t libvlcInstance;
    protected final libvlc_media_list_t mediaListInstance;
    private final MediaApi itemApi;
    private final EventApi eventApi;

    public MediaList(libvlc_instance_t libvlcInstance, libvlc_media_list_t mediaListInstance) {
        this.libvlcInstance = libvlcInstance;
        this.mediaListInstance = mediaListInstance;
        this.eventApi = new EventApi(this);
        this.itemApi = new MediaApi(this);
    }

    public EventApi events() {
        return this.eventApi;
    }

    public MediaApi media() {
        return this.itemApi;
    }

    public libvlc_media_list_t mediaListInstance() {
        return this.mediaListInstance;
    }

    public MediaListRef newMediaListRef() {
        LibVlc.libvlc_media_list_retain((libvlc_media_list_t)this.mediaListInstance);
        return new MediaListRef(this.libvlcInstance, this.mediaListInstance);
    }

    public MediaList newMediaList() {
        LibVlc.libvlc_media_list_retain((libvlc_media_list_t)this.mediaListInstance);
        return new MediaList(this.libvlcInstance, this.mediaListInstance);
    }

    public void release() {
        this.eventApi.release();
        this.itemApi.release();
        LibVlc.libvlc_media_list_release((libvlc_media_list_t)this.mediaListInstance);
    }
}

