/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.javafx.videosurface;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.CallbackVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapters;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.format.RV32BufferFormat;

public final class ImageViewVideoSurfaceFactory {
    private final ImageView imageView;
    private final PixelBufferBufferFormatCallback bufferFormatCallback;
    private final PixelBufferRenderCallback renderCallback;
    private final PixelBufferVideoSurface videoSurface;
    private PixelBuffer<ByteBuffer> pixelBuffer;

    public static VideoSurface videoSurfaceForImageView(ImageView imageView) {
        return new ImageViewVideoSurfaceFactory((ImageView)imageView).videoSurface;
    }

    private ImageViewVideoSurfaceFactory(ImageView imageView) {
        this.imageView = imageView;
        this.bufferFormatCallback = new PixelBufferBufferFormatCallback();
        this.renderCallback = new PixelBufferRenderCallback();
        this.videoSurface = new PixelBufferVideoSurface();
    }

    private class PixelBufferVideoSurface
    extends CallbackVideoSurface {
        private PixelBufferVideoSurface() {
            super((BufferFormatCallback)ImageViewVideoSurfaceFactory.this.bufferFormatCallback, (RenderCallback)ImageViewVideoSurfaceFactory.this.renderCallback, true, VideoSurfaceAdapters.getVideoSurfaceAdapter());
        }
    }

    private class PixelBufferRenderCallback
    implements RenderCallback {
        private PixelBufferRenderCallback() {
        }

        public void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
            Platform.runLater(() -> ImageViewVideoSurfaceFactory.this.pixelBuffer.updateBuffer(pb -> null));
        }
    }

    private class PixelBufferBufferFormatCallback
    implements BufferFormatCallback {
        private int sourceWidth;
        private int sourceHeight;

        private PixelBufferBufferFormatCallback() {
        }

        public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
            this.sourceWidth = sourceWidth;
            this.sourceHeight = sourceHeight;
            return new RV32BufferFormat(sourceWidth, sourceHeight);
        }

        public void allocatedBuffers(ByteBuffer[] buffers) {
            WritablePixelFormat pixelFormat = PixelFormat.getByteBgraPreInstance();
            ImageViewVideoSurfaceFactory.this.pixelBuffer = new PixelBuffer(this.sourceWidth, this.sourceHeight, (Buffer)buffers[0], (PixelFormat)pixelFormat);
            ImageViewVideoSurfaceFactory.this.imageView.setImage((Image)new WritableImage(ImageViewVideoSurfaceFactory.this.pixelBuffer));
        }
    }
}

