/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationObservationContext;
import org.springframework.security.authorization.method.MethodInvocationResult;

public final class AuthorizationObservationConvention
implements ObservationConvention<AuthorizationObservationContext<?>> {
    static final String OBSERVATION_NAME = "spring.security.authorizations";

    public String getName() {
        return OBSERVATION_NAME;
    }

    public String getContextualName(AuthorizationObservationContext<?> context) {
        return "authorize " + this.getObjectType(context);
    }

    public KeyValues getLowCardinalityKeyValues(AuthorizationObservationContext<?> context) {
        return KeyValues.of((String)"spring.security.authentication.type", (String)this.getAuthenticationType(context)).and("spring.security.object", this.getObjectType(context)).and("spring.security.authorization.decision", this.getAuthorizationDecision(context));
    }

    public KeyValues getHighCardinalityKeyValues(AuthorizationObservationContext<?> context) {
        return KeyValues.of((String)"spring.security.authentication.authorities", (String)this.getAuthorities(context)).and("spring.security.authorization.decision.details", this.getDecisionDetails(context));
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof AuthorizationObservationContext;
    }

    private String getAuthenticationType(AuthorizationObservationContext<?> context) {
        if (context.getAuthentication() == null) {
            return "n/a";
        }
        return context.getAuthentication().getClass().getSimpleName();
    }

    private String getObjectType(AuthorizationObservationContext<?> context) {
        if (context.getObject() == null) {
            return "unknown";
        }
        if (context.getObject() instanceof MethodInvocation) {
            return "method";
        }
        if (context.getObject() instanceof MethodInvocationResult) {
            return "method";
        }
        String className = context.getObject().getClass().getSimpleName();
        if (className.contains("Request")) {
            return "request";
        }
        if (className.contains("Message")) {
            return "message";
        }
        return className;
    }

    private String getAuthorizationDecision(AuthorizationObservationContext<?> context) {
        if (context.getDecision() == null) {
            return "unknown";
        }
        return String.valueOf(context.getDecision().isGranted());
    }

    private String getAuthorities(AuthorizationObservationContext<?> context) {
        if (context.getAuthentication() == null) {
            return "n/a";
        }
        return String.valueOf(context.getAuthentication().getAuthorities());
    }

    private String getDecisionDetails(AuthorizationObservationContext<?> context) {
        if (context.getDecision() == null) {
            return "unknown";
        }
        AuthorizationDecision decision = context.getDecision();
        return String.valueOf(decision);
    }
}

