/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.Executor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.openjfx.JavaFXBaseMojo;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class JavaFXRunMojo
extends JavaFXBaseMojo {
    @Parameter(property="javafx.executable", defaultValue="java")
    private String executable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (this.executable == null) {
            throw new MojoExecutionException("The parameter 'executable' is missing or invalid");
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        try {
            this.handleWorkingDirectory();
            Map<String, String> enviro = this.handleSystemEnvVariables();
            CommandLine commandLine = this.getExecutablePath(this.executable, enviro, this.workingDirectory);
            boolean usingOldJDK = JavaFXRunMojo.isTargetUsingJava8(commandLine);
            List<String> commandArguments = this.createCommandArguments(usingOldJDK);
            String[] args = commandArguments.toArray(new String[commandArguments.size()]);
            commandLine.addArguments(args, false);
            this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
            DefaultExecutor exec = new DefaultExecutor();
            exec.setWorkingDirectory(this.workingDirectory);
            try {
                int resultCode;
                block14: {
                    block13: {
                        if (this.outputFile == null) break block13;
                        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                            this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                        }
                        FileOutputStream outputStream = null;
                        try {
                            outputStream = new FileOutputStream(this.outputFile);
                            resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, outputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(outputStream);
                            throw throwable;
                        }
                        IOUtil.close((OutputStream)outputStream);
                        break block14;
                    }
                    resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, System.out, System.err);
                }
                if (resultCode != 0) {
                    String message = "Result of " + commandLine.toString() + " execution is: '" + resultCode + "'.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
            }
            catch (ExecuteException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                e.printStackTrace();
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private List<String> createCommandArguments(boolean oldJDK) throws MojoExecutionException {
        ArrayList<String> commandArguments = new ArrayList<String>();
        this.preparePaths(JavaFXRunMojo.getParent(Paths.get(this.executable, new String[0]), 2));
        if (this.options != null) {
            this.options.stream().filter(Objects::nonNull).filter(String.class::isInstance).map(String.class::cast).forEach(commandArguments::add);
        }
        if (!oldJDK && this.modulepathElements != null && !this.modulepathElements.isEmpty()) {
            commandArguments.add(" --module-path");
            String modulePath = StringUtils.join(this.modulepathElements.iterator(), (String)File.pathSeparator);
            commandArguments.add(modulePath);
            commandArguments.add(" --add-modules");
            if (this.moduleDescriptor != null) {
                commandArguments.add(" " + this.moduleDescriptor.name());
            } else {
                String modules = this.pathElements.values().stream().filter(Objects::nonNull).map(JavaModuleDescriptor::name).filter(Objects::nonNull).filter(module -> module.startsWith("javafx") && !module.endsWith("Empty")).collect(Collectors.joining(","));
                commandArguments.add(" " + modules);
            }
        }
        if (this.classpathElements != null && (oldJDK || !this.classpathElements.isEmpty())) {
            commandArguments.add(" -classpath");
            String classpath = "";
            if (oldJDK || this.moduleDescriptor != null) {
                classpath = this.project.getBuild().getOutputDirectory() + File.pathSeparator;
            }
            classpath = classpath + StringUtils.join(this.classpathElements.iterator(), (String)File.pathSeparator);
            commandArguments.add(classpath);
        }
        if (this.mainClass != null) {
            if (this.moduleDescriptor != null) {
                commandArguments.add(" --module");
                if (!this.mainClass.startsWith(this.moduleDescriptor.name() + "/")) {
                    commandArguments.add(" " + this.moduleDescriptor.name() + "/" + this.mainClass);
                } else {
                    commandArguments.add(" " + this.mainClass);
                }
            } else {
                commandArguments.add(" " + this.mainClass);
            }
        }
        if (this.commandlineArgs != null) {
            commandArguments.add(this.commandlineArgs);
        }
        return commandArguments;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setCommandlineArgs(String commandlineArgs) {
        this.commandlineArgs = commandlineArgs;
    }
}

