/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.reflect.DeclaredMembers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanHelper {
    private static final Type[] NO_TYPES = new Type[0];
    private final ConverterLookup lookup;
    private final ClassLoader loader;
    private final ExpressionEvaluator evaluator;
    private final ConfigurationListener listener;

    BeanHelper(ConverterLookup lookup, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) {
        this.lookup = lookup;
        this.loader = loader;
        this.evaluator = evaluator;
        this.listener = listener;
    }

    void setDefault(Object bean, Object defaultValue, PlexusConfiguration configuration) throws ComponentConfigurationException {
        Type[] paramTypeHolder;
        Class<?> beanType = bean.getClass();
        Method setter = BeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set");
        if (null == setter) {
            throw new ComponentConfigurationException(configuration, "Cannot find default setter in " + beanType);
        }
        Object value = defaultValue;
        TypeLiteral paramType = TypeLiteral.get((Type)paramTypeHolder[0]);
        if (!paramType.getRawType().isInstance(value)) {
            if (configuration.getChildCount() > 0) {
                throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
            }
            value = this.convertProperty(beanType, paramType.getRawType(), paramType.getType(), configuration);
        }
        if (null != value) {
            try {
                if (null != this.listener) {
                    this.listener.notifyFieldChangeUsingSetter("", value, bean);
                }
                setter.invoke(bean, value);
            }
            catch (Exception e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
            catch (LinkageError e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
        }
    }

    void setProperty(Object bean, String propertyName, Class<?> implType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        String reason;
        Field field;
        Throwable problem;
        Method setter;
        Class<?> beanType;
        block20: {
            beanType = bean.getClass();
            Type[] paramTypeHolder = new Type[1];
            String title = Character.toTitleCase(propertyName.charAt(0)) + propertyName.substring(1);
            setter = BeanHelper.findMethod(beanType, paramTypeHolder, "set" + title);
            if (null == setter) {
                setter = BeanHelper.findMethod(beanType, paramTypeHolder, "add" + title);
            }
            problem = null;
            Object value = null;
            if (null != setter) {
                try {
                    TypeLiteral paramType = TypeLiteral.get((Type)paramTypeHolder[0]);
                    Class<?> rawPropertyType = paramType.getRawType();
                    if (null != implType && rawPropertyType.isAssignableFrom(implType)) {
                        rawPropertyType = implType;
                    }
                    if (null != (value = this.convertProperty(beanType, rawPropertyType, paramType.getType(), configuration))) {
                        if (null != this.listener) {
                            this.listener.notifyFieldChangeUsingSetter(propertyName, value, bean);
                        }
                        setter.invoke(bean, value);
                        return;
                    }
                }
                catch (Exception e) {
                    problem = e;
                }
                catch (LinkageError e) {
                    problem = e;
                }
            }
            if (null != (field = BeanHelper.findField(beanType, propertyName))) {
                try {
                    TypeLiteral fieldType = TypeLiteral.get((Type)field.getGenericType());
                    Class<?> rawPropertyType = fieldType.getRawType();
                    if (!rawPropertyType.isInstance(value)) {
                        if (null != implType && rawPropertyType.isAssignableFrom(implType)) {
                            rawPropertyType = implType;
                        }
                        value = this.convertProperty(beanType, rawPropertyType, fieldType.getType(), configuration);
                    }
                    if (null != value) {
                        if (null != this.listener) {
                            this.listener.notifyFieldChangeUsingReflection(propertyName, value, bean);
                        }
                        BeanHelper.setField(bean, field, value);
                        return;
                    }
                }
                catch (Exception e) {
                    if (null == problem) {
                        problem = e;
                    }
                }
                catch (LinkageError e) {
                    if (null != problem) break block20;
                    problem = e;
                }
            }
        }
        if (problem instanceof ComponentConfigurationException) {
            throw (ComponentConfigurationException)problem;
        }
        if (null != problem) {
            reason = "Cannot set '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason, problem);
        }
        if (null == setter && null == field) {
            reason = "Cannot find '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    private Object convertProperty(Class<?> beanType, Class<?> rawPropertyType, Type genericPropertyType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookup.lookupConverterForType(rawPropertyType);
        if (!(genericPropertyType instanceof Class) && converter instanceof ParameterizedConfigurationConverter) {
            Type[] paramTypes = BeanHelper.getParameterTypes(genericPropertyType);
            return ((ParameterizedConfigurationConverter)converter).fromConfiguration(this.lookup, configuration, rawPropertyType, paramTypes, beanType, this.loader, this.evaluator, this.listener);
        }
        return converter.fromConfiguration(this.lookup, configuration, rawPropertyType, beanType, this.loader, this.evaluator, this.listener);
    }

    private static Type[] getParameterTypes(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < argumentTypes.length; ++i) {
                argumentTypes[i] = BeanHelper.expandType(argumentTypes[i]);
            }
            return argumentTypes;
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{BeanHelper.expandType(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPES;
    }

    private static Type expandType(Type type) {
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }

    private static Method findMethod(Class<?> beanType, Type[] paramTypeHolder, String methodName) {
        for (Method m : beanType.getMethods()) {
            Type[] paramTypes;
            if (!methodName.equals(m.getName()) || Modifier.isStatic(m.getModifiers()) || (paramTypes = m.getGenericParameterTypes()).length != 1) continue;
            paramTypeHolder[0] = paramTypes[0];
            return m;
        }
        return null;
    }

    private static Field findField(Class<?> beanType, String fieldName) {
        for (Member f : new DeclaredMembers(beanType, new DeclaredMembers.View[]{DeclaredMembers.View.FIELDS})) {
            if (!fieldName.equals(f.getName()) || Modifier.isStatic(f.getModifiers())) continue;
            return (Field)f;
        }
        return null;
    }

    private static void setField(Object bean, final Field field, Object value) throws Exception {
        if (!field.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
        field.set(bean, value);
    }
}

