/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseButton;
import javafx.util.Duration;
import org.apache.log4j.Logger;
import org.comtel2000.keyboard.control.KeyButton;
import org.comtel2000.keyboard.control.MultiKeyPopup;
import org.comtel2000.keyboard.control.ShortPressKeyButton;
import org.comtel2000.keyboard.event.KeyButtonEvent;

class MultiKeyButton
extends KeyButton {
    private static Logger logger = Logger.getLogger(MultiKeyButton.class);
    private MultiKeyPopup context;
    private final Collection<String> styles;
    private final Parent parent;

    MultiKeyButton(Parent parent, Collection<String> styles) {
        this.getStyleClass().add((Object)"multi-button");
        this.styles = styles;
        this.parent = parent;
    }

    @Override
    protected void initEventListener(long delay) {
        this.buttonDelay = new Timeline(new KeyFrame[]{new KeyFrame(new Duration((double)delay), event -> this.fireLongPressed(), new KeyValue[0])});
        this.setOnDragDetected(e -> {
            logger.trace((Object)("{" + this.getKeyCode() + "} drag detected"));
            if (this.buttonDelay.getStatus().equals((Object)Animation.Status.RUNNING) && this.buttonDelay.getCurrentRate() > 0.0) {
                this.buttonDelay.stop();
                this.fireLongPressed();
            }
            e.consume();
        });
        this.setOnMouseClicked(event -> {
            logger.trace((Object)("{" + this.getKeyCode() + "} clicked: {" + this.buttonDelay.getCurrentRate() + "}"));
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && this.buttonDelay.getStatus().equals((Object)Animation.Status.RUNNING)) {
                this.buttonDelay.stop();
                this.fireShortPressed();
            }
            this.setFocused(false);
            event.consume();
        });
        this.setOnMousePressed(event -> {
            logger.trace((Object)("{" + this.getKeyCode() + "} pressed: {" + this.buttonDelay.getCurrentRate() + "}"));
            if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
                this.buttonDelay.playFromStart();
            }
            event.consume();
        });
    }

    MultiKeyPopup getContext() {
        if (this.context == null) {
            this.context = new MultiKeyPopup();
            this.context.getStylesheets().setAll(this.styles);
            this.context.setOnHidden(event -> {
                this.parent.setEffect(null);
                this.parent.setDisable(false);
            });
            this.setOnLongPressed((EventHandler<? super KeyButtonEvent>)((EventHandler)event -> {
                Node node = (Node)event.getSource();
                this.parent.setDisable(true);
                this.setFocused(false);
                this.context.show(node, this.parent.getScaleX());
            }));
        }
        return this.context;
    }

    @Override
    public void addExtKeyCode(int extKeyCode, String label) {
        ShortPressKeyButton button = new ShortPressKeyButton();
        button.setText(label);
        button.setKeyCode(extKeyCode);
        if (this.getStyleClass() != null) {
            button.getStyleClass().addAll((Collection)this.getStyleClass());
        } else {
            button.setId("key-context-button");
        }
        button.setFocusTraversable(false);
        button.setPrefWidth(this.getPrefWidth());
        button.setPrefHeight(this.getPrefHeight());
        button.setOnShortPressed(this.getOnShortPressed());
        this.getContext().addButton(button);
    }
}

