/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.util.Optional;

public enum KeyboardType {
    TEXT,
    TEXT_SHIFT,
    SYMBOL,
    SYMBOL_SHIFT,
    CTRL,
    NUMERIC,
    EMAIL,
    URL,
    TR;


    public static Optional<KeyboardType> findValue(Object value) {
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Number) {
            switch (((Number)Number.class.cast(value)).intValue()) {
                case 0: {
                    return Optional.of(TEXT);
                }
                case 1: {
                    return Optional.of(NUMERIC);
                }
                case 2: {
                    return Optional.of(URL);
                }
                case 3: {
                    return Optional.of(EMAIL);
                }
            }
            return Optional.empty();
        }
        for (KeyboardType t : KeyboardType.values()) {
            if (!t.toString().equalsIgnoreCase(value.toString())) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }
}

