/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyButton;
import org.comtel2000.keyboard.control.KeyboardType;
import org.comtel2000.keyboard.control.MultiKeyButton;
import org.comtel2000.keyboard.control.RepeatableKeyButton;
import org.comtel2000.keyboard.control.ShortPressKeyButton;
import org.comtel2000.keyboard.control.StandardKeyCode;
import org.comtel2000.keyboard.event.KeyButtonEvent;
import org.comtel2000.keyboard.robot.FXRobotHandler;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.keyboard.xml.XmlHelper;

public class KeyboardPane
extends Region
implements StandardKeyCode,
EventHandler<KeyButtonEvent> {
    private static final Logger logger = Logger.getLogger(KeyboardPane.class);
    private final EnumMap<KeyboardType, Region> typeRegionMap = new EnumMap(KeyboardType.class);
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private static final String DEFAULT_CSS = "/css/KeyboardButtonStyle.css";
    private String _keyBoardStyle;
    private StringProperty keyBoardStyle;
    private boolean _cacheLayout = true;
    private BooleanProperty cacheLayout;
    private boolean _symbol;
    private BooleanProperty symbol;
    private boolean _shift;
    private BooleanProperty shift;
    private boolean _control;
    private BooleanProperty control;
    private boolean _spaceKeyMove = true;
    private BooleanProperty spaceKeyMove;
    private boolean _capsLock = true;
    private BooleanProperty capsLock;
    private double _scaleOffset = 0.2;
    private DoubleProperty scaleOffset;
    private double _scale = 1.0;
    private DoubleProperty scale;
    private double _minScale = 0.7;
    private DoubleProperty minScale;
    private double _maxScale = 5.0;
    private DoubleProperty maxScale;
    private DefaultLayer _layer = DefaultLayer.DEFAULT;
    private ObjectProperty<DefaultLayer> layer;
    private Path _layerPath;
    private ObjectProperty<Path> layerPath;
    private Locale _locale = Locale.getDefault();
    private ObjectProperty<Locale> locale;
    private Locale _activeLocale;
    private ObjectProperty<Locale> activeLocale;
    private KeyboardType _activeType;
    private ObjectProperty<KeyboardType> activeType;
    private EventHandler<? super Event> closeEventHandler;
    private double mousePressedX;
    private double mousePressedY;
    private final List<IRobot> robots = new ArrayList<IRobot>();
    private final Map<URL, Region> layoutCache = new HashMap<URL, Region>();
    private final Map<Locale, String> availableLocales = new LinkedHashMap<Locale, String>();
    private EventHandler<MouseEvent> movedHandler;
    private EventHandler<MouseEvent> draggedHandler;

    public KeyboardPane() {
        this.getStyleClass().add((Object)"key-background");
        this.setFocusTraversable(false);
    }

    public String getUserAgentStylesheet() {
        return this.getKeyBoardStyle();
    }

    public void load() throws Exception {
        if (this.robots.isEmpty()) {
            logger.debug((Object)"load default fx robot handler");
            this.robots.add(new FXRobotHandler());
        }
        this.getStylesheets().add((Object)this.getKeyBoardStyle());
        this.setLayoutLocale(this.getLocale());
        this.setKeyboardType(KeyboardType.TEXT);
        if (this.getScale() != 1.0) {
            this.setScaleX(this.getScale());
            this.setScaleY(this.getScale());
        }
        this.setOnZoom(e -> {
            double s = this.getScale() * e.getTotalZoomFactor();
            logger.debug((Object)"here we are");
            if (s >= this.getMinScale() && s <= this.getMaxScale()) {
                e.consume();
            }
        });
        this.setOnScroll(e -> {
            double s = this.getScale() + (e.getDeltaY() > 0.0 ? this.getScaleOffset() : -this.getScaleOffset());
            if (s >= this.getMinScale() && s <= this.getMaxScale()) {
                e.consume();
            }
        });
    }

    public void resetLocale() {
        this.switchLocale(this.getLocale());
    }

    public void switchLocale(Locale local) {
        try {
            if (local.equals(this.getActiveLocale())) {
                return;
            }
            this.setLayoutLocale(local);
            this.setActiveType(null);
            this.setKeyboardType(KeyboardType.TEXT);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void switchLayer(DefaultLayer layer) {
        if (layer.equals((Object)this.getLayer())) {
            logger.warn((Object)"layer already selected");
            return;
        }
        try {
            this.setLayerPath(null);
            this.setLayer(layer);
            this.availableLocales.clear();
            this.setActiveLocale(null);
            this.setLayoutLocale(this.getLocale());
            this.setActiveType(null);
            this.setKeyboardType(KeyboardType.TEXT);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setLayoutLocale(Locale local) throws Exception {
        logger.debug((Object)("try to set keyboard local: {" + this.getActiveLocale() + "}->{" + local + "}"));
        Map<Locale, String> localeMap = this.getAvailableLocales();
        if (localeMap.containsKey(local)) {
            if (local.equals(this.getActiveLocale())) {
                logger.debug((Object)("locale already active: {" + local + "}"));
                return;
            }
            this.setActiveLocale(local);
        } else if (localeMap.containsKey(Locale.forLanguageTag(local.getLanguage()))) {
            if (Locale.forLanguageTag(local.getLanguage()).equals(this.getActiveLocale())) {
                logger.debug((Object)("locale language already active: {" + local + "}"));
                return;
            }
            this.setActiveLocale(Locale.forLanguageTag(local.getLanguage()));
        } else {
            if (Locale.ENGLISH.equals(this.getActiveLocale())) {
                logger.info((Object)("locale language already active: {" + local + "}"));
                return;
            }
            this.setActiveLocale(Locale.ENGLISH);
        }
        logger.debug((Object)("use keyboard local: {" + this.getActiveLocale() + "}"));
        String root = localeMap.get(this.getActiveLocale());
        this.addTypeRegion(KeyboardType.TEXT, root, "kb-layout.xml");
        this.addTypeRegion(KeyboardType.TEXT_SHIFT, root, "kb-layout-shift.xml");
        this.addTypeRegion(KeyboardType.SYMBOL, root, "kb-layout-sym.xml");
        this.addTypeRegion(KeyboardType.SYMBOL_SHIFT, root, "kb-layout-sym-shift.xml");
        this.addTypeRegion(KeyboardType.CTRL, root, "kb-layout-ctrl.xml");
        this.addTypeRegion(KeyboardType.NUMERIC, root, "kb-layout-numeric.xml");
        this.addTypeRegion(KeyboardType.EMAIL, root, "kb-layout-email.xml");
        this.addTypeRegion(KeyboardType.URL, root, "kb-layout-url.xml");
    }

    private void addTypeRegion(KeyboardType type, String root, String file) throws Exception {
        URL url = KeyboardPane.class.getResource(root + "/" + file);
        if (url == null && Files.exists(Paths.get(root, file), new LinkOption[0])) {
            url = Paths.get(root, file).toUri().toURL();
        }
        if (url != null) {
            logger.debug((Object)("add layout: {" + url + "}"));
            this.typeRegionMap.put(type, this.getKeyboardPane(url));
            return;
        }
        String defaultRoot = this.getAvailableLocales().get(Locale.ENGLISH);
        if (defaultRoot == null) {
            logger.error((Object)("layout: {" + root + "} / {" + file + "} not found - no default available"));
            return;
        }
        url = KeyboardPane.class.getResource(defaultRoot + "/" + file);
        if (url != null) {
            logger.debug((Object)("add default layout: {" + url + "}"));
            this.typeRegionMap.put(type, this.getKeyboardPane(url));
            return;
        }
        if (Files.exists(Paths.get(defaultRoot, file), new LinkOption[0])) {
            url = Paths.get(defaultRoot, file).toUri().toURL();
            logger.debug((Object)("add default layout: {" + url + "}"));
            this.typeRegionMap.put(type, this.getKeyboardPane(url));
        }
    }

    private Map<Locale, String> getAvailableLocales() {
        if (!this.availableLocales.isEmpty()) {
            return this.availableLocales;
        }
        if (this.getLayerPath() == null) {
            String layer = this.getLayer().toString().toLowerCase(Locale.ENGLISH);
            URL url = Objects.requireNonNull(KeyboardPane.class.getResource("/xml/" + layer));
            logger.debug((Object)("use embedded layer path: {" + url + "}"));
            if (url.toExternalForm().contains("!")) {
                this.availableLocales.put(Locale.ENGLISH, "/xml/" + layer);
                this.readJarLocales(url);
                return this.availableLocales;
            }
            try {
                this.setLayerPath(Paths.get(url.toURI()));
            }
            catch (URISyntaxException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.availableLocales.put(Locale.ENGLISH, this.getLayerPath().toString());
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getLayerPath());){
            for (Path p : stream) {
                if (!Files.isDirectory(p, new LinkOption[0])) continue;
                Locale l = new Locale(p.getFileName().toString());
                this.availableLocales.put(l, p.toString());
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.debug((Object)("locales: {" + this.availableLocales.keySet() + "}"));
        return this.availableLocales;
    }

    private void readJarLocales(URL url) {
        String[] array = url.toExternalForm().split("!");
        try (FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), Collections.emptyMap());){
            Path path = fs.getPath(array[1], new String[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path p : stream) {
                    if (!Files.isDirectory(p, new LinkOption[0])) continue;
                    String lang = p.getFileName().toString().replace("/", "");
                    this.availableLocales.put(new Locale(lang), array[1] + "/" + lang);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setKeyboardType(KeyboardType type) {
        Region pane;
        logger.debug((Object)("try to set type: {" + (Object)((Object)this.getActiveType()) + "}->{" + (Object)((Object)type) + "}"));
        if (type.equals((Object)this.getActiveType())) {
            return;
        }
        this.setActiveType(type);
        switch (type) {
            case NUMERIC: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.getOrDefault((Object)type, this.typeRegionMap.get((Object)KeyboardType.SYMBOL));
                break;
            }
            case EMAIL: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case URL: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case SYMBOL: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(true);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case SYMBOL_SHIFT: {
                this.setControl(false);
                this.setShift(true);
                this.setSymbol(true);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case CTRL: {
                this.setControl(true);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            case TEXT_SHIFT: {
                this.setControl(false);
                this.setShift(true);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
                break;
            }
            default: {
                this.setControl(false);
                this.setShift(false);
                this.setSymbol(false);
                pane = this.typeRegionMap.get((Object)type);
            }
        }
        if (pane == null) {
            pane = this.typeRegionMap.get((Object)KeyboardType.TEXT);
        }
        if (pane != null) {
            this.getChildren().setAll((Object[])new Node[]{pane});
        }
    }

    public void setKeyboardType(Object type) {
        this.setKeyboardType(KeyboardType.findValue(type).orElse(KeyboardType.TEXT));
    }

    private Region getKeyboardPane(URL layout) throws XMLStreamException, IOException {
        if (this.isCacheLayout()) {
            return this.layoutCache.computeIfAbsent(layout, this::createKeyboardPane);
        }
        return this.createKeyboardPane(layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region createKeyboardPane(URL layout) {
        GridPane rowPane = new GridPane();
        rowPane.setAlignment(Pos.CENTER);
        rowPane.getStyleClass().add((Object)"key-background-row");
        int keyWidth = 40;
        int keyHeight = 35;
        int horizontalGap = 10;
        int colIndex = -1;
        int rowIndex = -1;
        int rowWidth = 0;
        int minRowWidth = Integer.MAX_VALUE;
        int maxRowWidth = 0;
        GridPane colPane = null;
        XMLStreamReader reader = null;
        try {
            reader = this.factory.createXMLStreamReader(layout.openStream());
            block22: while (reader.hasNext()) {
                reader.next();
                switch (reader.getEventType()) {
                    case 1: {
                        switch (reader.getLocalName()) {
                            case "Keyboard": {
                                XmlHelper.readIntAttribute(reader, "verticalGap").ifPresent(a -> rowPane.setVgap((double)a.intValue()));
                                horizontalGap = XmlHelper.readIntAttribute(reader, "horizontalGap", horizontalGap);
                                keyWidth = XmlHelper.readIntAttribute(reader, "keyWidth", keyWidth);
                                keyHeight = XmlHelper.readIntAttribute(reader, "keyHeight", keyHeight);
                                break;
                            }
                            case "Row": {
                                ++rowIndex;
                                colIndex = -1;
                                maxRowWidth = Math.max(maxRowWidth, rowWidth);
                                if (rowWidth > 0) {
                                    minRowWidth = Math.min(minRowWidth, rowWidth);
                                }
                                logger.trace((Object)("{" + rowWidth + "} - [{" + minRowWidth + "}/{" + maxRowWidth + "}] url: {" + layout + "}"));
                                rowWidth = 0;
                                colPane = new GridPane();
                                colPane.getStyleClass().add((Object)"key-background-column");
                                rowPane.add((Node)colPane, 0, rowIndex);
                                RowConstraints rc = new RowConstraints();
                                rc.setPrefHeight((double)keyHeight);
                                colPane.getRowConstraints().add((Object)rc);
                                XmlHelper.readAttribute(reader, "rowEdgeFlags").ifPresent(flag -> rc.setValignment(VPos.valueOf((String)flag.toUpperCase())));
                                break;
                            }
                            case "Key": {
                                ++colIndex;
                                ColumnConstraints cc = new ColumnConstraints();
                                cc.setHgrow(Priority.SOMETIMES);
                                cc.setFillWidth(true);
                                cc.setPrefWidth((double)XmlHelper.readIntAttribute(reader, "keyWidth", keyWidth));
                                String code = reader.getAttributeValue(null, "codes");
                                if (code == null || code.isEmpty()) {
                                    Pane placeholder = new Pane();
                                    colPane.add((Node)placeholder, colIndex, 0);
                                    colPane.getColumnConstraints().add((Object)cc);
                                    rowWidth = (int)((double)rowWidth + cc.getPrefWidth());
                                    break;
                                }
                                String[] codes = code.split(",");
                                KeyButton button = codes.length > 1 || code.equals(Integer.toString(-7)) ? new MultiKeyButton((Parent)this, (Collection<String>)this.getStylesheets()) : (XmlHelper.readBooleanAttribute(reader, "repeatable", false) ? new RepeatableKeyButton() : new ShortPressKeyButton());
                                button.setFocusTraversable(false);
                                button.setOnShortPressed(this);
                                button.setMinHeight(1.0);
                                button.setPrefHeight(keyHeight);
                                button.setPrefWidth(keyWidth);
                                button.setMaxWidth(Double.MAX_VALUE);
                                button.setMovable(XmlHelper.readBooleanAttribute(reader, "movable", false));
                                if (button.isMovable()) {
                                    this.installMoveHandler((Node)button);
                                    button.getStyleClass().add((Object)"movable-style");
                                }
                                button.setSticky(XmlHelper.readBooleanAttribute(reader, "sticky", false));
                                if (button.isSticky()) {
                                    button.getStyleClass().add((Object)"sticky-style");
                                }
                                XmlHelper.readAttribute(reader, "keyLabelStyle").ifPresent(s -> {
                                    if (s.charAt(0) == '.') {
                                        for (String style : s.split(";")) {
                                            button.getStyleClass().add((Object)style.substring(1));
                                        }
                                    }
                                });
                                if (codes.length > 0 && !codes[0].isEmpty()) {
                                    button.setKeyCode(XmlHelper.parseInt(codes[0]));
                                }
                                if (codes.length > 1) {
                                    for (int i = 1; i < codes.length; ++i) {
                                        int keyCode = XmlHelper.parseInt(codes[i]);
                                        button.addExtKeyCode(keyCode, Character.toString((char)keyCode));
                                    }
                                }
                                if (button.getKeyCode() == -7) {
                                    for (Locale l : this.getAvailableLocales().keySet()) {
                                        button.addExtKeyCode(-7, l.getLanguage().toUpperCase(Locale.ENGLISH));
                                    }
                                }
                                XmlHelper.readAttribute(reader, "keyIconStyle").ifPresent(s -> {
                                    if (s.charAt(0) == '.') {
                                        logger.trace((Object)("Load css style: {" + s + "}"));
                                        Label icon = new Label();
                                        for (String style : s.split(";")) {
                                            icon.getStyleClass().add((Object)style.substring(1));
                                        }
                                        icon.setMaxSize(40.0, 40.0);
                                        button.setContentDisplay(ContentDisplay.CENTER);
                                        button.setGraphic((Node)icon);
                                    } else if (s.charAt(0) == '@') {
                                        try (InputStream is = KeyboardPane.class.getResourceAsStream(s.replace('@', '/') + ".png");){
                                            Image image = new Image(is);
                                            if (!image.isError()) {
                                                button.setGraphic((Node)new ImageView(image));
                                            } else {
                                                logger.error((Object)("Image: {" + s + "} not found"));
                                            }
                                        }
                                        catch (Exception e) {
                                            logger.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                    }
                                });
                                String label = reader.getAttributeValue(null, "keyLabel");
                                button.setText(label != null ? label : Character.toString((char)button.getKeyCode()));
                                XmlHelper.readAttribute(reader, "keyOutputText").ifPresent(button::setKeyText);
                                cc.setHalignment(HPos.CENTER);
                                button.setAlignment(Pos.BASELINE_CENTER);
                                XmlHelper.readAttribute(reader, "keyEdgeFlags").ifPresent(flag -> {
                                    if (flag.equals("right")) {
                                        cc.setHalignment(HPos.RIGHT);
                                        button.setAlignment(Pos.BASELINE_RIGHT);
                                    } else if (flag.equals("left")) {
                                        cc.setHalignment(HPos.LEFT);
                                        button.setAlignment(Pos.BASELINE_LEFT);
                                    } else {
                                        cc.setHalignment(HPos.CENTER);
                                    }
                                });
                                switch (button.getKeyCode()) {
                                    case 32: {
                                        this.installMoveHandler((Node)button);
                                        break;
                                    }
                                    case -8: 
                                    case -5: {
                                        if (button.isRepeatable()) break;
                                        button.setOnLongPressed((EventHandler<? super KeyButtonEvent>)((EventHandler)e -> {
                                            this.sendToComponent('a', true);
                                            this.sendToComponent('\u007f', this.isControl());
                                        }));
                                        break;
                                    }
                                }
                                colPane.add((Node)button, colIndex, 0);
                                colPane.getColumnConstraints().add((Object)cc);
                                rowWidth = (int)((double)rowWidth + cc.getPrefWidth());
                                break;
                            }
                        }
                        continue block22;
                    }
                    case 8: {
                        continue block22;
                    }
                }
            }
        }
        catch (Exception e2) {
            try {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Throwable throwable) {
                XmlHelper.close(reader);
                throw throwable;
            }
            XmlHelper.close(reader);
        }
        XmlHelper.close(reader);
        return rowPane;
    }

    private void setKeyboardType(boolean ctrl, boolean shift, boolean symbol) {
        if (ctrl) {
            this.setKeyboardType(KeyboardType.CTRL);
            return;
        }
        if (symbol) {
            this.setKeyboardType(shift ? KeyboardType.SYMBOL_SHIFT : KeyboardType.SYMBOL);
            return;
        }
        this.setKeyboardType(shift ? KeyboardType.TEXT_SHIFT : KeyboardType.TEXT);
    }

    public void handle(KeyButtonEvent event) {
        event.consume();
        if (!event.getEventType().equals(KeyButtonEvent.SHORT_PRESSED)) {
            logger.warn((Object)"ignore non short pressed events");
            return;
        }
        KeyButton kb = (KeyButton)event.getSource();
        switch (kb.getKeyCode()) {
            case -1: {
                this.setKeyboardType(this.isControl(), !this.isShift(), this.isSymbol());
                break;
            }
            case -2: {
                this.setKeyboardType(this.isControl(), this.isShift(), !this.isSymbol());
                break;
            }
            case -3: {
                if (this.closeEventHandler == null) {
                    this.fireEvent((Event)new WindowEvent(this.getScene().getWindow(), WindowEvent.WINDOW_CLOSE_REQUEST));
                    break;
                }
                this.closeEventHandler.handle((Event)event);
                break;
            }
            case -4: {
                this.sendToComponent('\t', true);
                break;
            }
            case -5: {
                this.sendToComponent('\b', true);
                break;
            }
            case -8: {
                this.sendToComponent('\u007f', true);
                break;
            }
            case -6: {
                this.setControl(!this.isControl());
                this.setKeyboardType(this.isControl(), this.isShift(), this.isSymbol());
                break;
            }
            case -7: {
                this.switchLocale(Locale.forLanguageTag(kb.getText()));
                break;
            }
            case -9: {
                this.sendToComponent('\n', true);
                break;
            }
            case -10: {
                this.sendToComponent('&', true);
                break;
            }
            case -11: {
                this.sendToComponent('(', true);
                break;
            }
            case -12: {
                this.sendToComponent('%', true);
                break;
            }
            case -13: {
                this.sendToComponent('\'', true);
                break;
            }
            case -14: {
                this.sendToComponent('Z', true);
                break;
            }
            case -15: {
                this.sendToComponent('Y', true);
                break;
            }
            case -20: {
                this.sendToComponent('$', true);
                break;
            }
            case -21: {
                this.sendToComponent('#', true);
                break;
            }
            case -22: {
                this.sendToComponent('!', true);
                break;
            }
            case -23: {
                this.sendToComponent('\"', true);
                break;
            }
            case -24: {
                this.sendToComponent('\u009c', true);
                break;
            }
            case -16: {
                this.setKeyboardType(KeyboardType.NUMERIC);
                break;
            }
            case -17: {
                this.setKeyboardType(KeyboardType.EMAIL);
                break;
            }
            case -18: {
                this.setKeyboardType(KeyboardType.URL);
                break;
            }
            case -19: {
                this.setCapsLock(!this.isCapsLock());
                break;
            }
            case -25: {
                this.sendToComponent('\u009a', true);
                Timeline timeline = new Timeline();
                timeline.setDelay(Duration.millis((double)1000.0));
                double opacity = this.getScene().getWindow().getOpacity();
                this.getScene().getWindow().setOpacity(0.0);
                timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.getScene().getWindow().opacityProperty(), (Object)opacity)}));
                timeline.play();
                break;
            }
            case -123: 
            case -122: 
            case -121: 
            case -120: 
            case -119: 
            case -118: 
            case -117: 
            case -116: 
            case -115: 
            case -114: 
            case -113: 
            case -112: {
                this.sendToComponent((char)Math.abs(kb.getKeyCode()), true);
                break;
            }
            default: {
                if (kb.getKeyText() != null) {
                    for (int i = 0; i < kb.getKeyText().length(); ++i) {
                        this.sendToComponent(kb.getKeyText().charAt(i), this.isControl());
                    }
                } else if (kb.getKeyCode() > -1) {
                    this.sendToComponent((char)kb.getKeyCode(), this.isControl());
                } else {
                    logger.debug((Object)("unknown key code: {" + kb.getKeyCode() + "}"));
                    this.sendToComponent((char)kb.getKeyCode(), true);
                }
                if (this.isCapsLock() || !this.isShift()) break;
                this.setKeyboardType(this.isControl(), !this.isShift(), this.isSymbol());
            }
        }
    }

    private void sendToComponent(char ch, boolean ctrl) {
        logger.trace((Object)("send ({" + ch + "}) ctrl={" + ctrl + "}"));
        if (ctrl) {
            switch (Character.toUpperCase(ch)) {
                case '-': {
                    if (this.getScale() - this.getScaleOffset() >= this.getMinScale()) {
                        this.setScale(this.getScale() - this.getScaleOffset());
                    }
                    return;
                }
                case '+': {
                    if (this.getScale() + this.getScaleOffset() <= this.getMaxScale()) {
                        this.setScale(this.getScale() + this.getScaleOffset());
                    }
                    return;
                }
            }
        }
        if (this.robots.isEmpty()) {
            logger.error((Object)"no robot handler available");
            return;
        }
        for (IRobot robot : this.robots) {
            robot.sendToComponent(this, ch, ctrl);
        }
    }

    public void addRobotHandler(IRobot robot) {
        this.robots.add(robot);
    }

    public void setOnKeyboardCloseButton(EventHandler<? super Event> value) {
        this.closeEventHandler = value;
    }

    public final String getKeyBoardStyle() {
        if (this.keyBoardStyle != null) {
            return (String)this.keyBoardStyle.get();
        }
        if (this._keyBoardStyle == null) {
            URL stylesheet = KeyboardPane.class.getResource(DEFAULT_CSS);
            this._keyBoardStyle = stylesheet.toString();
        }
        return this._keyBoardStyle;
    }

    public final boolean isCacheLayout() {
        return this.cacheLayout == null ? this._cacheLayout : this.cacheLayout.get();
    }

    public final boolean isSymbol() {
        return this.symbol == null ? this._symbol : this.symbol.get();
    }

    public final void setSymbol(boolean s) {
        if (this.symbol == null) {
            this._symbol = s;
        } else {
            this.symbol.set(s);
        }
    }

    public final boolean isShift() {
        return this.shift == null ? this._shift : this.shift.get();
    }

    public final void setShift(boolean s) {
        if (this.shift == null) {
            this._shift = s;
        } else {
            this.shift.set(s);
        }
    }

    public final boolean isControl() {
        return this.control == null ? this._control : this.control.get();
    }

    public final void setControl(boolean s) {
        if (this.control == null) {
            this._control = s;
        } else {
            this.control.set(s);
        }
    }

    public final boolean isSpaceKeyMove() {
        return this.spaceKeyMove == null ? this._spaceKeyMove : this.spaceKeyMove.get();
    }

    public final boolean isCapsLock() {
        return this.capsLock == null ? this._capsLock : this.capsLock.get();
    }

    public final void setCapsLock(boolean s) {
        if (this.capsLock == null) {
            this._capsLock = s;
        } else {
            this.capsLock.set(s);
        }
    }

    public final double getScaleOffset() {
        return this.scaleOffset == null ? this._scaleOffset : this.scaleOffset.get();
    }

    public final double getScale() {
        return this.scale == null ? this._scale : this.scale.get();
    }

    public final void setScale(double s) {
        if (this.scale == null) {
            this._scale = s;
            this.setScaleX(this._scale);
            this.setScaleY(this._scale);
        } else {
            this.scale.set(s);
        }
    }

    public final double getMinScale() {
        return this.minScale == null ? this._minScale : this.minScale.get();
    }

    public final double getMaxScale() {
        return this.maxScale == null ? this._maxScale : this.maxScale.get();
    }

    public final void setMaxScale(double s) {
        if (this.maxScale == null) {
            this._maxScale = s;
        } else {
            this.maxScale.set(s);
        }
    }

    public final DoubleProperty maxScaleProperty() {
        if (this.maxScale == null) {
            this.maxScale = new SimpleDoubleProperty((Object)this, "maxScale", this._maxScale);
        }
        return this.maxScale;
    }

    public final DefaultLayer getLayer() {
        return this.layer == null ? this._layer : (DefaultLayer)((Object)this.layer.get());
    }

    public final void setLayer(DefaultLayer l) {
        if (this.layer == null) {
            this._layer = l;
        } else {
            this.layer.set((Object)l);
        }
    }

    public final ObjectProperty<DefaultLayer> layerProperty() {
        if (this.layer == null) {
            this.layer = new SimpleObjectProperty((Object)this, "layer", (Object)this._layer);
        }
        return this.layer;
    }

    public final Path getLayerPath() {
        return this.layerPath == null ? this._layerPath : (Path)this.layerPath.get();
    }

    public final void setLayerPath(Path l) {
        if (this.layerPath == null) {
            this._layerPath = l;
        } else {
            this.layerPath.set((Object)l);
        }
    }

    public final ObjectProperty<Path> layerPathProperty() {
        if (this.layerPath == null) {
            this.layerPath = new SimpleObjectProperty((Object)this, "layerPath", (Object)this._layerPath);
        }
        return this.layerPath;
    }

    public final Locale getLocale() {
        return this.locale == null ? this._locale : (Locale)this.locale.get();
    }

    public final void setLocale(Locale l) {
        if (this.locale == null) {
            this._locale = l;
        } else {
            this.locale.set((Object)l);
        }
    }

    public final ObjectProperty<Locale> localeProperty() {
        if (this.locale == null) {
            this.locale = new SimpleObjectProperty((Object)this, "locale", (Object)this._locale);
        }
        return this.locale;
    }

    public final Locale getActiveLocale() {
        return this.activeLocale == null ? this._activeLocale : (Locale)this.activeLocale.get();
    }

    public final void setActiveLocale(Locale l) {
        if (this.activeLocale == null) {
            this._activeLocale = l;
        } else {
            this.activeLocale.set((Object)l);
        }
    }

    public final ObjectProperty<Locale> activeLocaleProperty() {
        if (this.activeLocale == null) {
            this.activeLocale = new SimpleObjectProperty((Object)this, "activeLocale", (Object)this._activeLocale);
        }
        return this.activeLocale;
    }

    public final KeyboardType getActiveType() {
        return this.activeType == null ? this._activeType : (KeyboardType)((Object)this.activeType.get());
    }

    public final void setActiveType(KeyboardType l) {
        if (this.activeType == null) {
            this._activeType = l;
        } else {
            this.activeType.set((Object)l);
        }
    }

    public final ObjectProperty<KeyboardType> activeTypeProperty() {
        if (this.activeType == null) {
            this.activeType = new SimpleObjectProperty((Object)this, "activeType", (Object)this._activeType);
        }
        return this.activeType;
    }

    private void installMoveHandler(Node node) {
        if (this.movedHandler == null) {
            this.movedHandler = e -> {
                if (this.isSpaceKeyMove()) {
                    this.mousePressedX = this.getScene().getWindow().getX() - e.getScreenX();
                    this.mousePressedY = this.getScene().getWindow().getY() - e.getScreenY();
                }
            };
        }
        if (this.draggedHandler == null) {
            this.draggedHandler = e -> {
                if (this.isSpaceKeyMove()) {
                    this.getScene().getWindow().setX(e.getScreenX() + this.mousePressedX);
                    this.getScene().getWindow().setY(e.getScreenY() + this.mousePressedY);
                }
            };
        }
        node.setOnMouseMoved(this.movedHandler);
        node.setOnMouseDragged(this.draggedHandler);
    }
}

