/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import com.sun.javafx.css.StyleManager;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javafx.animation.FadeTransition;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.comtel2000.keyboard.FXOK;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.control.KeyboardType;
import org.comtel2000.keyboard.control.VkProperties;

public class KeyBoardPopup
extends Popup
implements VkProperties {
    private static final String STYLE_CSS = "/css/KeyboardTextInputSkin.css";
    private final KeyboardPane keyboard;
    private Scene owner;
    private double _offset = 5.0;
    private DoubleProperty offset;
    private FadeTransition animation;
    public static final EventHandler<? super Event> DEFAULT_CLOSE_HANDLER = event -> {
        if (event.getSource() instanceof Node) {
            ((Node)event.getSource()).fireEvent((Event)new WindowEvent(null, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
    };

    public KeyBoardPopup(KeyboardPane panel) {
        this.keyboard = Objects.requireNonNull(panel);
        this.getContent().add((Object)this.keyboard);
    }

    public final KeyboardPane getKeyBoard() {
        return this.keyboard;
    }

    public boolean isVisible() {
        return this.isShowing();
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible ? Visiblity.SHOW : Visiblity.HIDE);
    }

    public Scene getRegisteredScene() {
        return this.owner;
    }

    public void registerScene(Scene scene) {
        this.owner = Objects.requireNonNull(scene);
    }

    public void addFocusListener(Scene scene) {
        this.addFocusListener(scene, false);
    }

    public void addFocusListener(Scene scene, boolean doNotOpen) {
        this.registerScene(scene);
        scene.focusOwnerProperty().addListener((value, n1, n2) -> {
            if (n2 instanceof TextInputControl) {
                this.setVisible(doNotOpen ? Visiblity.POS : Visiblity.SHOW, (TextInputControl)n2);
            } else if (n2 instanceof Parent) {
                TextInputControl control = KeyBoardPopup.findTextInputControl((Parent)n2);
                this.setVisible(control != null ? (doNotOpen ? Visiblity.POS : Visiblity.SHOW) : Visiblity.HIDE, control);
            } else {
                this.setVisible(Visiblity.HIDE);
            }
        });
    }

    public void addGlobalFocusListener() {
        this.addGlobalFocusListener("MODENA");
    }

    public void addGlobalFocusListener(String url) {
        FXOK.registerPopup(this);
        Application.setUserAgentStylesheet((String)url);
        StyleManager.getInstance().addUserAgentStylesheet(KeyBoardPopup.getUserAgentStyleSheet());
    }

    public static String getUserAgentStyleSheet() {
        return KeyBoardPopup.class.getResource(STYLE_CSS).toExternalForm();
    }

    private static TextInputControl findTextInputControl(Parent parent) {
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (!(child instanceof TextInputControl)) continue;
            return (TextInputControl)child;
        }
        return null;
    }

    public void addDoubleClickEventFilter(Stage stage) {
        Objects.requireNonNull(stage).addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            Node node;
            if (event.getClickCount() == 2 && stage.getScene() != null && (node = stage.getScene().getFocusOwner()) instanceof TextInputControl) {
                this.setVisible(Visiblity.SHOW, (TextInputControl)node);
            }
        });
    }

    public void setOnKeyboardCloseButton(EventHandler<? super Event> value) {
        this.getKeyBoard().setOnKeyboardCloseButton(value);
    }

    void setVisible(Visiblity visible) {
        this.setVisible(visible, null);
    }

    void setVisible(Visiblity visible, TextInputControl textNode) {
        if ((visible == Visiblity.POS || visible == Visiblity.SHOW) && textNode != null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double width = screenSize.getWidth();
            double height = screenSize.getHeight();
            Map<String, Object> vkProps = FXOK.getVkProperties((Node)textNode);
            Bounds textNodeBounds = textNode.localToScreen(textNode.getBoundsInLocal());
            Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
            this.getKeyBoard().setKeyboardType(KeyboardType.TEXT_SHIFT);
            this.setX(0.0);
            this.setY(height / 4.0 * 3.0);
            this.getKeyBoard().setScaleY(1.0);
            this.getKeyBoard().setScaleX(1.0);
            if (!vkProps.isEmpty()) {
                if (vkProps.containsValue(1)) {
                    this.getKeyBoard().setScaleY(1.0);
                    this.getKeyBoard().setScaleX(1.0);
                    this.getKeyBoard().setKeyboardType(vkProps.getOrDefault("vkType", String.valueOf(0)));
                    this.setX(textNodeBounds.getMinX() - this.getWidth());
                    this.setY(textNodeBounds.getMinY() + textNodeBounds.getHeight());
                }
                if (vkProps.containsValue(4)) {
                    this.getKeyBoard().setScaleY(0.0);
                    this.getKeyBoard().setScaleX(0.0);
                }
                if (vkProps.containsValue(5)) {
                    this.setX(textNodeBounds.getMinX() + textNodeBounds.getWidth());
                    this.setY(textNodeBounds.getMinY() + textNodeBounds.getHeight());
                }
                if (vkProps.containsValue(6)) {
                    this.setX(width / 6.0);
                    this.setY(height / 4.0 * 3.0);
                }
                if (vkProps.containsValue(2)) {
                    this.getKeyBoard().setScaleY(1.5);
                    this.getKeyBoard().setScaleX(1.5);
                }
                if (vkProps.containsValue(3)) {
                    this.getKeyBoard().setScaleY(1.75);
                    this.getKeyBoard().setScaleX(1.75);
                }
                if (vkProps.containsValue(7)) {
                    this.getKeyBoard().setScaleY(2.0);
                    this.getKeyBoard().setScaleX(2.0);
                }
                if (vkProps.containsKey("vkLocale")) {
                    this.getKeyBoard().switchLocale(new Locale(vkProps.get("vkLocale").toString()));
                }
            }
        }
        if (visible == Visiblity.POS || visible == Visiblity.HIDE && !this.isShowing()) {
            return;
        }
        if (this.animation != null) {
            this.animation.stop();
        } else {
            this.animation = new FadeTransition(Duration.millis((double)100.0), (Node)this.getKeyBoard());
            this.animation.setOnFinished(e -> {
                if (this.animation.toValueProperty().get() == 0.0) {
                    this.hide();
                }
            });
        }
        this.animation.setFromValue(visible == Visiblity.SHOW ? 0.0 : 1.0);
        this.animation.setToValue(visible == Visiblity.SHOW ? 1.0 : 0.0);
        if (visible == Visiblity.SHOW && !this.isShowing()) {
            super.show(this.owner != null ? this.owner.getWindow() : this.getOwnerWindow());
        }
        this.animation.playFromStart();
    }

    public final double getOffset() {
        return this.offset == null ? this._offset : this.offset.get();
    }

    public final void setOffset(double value) {
        if (this.offset == null) {
            this._offset = value;
        } else {
            this.offset.set(value);
        }
    }

    public final DoubleProperty offsetProperty() {
        if (this.offset == null) {
            this.offset = new SimpleDoubleProperty((Object)this, "offset", this._offset);
        }
        return this.offset;
    }

    static enum Visiblity {
        SHOW,
        HIDE,
        POS;

    }
}

