/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.TextInputControl;
import javafx.stage.Screen;
import javafx.util.Duration;
import org.comtel2000.keyboard.control.KeyBoardPopup;
import org.comtel2000.keyboard.control.KeyboardType;
import org.comtel2000.keyboard.control.VkProperties;

public class FXOK
implements VkProperties {
    private static KeyBoardPopup popup;
    private static FadeTransition animation;

    private FXOK() {
    }

    public static void registerPopup(KeyBoardPopup p) {
        popup = p;
    }

    public static void setVisible(Visiblity visible) {
        FXOK.setVisible(visible, null);
    }

    public static void setVisible(Visiblity visible, TextInputControl textNode) {
        if (popup == null) {
            return;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        Bounds textNodeBounds = textNode.localToScreen(textNode.getBoundsInLocal());
        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
        if ((visible == Visiblity.POS || visible == Visiblity.SHOW) && textNode != null) {
            Map<String, Object> vkProps = FXOK.getVkProperties((Node)textNode);
            popup.getKeyBoard().setScaleY(1.0);
            popup.getKeyBoard().setKeyboardType(KeyboardType.TEXT);
            popup.setX(0.0);
            popup.setY(height / 4.0 * 3.0);
            popup.getKeyBoard().setScaleY(1.0);
            popup.getKeyBoard().setScaleX(1.0);
            if (!vkProps.isEmpty()) {
                if (vkProps.containsValue(1)) {
                    popup.getKeyBoard().setScaleY(1.0);
                    popup.getKeyBoard().setScaleX(1.0);
                    popup.getKeyBoard().setKeyboardType(vkProps.getOrDefault("vkType", String.valueOf(0)));
                    popup.setX(textNodeBounds.getMinX() - popup.getWidth());
                    popup.setY(textNodeBounds.getMinY() + textNodeBounds.getHeight());
                }
                if (vkProps.containsValue(4)) {
                    popup.getKeyBoard().setScaleY(0.0);
                    popup.getKeyBoard().setScaleX(0.0);
                }
                if (vkProps.containsValue(5)) {
                    popup.setX(textNodeBounds.getMinX() + textNodeBounds.getWidth());
                    popup.setY(textNodeBounds.getMinY() + textNodeBounds.getHeight());
                }
                if (vkProps.containsValue(6)) {
                    popup.setX(width / 6.0);
                    popup.setY(height / 4.0 * 3.0);
                }
                if (vkProps.containsValue(2)) {
                    popup.getKeyBoard().setScaleY(1.5);
                    popup.getKeyBoard().setScaleX(1.5);
                }
                if (vkProps.containsValue(3)) {
                    popup.getKeyBoard().setScaleY(1.75);
                    popup.getKeyBoard().setScaleX(1.75);
                }
                if (vkProps.containsValue(7)) {
                    popup.getKeyBoard().setScaleY(2.0);
                    popup.getKeyBoard().setScaleX(2.0);
                }
                if (vkProps.containsKey("vkLocale")) {
                    popup.getKeyBoard().switchLocale(new Locale(vkProps.get("vkLocale").toString()));
                }
            }
        }
        if (visible == Visiblity.POS || visible == Visiblity.HIDE && !popup.isShowing()) {
            return;
        }
        if (animation != null) {
            animation.stop();
        } else {
            animation = new FadeTransition(Duration.millis((double)100.0), (Node)popup.getKeyBoard());
            animation.setOnFinished(e -> {
                if (animation.toValueProperty().get() == 0.0) {
                    popup.hide();
                }
            });
        }
        animation.setFromValue(visible == Visiblity.SHOW ? 0.0 : 1.0);
        animation.setToValue(visible == Visiblity.SHOW ? 1.0 : 0.0);
        if (visible == Visiblity.SHOW && !popup.isShowing()) {
            popup.show(textNode.getScene().getWindow());
        }
        animation.playFromStart();
    }

    public static Map<String, Object> getVkProperties(Node node) {
        if (node.hasProperties()) {
            HashMap<String, Object> vkProps = new HashMap<String, Object>(3);
            node.getProperties().forEach((key, value) -> {
                if (key.toString().startsWith("vk")) {
                    vkProps.put(String.valueOf(key), value);
                }
            });
            return vkProps;
        }
        if (node.getParent() != null && node.getParent().hasProperties()) {
            HashMap<String, Object> vkProps = new HashMap<String, Object>(3);
            node.getParent().getProperties().forEach((key, value) -> {
                if (key.toString().startsWith("vk")) {
                    vkProps.put(String.valueOf(key), String.valueOf(value));
                }
            });
            return vkProps;
        }
        return Collections.emptyMap();
    }

    public static void updateVisibilty(Scene scene, TextInputControl textInput) {
        if (textInput.isEditable() && textInput.isFocused()) {
            FXOK.setVisible(Visiblity.SHOW, textInput);
        } else if (!(scene != null && scene.getWindow() != null && scene.getWindow().isFocused() && scene.getFocusOwner() instanceof TextInputControl && ((TextInputControl)scene.getFocusOwner()).isEditable())) {
            FXOK.setVisible(Visiblity.HIDE, textInput);
        } else {
            FXOK.setVisible(Visiblity.POS, textInput);
        }
    }

    public static enum Visiblity {
        SHOW,
        HIDE,
        POS;

    }
}

