/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.swing.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.util.Duration;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.comtel2000.keyboard.control.KeyBoardPopup;
import org.comtel2000.keyboard.control.KeyboardType;
import org.comtel2000.swing.control.KeyBoardWindow;
import org.comtel2000.swing.ui.EventCallback;
import org.comtel2000.swing.ui.KeyboardPasswordFieldUI;
import org.comtel2000.swing.ui.KeyboardTextAreaUI;
import org.comtel2000.swing.ui.KeyboardTextFieldUI;

public class KeyboardUIManagerTool {
    public static void installKeyboardDefaults(FocusListener fl, MouseListener ml) {
        UIManager.put("TextFieldUI", KeyboardTextFieldUI.class.getName());
        UIManager.put("PasswordFieldUI", KeyboardPasswordFieldUI.class.getName());
        UIManager.put("TextAreaUI", KeyboardTextAreaUI.class.getName());
        KeyboardTextFieldUI.setFocusListener(fl);
        KeyboardTextFieldUI.setMouseListener(ml);
        KeyboardPasswordFieldUI.setFocusListener(fl);
        KeyboardPasswordFieldUI.setMouseListener(ml);
        KeyboardTextAreaUI.setFocusListener(fl);
        KeyboardTextAreaUI.setMouseListener(ml);
    }

    public static void installKeyboardDefaults(EventCallback callback) {
        KeyboardUIManagerTool.installKeyboardDefaults(KeyboardUIManagerTool.createFocusListener(callback), KeyboardUIManagerTool.createMouseDoubleClickListener(callback));
    }

    public static void installKeyboardDefaults(KeyBoardWindow window) {
        SwingCallback callback = new SwingCallback(window);
        KeyboardUIManagerTool.installKeyboardDefaults(KeyboardUIManagerTool.createFocusListener(callback), KeyboardUIManagerTool.createMouseDoubleClickListener(callback));
    }

    private static FocusListener createFocusListener(final EventCallback c) {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                c.call(null, false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                c.call(e.getComponent(), true);
            }
        };
    }

    private static MouseListener createMouseDoubleClickListener(final EventCallback c) {
        return new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 || e.getClickCount() == 2) {
                    c.call(e.getComponent(), true);
                }
            }
        };
    }

    static class SwingCallback
    implements EventCallback {
        private final KeyBoardWindow window;
        private Component initPosition;
        private Transition transition;

        public SwingCallback(KeyBoardWindow window) {
            this.window = window;
        }

        @Override
        public void call(Component comp, boolean show) {
            if (!this.window.getKeyBoardPopup().isPresent()) {
                this.initPosition = comp;
                return;
            }
            KeyBoardPopup popup = this.window.getKeyBoardPopup().get();
            Component location = show && comp == null ? this.initPosition : comp;
            Platform.runLater(() -> {
                if (show && location != null) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    double width = screenSize.getWidth();
                    double height = screenSize.getHeight();
                    popup.setX(0.0);
                    popup.setY(height / 4.0 * 3.0);
                    if (location instanceof JTextComponent) {
                        JTextComponent textComponent = (JTextComponent)location;
                        Object type = textComponent.getDocument().getProperty("vkType");
                        Object locale = textComponent.getDocument().getProperty("vkLocale");
                        if (locale != null) {
                            popup.getKeyBoard().switchLocale(new Locale((String)locale));
                        }
                        if (type != null) {
                            if ((Integer)type == 4) {
                                popup.getKeyBoard().setScaleY(0.0);
                            } else {
                                popup.getKeyBoard().setScaleY(1.0);
                                popup.getKeyBoard().setKeyboardType((Object)((Integer)type));
                                popup.setX(location.getLocationOnScreen().getX() - popup.getWidth());
                                popup.setY(location.getLocationOnScreen().getY() + (double)location.getHeight());
                            }
                        } else {
                            popup.getKeyBoard().setScaleY(1.0);
                            popup.getKeyBoard().setKeyboardType(KeyboardType.TEXT);
                        }
                    }
                }
                if (this.transition == null) {
                    this.transition = new FadeTransition(Duration.seconds((double)0.1), (Node)popup.getKeyBoard());
                }
                if (show) {
                    if (popup.isVisible() && this.transition.getStatus() == Animation.Status.STOPPED) {
                        return;
                    }
                    this.transition.setOnFinished(event -> {});
                    this.transition.stop();
                    popup.getKeyBoard().setOpacity(0.0);
                    popup.setVisible(true);
                    ((FadeTransition)this.transition).setFromValue(0.0);
                    ((FadeTransition)this.transition).setToValue(1.0);
                    this.transition.play();
                } else {
                    if (!popup.isVisible() && this.transition.getStatus() == Animation.Status.STOPPED) {
                        return;
                    }
                    this.transition.stop();
                    this.transition.setOnFinished(event -> popup.setVisible(false));
                    ((FadeTransition)this.transition).setFromValue(1.0);
                    ((FadeTransition)this.transition).setToValue(0.0);
                    this.transition.play();
                }
            });
        }
    }
}

