/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.swing.robot;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import org.apache.log4j.Logger;
import org.comtel2000.keyboard.robot.IRobot;

public class NativeAsciiRobotHandler
implements IRobot {
    private static Logger logger = Logger.getLogger(NativeAsciiRobotHandler.class);
    private final int controlKeyEvent;

    public NativeAsciiRobotHandler() {
        String osName = System.getProperty("os.name");
        this.controlKeyEvent = osName.startsWith("Mac") ? 157 : 17;
    }

    public void sendToComponent(Object kb, char ch, boolean ctrl) {
        logger.trace((Object)("fire: {" + ch + "} ctrl:{" + ctrl + "}"));
        this.send(ch, ctrl);
    }

    private void send(char ch, boolean ctrl) {
        boolean isUpperCase;
        Robot robot;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (ctrl) {
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u001b': 
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '\u007f': 
                case '\u009a': 
                case '\u009c': 
                case '\uffc9': 
                case '\uffcb': {
                    robot.keyPress(ch);
                    robot.keyRelease(ch);
                    return;
                }
            }
            char upperCase = Character.toUpperCase(ch);
            switch (upperCase) {
                case 'A': 
                case 'C': 
                case 'V': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    robot.keyPress(this.controlKeyEvent);
                    robot.keyPress(upperCase);
                    robot.keyRelease(upperCase);
                    robot.keyRelease(this.controlKeyEvent);
                    return;
                }
            }
        }
        int keyCode = KeyEvent.getExtendedKeyCodeForChar(ch);
        if (Character.isWhitespace(ch)) {
            robot.keyPress(keyCode);
            robot.keyRelease(keyCode);
            return;
        }
        if (0 == keyCode || keyCode > 10000) {
            this.clipboardTransfer(robot, ch);
            return;
        }
        boolean bl = isUpperCase = Character.isUpperCase(ch) || Character.isDigit(ch);
        if (isUpperCase) {
            robot.keyPress(16);
        }
        try {
            robot.keyPress(keyCode);
            robot.keyRelease(keyCode);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)(e.getMessage() + String.format(" %s (%s)", keyCode, Character.valueOf(ch))));
            if (isUpperCase) {
                robot.keyRelease(16);
            }
            this.clipboardTransfer(robot, ch);
            return;
        }
        if (isUpperCase) {
            robot.keyRelease(16);
        }
    }

    void winAltDump(Robot robot, int ch) {
        robot.keyPress(18);
        for (int i = 3; i >= 0; --i) {
            int vk = ch / (int)Math.pow(10.0, i) % 10 + 96;
            logger.debug((Object)("{" + vk + "} - {" + KeyEvent.getKeyText(vk) + "}"));
            robot.keyPress(vk);
            robot.keyRelease(vk);
        }
        robot.keyRelease(18);
    }

    private void clipboardTransfer(Robot robot, char ch) {
        try {
            StringSelection stringSelection = new StringSelection(Character.toString(ch));
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
            robot.keyPress(this.controlKeyEvent);
            robot.keyPress(86);
            robot.keyRelease(86);
            robot.keyRelease(this.controlKeyEvent);
            robot.delay(50);
            Object recover = clpbrd.isDataFlavorAvailable(DataFlavor.stringFlavor) ? clpbrd.getData(DataFlavor.stringFlavor) : null;
            StringSelection recoverSelection = new StringSelection(recover != null ? recover.toString() : "");
            clpbrd.setContents(recoverSelection, null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

