/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.swing.robot;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.comtel2000.keyboard.robot.IRobot;

public class AWTRobotHandler
implements IRobot {
    private static Logger logger = Logger.getLogger(AWTRobotHandler.class);
    private final int controlDownMask;

    public AWTRobotHandler() {
        String osName = System.getProperty("os.name");
        this.controlDownMask = osName.toLowerCase().startsWith("mac") ? 256 : 128;
    }

    public void sendToComponent(Object source, char ch, boolean ctrl) {
        logger.trace((Object)("fire: {" + ch + "}"));
        SwingUtilities.invokeLater(() -> this.send(ch, ctrl));
    }

    private void send(char ch, boolean ctrl) {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c == null || !c.isEnabled()) {
            logger.warn((Object)"no awt focus owner");
            return;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (ctrl) {
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u001b': 
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '\u007f': 
                case '\u009a': 
                case '\u009c': 
                case '\uffc9': 
                case '\uffcb': {
                    kfm.dispatchKeyEvent(new KeyEvent(c, 401, System.currentTimeMillis(), 0, ch, ch, 1));
                    kfm.dispatchKeyEvent(new KeyEvent(c, 402, System.currentTimeMillis(), 0, ch, ch, 1));
                    return;
                }
            }
            int keycode = KeyEvent.getExtendedKeyCodeForChar(ch);
            if (keycode != 0) {
                kfm.dispatchKeyEvent(new KeyEvent(c, 401, System.currentTimeMillis(), this.controlDownMask, keycode, ch, 1));
                kfm.dispatchKeyEvent(new KeyEvent(c, 402, System.currentTimeMillis(), this.controlDownMask, keycode, ch, 1));
                return;
            }
        }
        int modififiers = Character.isUpperCase(ch) ? 64 : 0;
        kfm.dispatchKeyEvent(new KeyEvent(c, 401, System.currentTimeMillis(), modififiers, 0, ch, 1));
        kfm.dispatchKeyEvent(new KeyEvent(c, 400, System.currentTimeMillis(), modififiers, 0, ch, 0));
        kfm.dispatchKeyEvent(new KeyEvent(c, 402, System.currentTimeMillis(), modififiers, 0, ch, 1));
    }
}

