/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.swing.control;

import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.util.Builder;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyBoardBuilder;
import org.comtel2000.keyboard.control.KeyBoardPopup;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.swing.control.KeyBoardWindow;

public class KeyBoardWindowBuilder
implements Builder<KeyBoardWindow> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final KeyBoardBuilder kb = KeyBoardBuilder.create();

    KeyBoardWindowBuilder() {
    }

    public static KeyBoardWindowBuilder create() {
        return new KeyBoardWindowBuilder();
    }

    public KeyBoardWindowBuilder layerPath(Path path) {
        this.kb.layerPath(path);
        return this;
    }

    public KeyBoardWindowBuilder initLocale(Locale locale) {
        this.kb.initLocale(locale);
        return this;
    }

    public KeyBoardWindowBuilder initScale(double scale) {
        this.kb.initScale(scale);
        return this;
    }

    public KeyBoardWindowBuilder addIRobot(IRobot robot) {
        this.kb.addIRobot(robot);
        return this;
    }

    public KeyBoardWindowBuilder layer(DefaultLayer layer) {
        this.kb.layer(layer);
        return this;
    }

    public KeyBoardWindowBuilder style(String css) {
        this.kb.style(css);
        return this;
    }

    public KeyBoardWindow build() {
        KeyBoardWindow window = new KeyBoardWindow();
        Platform.runLater(() -> {
            KeyBoardPopup popup = new KeyBoardPopup(this.kb.build());
            window.createScene(popup);
            this.latch.countDown();
        });
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return window;
    }
}

