/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Predicate;

public class NioFilesWrapper {
    private static final NioFilesWrapper INSTANCE = new NioFilesWrapper();

    static NioFilesWrapper instance() {
        return INSTANCE;
    }

    private NioFilesWrapper() {
    }

    public boolean isRegularFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    public boolean isSymbolicLink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean exists(Path path, LinkOption ... options) {
        return Files.exists(path, options);
    }

    public boolean notExists(Path path, LinkOption ... options) {
        return Files.notExists(path, options);
    }

    public boolean isReadable(Path path) {
        return Files.isReadable(path);
    }

    public boolean isWritable(Path path) {
        return Files.isWritable(path);
    }

    public boolean isExecutable(Path path) {
        return Files.isExecutable(path);
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return Files.newInputStream(path, options);
    }

    public DirectoryStream<Path> newDirectoryStream(Path path, Predicate<Path> matcher) throws IOException {
        return Files.newDirectoryStream(path, matcher::test);
    }

    public long size(Path path) throws IOException {
        return Files.size(path);
    }
}

