/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.IntrospectionError;

public class IgnoringFieldsComparator
extends FieldByFieldComparator {
    private final String[] fields;

    public IgnoringFieldsComparator(Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        super(comparatorByPropertyOrField, comparatorByType);
        this.fields = fields;
    }

    public IgnoringFieldsComparator(String ... fields) {
        this(new HashMap(), TypeComparators.defaultTypeComparators(), fields);
    }

    @VisibleForTesting
    public String[] getFields() {
        return this.fields;
    }

    @Override
    protected boolean areEqual(Object actualElement, Object otherElement) {
        try {
            return Objects.instance().areEqualToIgnoringGivenFields(actualElement, otherElement, this.comparatorsByPropertyOrField, this.comparatorsByType, this.fields);
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    @Override
    protected String description() {
        return "field/property by field/property comparator on all fields/properties except " + ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this.fields);
    }
}

