/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Type;

public class ResultCollector {
    private final Set<String> classes = new HashSet<String>();

    public Set<String> getDependencies() {
        return this.classes;
    }

    public void addName(String name) {
        if (name == null) {
            return;
        }
        if (name.charAt(0) == '[') {
            int i = 0;
            while (name.charAt(++i) == '[') {
            }
            if (name.charAt(i) != 'L') {
                return;
            }
            name = name.substring(i + 1, name.length() - 1);
        }
        this.add(name.replace('/', '.'));
    }

    void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName());
                break;
            }
        }
    }

    public void add(String name) {
        if (name.indexOf(36) < 0) {
            this.classes.add(name);
        }
    }

    void addNames(String[] names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            this.addName(name);
        }
    }

    void addMethodDesc(String desc) {
        Type[] types;
        this.addType(Type.getReturnType((String)desc));
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            this.addType(type);
        }
    }
}

