/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromDependencies;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.fromDependencies.AbstractFromDependenciesMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.filters.DestFileFilter;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstallerException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;

@Mojo(name="copy-dependencies", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class CopyDependenciesMojo
extends AbstractFromDependenciesMojo {
    @Parameter(property="mdep.copyPom", defaultValue="false")
    protected boolean copyPom = true;
    @Component
    private ArtifactInstaller installer;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(property="mdep.useBaseVersion", defaultValue="true")
    protected boolean useBaseVersion = true;
    @Parameter(property="mdep.addParentPoms", defaultValue="false")
    protected boolean addParentPoms;
    @Parameter
    protected boolean ignorePermissions;

    @Override
    protected void doExecute() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact, this.addParentPoms);
        Set<Artifact> artifacts = dss.getResolvedDependencies();
        if (!this.useRepositoryLayout) {
            for (Artifact artifact2 : artifacts) {
                this.copyArtifact(artifact2, this.isStripVersion(), this.prependGroupId, this.useBaseVersion, this.stripClassifier);
            }
        } else {
            ProjectBuildingRequest buildingRequest = this.getRepositoryManager().setLocalRepositoryBasedir(this.session.getProjectBuildingRequest(), this.outputDirectory);
            artifacts.forEach(artifact -> this.installArtifact((Artifact)artifact, buildingRequest));
        }
        Set<Artifact> skippedArtifacts = dss.getSkippedDependencies();
        for (Artifact artifact3 : skippedArtifacts) {
            this.getLog().info((CharSequence)(artifact3.getId() + " already exists in destination."));
        }
        if (this.isCopyPom() && !this.useRepositoryLayout) {
            this.copyPoms(this.getOutputDirectory(), artifacts, this.stripVersion);
            this.copyPoms(this.getOutputDirectory(), skippedArtifacts, this.stripVersion, this.stripClassifier);
        }
    }

    private void installArtifact(Artifact artifact, ProjectBuildingRequest buildingRequest) {
        try {
            Artifact pomArtifact;
            this.installer.install(buildingRequest, Collections.singletonList(artifact));
            this.installBaseSnapshot(artifact, buildingRequest);
            if (!"pom".equals(artifact.getType()) && this.isCopyPom() && (pomArtifact = this.getResolvedPomArtifact(artifact)) != null && pomArtifact.getFile() != null && pomArtifact.getFile().exists()) {
                this.installer.install(buildingRequest, Collections.singletonList(pomArtifact));
                this.installBaseSnapshot(pomArtifact, buildingRequest);
            }
        }
        catch (ArtifactInstallerException e) {
            this.getLog().warn((CharSequence)("unable to install " + artifact), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installBaseSnapshot(Artifact artifact, ProjectBuildingRequest buildingRequest) throws ArtifactInstallerException {
        if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
            String version = artifact.getVersion();
            try {
                artifact.setVersion(artifact.getBaseVersion());
                this.installer.install(buildingRequest, Collections.singletonList(artifact));
            }
            finally {
                artifact.setVersion(version);
            }
        }
    }

    protected void copyArtifact(Artifact artifact, boolean removeVersion, boolean prependGroupId, boolean theUseBaseVersion) throws MojoExecutionException {
        this.copyArtifact(artifact, removeVersion, prependGroupId, theUseBaseVersion, false);
    }

    protected void copyArtifact(Artifact artifact, boolean removeVersion, boolean prependGroupId, boolean theUseBaseVersion, boolean removeClassifier) throws MojoExecutionException {
        String destFileName = DependencyUtil.getFormattedFileName(artifact, removeVersion, prependGroupId, theUseBaseVersion, removeClassifier);
        File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerScope, this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.stripType, this.outputDirectory, artifact);
        File destFile = new File(destDir, destFileName);
        this.copyFile(artifact.getFile(), destFile);
    }

    public void copyPoms(File destDir, Set<Artifact> artifacts, boolean removeVersion) throws MojoExecutionException {
        this.copyPoms(destDir, artifacts, removeVersion, false);
    }

    public void copyPoms(File destDir, Set<Artifact> artifacts, boolean removeVersion, boolean removeClassifier) throws MojoExecutionException {
        for (Artifact artifact : artifacts) {
            File pomDestFile;
            Artifact pomArtifact = this.getResolvedPomArtifact(artifact);
            if (pomArtifact == null || pomArtifact.getFile() == null || !pomArtifact.getFile().exists() || (pomDestFile = new File(destDir, DependencyUtil.getFormattedFileName(pomArtifact, removeVersion, this.prependGroupId, this.useBaseVersion, removeClassifier))).exists()) continue;
            this.copyFile(pomArtifact.getFile(), pomDestFile);
        }
    }

    protected Artifact getResolvedPomArtifact(Artifact artifact) {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(artifact.getGroupId());
        coordinate.setArtifactId(artifact.getArtifactId());
        coordinate.setVersion(artifact.getVersion());
        coordinate.setExtension("pom");
        Artifact pomArtifact = null;
        try {
            ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
            pomArtifact = this.getArtifactResolver().resolveArtifact(buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
        }
        catch (ArtifactResolverException e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        return pomArtifact;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, this.useSubDirectoryPerArtifact, this.useSubDirectoryPerType, this.useSubDirectoryPerScope, this.useRepositoryLayout, this.stripVersion, this.prependGroupId, this.useBaseVersion, this.outputDirectory);
    }

    public boolean isCopyPom() {
        return this.copyPom;
    }

    public void setCopyPom(boolean copyPom) {
        this.copyPom = copyPom;
    }
}

