/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.plugin.compiler.DependencyExclusion;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.incremental.IncrementalBuildHelper;
import org.apache.maven.shared.incremental.IncrementalBuildHelperRequest;
import org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.DirectoryScanResult;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.objectweb.asm.ClassWriter;

public abstract class AbstractCompilerMojo
extends AbstractMojo {
    protected static final String PS = System.getProperty("path.separator");
    private static final String INPUT_FILES_LST_FILENAME = "inputFiles.lst";
    static final String DEFAULT_SOURCE = "1.8";
    static final String DEFAULT_TARGET = "1.8";
    static final String MODULE_INFO_TARGET = "1.9";
    @Parameter(property="maven.compiler.failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter(property="maven.compiler.failOnWarning", defaultValue="false")
    private boolean failOnWarning;
    @Parameter(property="maven.compiler.debug", defaultValue="true")
    private boolean debug = true;
    @Parameter(property="maven.compiler.parameters", defaultValue="false")
    private boolean parameters;
    @Parameter(property="maven.compiler.enablePreview", defaultValue="false")
    private boolean enablePreview;
    @Parameter(property="maven.compiler.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="maven.compiler.showDeprecation", defaultValue="false")
    private boolean showDeprecation;
    @Deprecated
    @Parameter(property="maven.compiler.optimize", defaultValue="false")
    private boolean optimize;
    @Parameter(property="maven.compiler.showWarnings", defaultValue="true")
    private boolean showWarnings;
    @Parameter(property="maven.compiler.source", defaultValue="1.8")
    protected String source;
    @Parameter(property="maven.compiler.target", defaultValue="1.8")
    protected String target;
    @Parameter(property="maven.compiler.release")
    protected String release;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;
    @Parameter(property="maven.compiler.compilerId", defaultValue="javac")
    private String compilerId;
    @Parameter(property="maven.compiler.compilerVersion")
    private String compilerVersion;
    @Parameter(property="maven.compiler.fork", defaultValue="false")
    private boolean fork;
    @Parameter(property="maven.compiler.meminitial")
    private String meminitial;
    @Parameter(property="maven.compiler.maxmem")
    private String maxmem;
    @Parameter(property="maven.compiler.executable")
    private String executable;
    @Parameter
    private String proc;
    @Parameter
    private String[] annotationProcessors;
    @Parameter
    private List<DependencyCoordinate> annotationProcessorPaths;
    @Deprecated
    @Parameter
    protected Map<String, String> compilerArguments;
    @Parameter
    protected List<String> compilerArgs;
    @Parameter
    protected String compilerArgument;
    @Parameter
    private String outputFileName;
    @Parameter(property="maven.compiler.debuglevel")
    private String debuglevel;
    @Parameter(property="maven.compiler.implicit")
    private String implicit;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter
    private Map<String, String> jdkToolchain;
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDirectory;
    @Component
    private CompilerManager compilerManager;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reuseCreated}", property="maven.compiler.compilerReuseStrategy")
    private String compilerReuseStrategy = "reuseCreated";
    @Parameter(defaultValue="false", property="maven.compiler.skipMultiThreadWarning")
    private boolean skipMultiThreadWarning;
    @Parameter(defaultValue="false", property="maven.compiler.forceJavacCompilerUse")
    private boolean forceJavacCompilerUse;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter
    private List<String> fileExtensions;
    @Parameter(defaultValue="true", property="maven.compiler.useIncrementalCompilation")
    private boolean useIncrementalCompilation = true;
    @Parameter(defaultValue="true", property="maven.compiler.createMissingPackageInfoClass")
    private boolean createMissingPackageInfoClass = true;
    @Parameter(defaultValue="false", property="maven.compiler.showCompilationChanges")
    private boolean showCompilationChanges = false;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    private boolean targetOrReleaseSet;

    protected abstract SourceInclusionScanner getSourceInclusionScanner(int var1);

    protected abstract SourceInclusionScanner getSourceInclusionScanner(String var1);

    protected abstract List<String> getClasspathElements();

    protected abstract List<String> getModulepathElements();

    protected abstract Map<String, JavaModuleDescriptor> getPathElements();

    protected abstract List<String> getCompileSourceRoots();

    protected abstract void preparePaths(Set<File> var1);

    protected abstract File getOutputDirectory();

    protected abstract String getSource();

    protected abstract String getTarget();

    protected abstract String getRelease();

    protected abstract String getCompilerArgument();

    protected abstract Map<String, String> getCompilerArguments();

    protected abstract File getGeneratedSourcesDirectory();

    protected abstract String getDebugFileName();

    protected final MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoExecutionException, CompilationFailureException {
        CompilerResult compilerResult;
        Set<File> staleSources;
        Set<File> sources;
        boolean canUpdateTarget;
        List<String> compileSourceRoots;
        Compiler compiler;
        this.getLog().debug((CharSequence)("Using compiler '" + this.compilerId + "'."));
        try {
            compiler = this.compilerManager.getCompiler(this.compilerId);
        }
        catch (NoSuchCompilerException e) {
            throw new MojoExecutionException("No such compiler '" + e.getCompilerId() + "'.");
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in maven-compiler-plugin: " + tc));
            if (this.executable != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            } else {
                this.fork = true;
                this.executable = tc.findTool(this.compilerId);
            }
        }
        if ((compileSourceRoots = AbstractCompilerMojo.removeEmptyCompileSourceRoots(this.getCompileSourceRoots())).isEmpty()) {
            this.getLog().info((CharSequence)"No sources to compile");
            return;
        }
        if (!this.targetOrReleaseSet) {
            MessageBuilder mb = MessageUtils.buffer().a((CharSequence)"No explicit value set for target or release! ").a((CharSequence)"To ensure the same result even after upgrading this plugin, please add ").newline().newline();
            this.writePlugin(mb);
            this.getLog().warn((CharSequence)mb.toString());
        }
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setOutputLocation(this.getOutputDirectory().getAbsolutePath());
        compilerConfiguration.setOptimize(this.optimize);
        compilerConfiguration.setDebug(this.debug);
        compilerConfiguration.setDebugFileName(this.getDebugFileName());
        compilerConfiguration.setImplicitOption(this.implicit);
        if (this.debug && StringUtils.isNotEmpty((String)this.debuglevel)) {
            String[] split;
            for (String aSplit : split = StringUtils.split((String)this.debuglevel, (String)",")) {
                if (aSplit.equalsIgnoreCase("none") || aSplit.equalsIgnoreCase("lines") || aSplit.equalsIgnoreCase("vars") || aSplit.equalsIgnoreCase("source")) continue;
                throw new IllegalArgumentException("The specified debug level: '" + aSplit + "' is unsupported. Legal values are 'none', 'lines', 'vars', and 'source'.");
            }
            compilerConfiguration.setDebugLevel(this.debuglevel);
        }
        compilerConfiguration.setParameters(this.parameters);
        compilerConfiguration.setEnablePreview(this.enablePreview);
        compilerConfiguration.setVerbose(this.verbose);
        compilerConfiguration.setShowWarnings(this.showWarnings);
        compilerConfiguration.setFailOnWarning(this.failOnWarning);
        if (this.failOnWarning && !this.showWarnings) {
            this.getLog().warn((CharSequence)"The property failOnWarning is set to true, but showWarnings is set to false.");
            this.getLog().warn((CharSequence)"With compiler's warnings silenced the failOnWarning has no effect.");
        }
        compilerConfiguration.setShowDeprecation(this.showDeprecation);
        compilerConfiguration.setSourceVersion(this.getSource());
        compilerConfiguration.setTargetVersion(this.getTarget());
        compilerConfiguration.setReleaseVersion(this.getRelease());
        compilerConfiguration.setProc(this.proc);
        File generatedSourcesDirectory = this.getGeneratedSourcesDirectory();
        compilerConfiguration.setGeneratedSourcesDirectory(generatedSourcesDirectory != null ? generatedSourcesDirectory.getAbsoluteFile() : null);
        if (generatedSourcesDirectory != null) {
            if (!generatedSourcesDirectory.exists()) {
                generatedSourcesDirectory.mkdirs();
            }
            String generatedSourcesPath = generatedSourcesDirectory.getAbsolutePath();
            compileSourceRoots.add(generatedSourcesPath);
            if (this.isTestCompile()) {
                this.getLog().debug((CharSequence)("Adding " + generatedSourcesPath + " to test-compile source roots:\n  " + StringUtils.join(this.project.getTestCompileSourceRoots().iterator(), (String)"\n  ")));
                this.project.addTestCompileSourceRoot(generatedSourcesPath);
                this.getLog().debug((CharSequence)("New test-compile source roots:\n  " + StringUtils.join(this.project.getTestCompileSourceRoots().iterator(), (String)"\n  ")));
            } else {
                this.getLog().debug((CharSequence)("Adding " + generatedSourcesPath + " to compile source roots:\n  " + StringUtils.join(this.project.getCompileSourceRoots().iterator(), (String)"\n  ")));
                this.project.addCompileSourceRoot(generatedSourcesPath);
                this.getLog().debug((CharSequence)("New compile source roots:\n  " + StringUtils.join(this.project.getCompileSourceRoots().iterator(), (String)"\n  ")));
            }
        }
        compilerConfiguration.setSourceLocations(compileSourceRoots);
        compilerConfiguration.setAnnotationProcessors(this.annotationProcessors);
        compilerConfiguration.setProcessorPathEntries(this.resolveProcessorPathEntries());
        compilerConfiguration.setSourceEncoding(this.encoding);
        compilerConfiguration.setFork(this.fork);
        if (this.fork) {
            String value;
            if (!StringUtils.isEmpty((String)this.meminitial)) {
                value = this.getMemoryValue(this.meminitial);
                if (value != null) {
                    compilerConfiguration.setMeminitial(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for meminitial '" + this.meminitial + "'. Ignoring this option."));
                }
            }
            if (!StringUtils.isEmpty((String)this.maxmem)) {
                value = this.getMemoryValue(this.maxmem);
                if (value != null) {
                    compilerConfiguration.setMaxmem(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for maxmem '" + this.maxmem + "'. Ignoring this option."));
                }
            }
        }
        compilerConfiguration.setExecutable(this.executable);
        compilerConfiguration.setWorkingDirectory(this.basedir);
        compilerConfiguration.setCompilerVersion(this.compilerVersion);
        compilerConfiguration.setBuildDirectory(this.buildDirectory);
        compilerConfiguration.setOutputFileName(this.outputFileName);
        if (CompilerConfiguration.CompilerReuseStrategy.AlwaysNew.getStrategy().equals(this.compilerReuseStrategy)) {
            compilerConfiguration.setCompilerReuseStrategy(CompilerConfiguration.CompilerReuseStrategy.AlwaysNew);
        } else if (CompilerConfiguration.CompilerReuseStrategy.ReuseSame.getStrategy().equals(this.compilerReuseStrategy)) {
            if (this.getRequestThreadCount() > 1 && !this.skipMultiThreadWarning) {
                this.getLog().warn((CharSequence)("You are in a multi-thread build and compilerReuseStrategy is set to reuseSame. This can cause issues in some environments (os/jdk)! Consider using reuseCreated strategy." + System.getProperty("line.separator") + "If your env is fine with reuseSame, you can skip this warning with the configuration field skipMultiThreadWarning or -Dmaven.compiler.skipMultiThreadWarning=true"));
            }
            compilerConfiguration.setCompilerReuseStrategy(CompilerConfiguration.CompilerReuseStrategy.ReuseSame);
        } else {
            compilerConfiguration.setCompilerReuseStrategy(CompilerConfiguration.CompilerReuseStrategy.ReuseCreated);
        }
        this.getLog().debug((CharSequence)("CompilerReuseStrategy: " + compilerConfiguration.getCompilerReuseStrategy().getStrategy()));
        compilerConfiguration.setForceJavacCompilerUse(this.forceJavacCompilerUse);
        IncrementalBuildHelper incrementalBuildHelper = new IncrementalBuildHelper(this.mojoExecution, this.session);
        IncrementalBuildHelperRequest incrementalBuildHelperRequest = null;
        if (this.useIncrementalCompilation) {
            this.getLog().debug((CharSequence)"useIncrementalCompilation enabled");
            try {
                canUpdateTarget = compiler.canUpdateTarget(compilerConfiguration);
                sources = this.getCompileSources(compiler, compilerConfiguration);
                this.preparePaths(sources);
                incrementalBuildHelperRequest = new IncrementalBuildHelperRequest().inputFiles(sources);
                DirectoryScanResult dsr = this.computeInputFileTreeChanges(incrementalBuildHelper, sources);
                boolean idk = compiler.getCompilerOutputStyle().equals((Object)CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) && !canUpdateTarget;
                boolean dependencyChanged = this.isDependencyChanged();
                boolean sourceChanged = this.isSourceChanged(compilerConfiguration, compiler);
                boolean inputFileTreeChanged = this.hasInputFileTreeChanged(dsr);
                if (idk || dependencyChanged || sourceChanged || inputFileTreeChanged) {
                    String cause = idk ? "idk" : (dependencyChanged ? "dependency" : (sourceChanged ? "source" : "input tree"));
                    this.getLog().info((CharSequence)("Changes detected - recompiling the module! :" + cause));
                    if (this.showCompilationChanges) {
                        for (String fileAdded : dsr.getFilesAdded()) {
                            this.getLog().info((CharSequence)("\t+ " + fileAdded));
                        }
                        for (String fileRemoved : dsr.getFilesRemoved()) {
                            this.getLog().info((CharSequence)("\t- " + fileRemoved));
                        }
                    }
                } else {
                    this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
                    return;
                }
                compilerConfiguration.setSourceFiles(sources);
            }
            catch (CompilerException e) {
                throw new MojoExecutionException("Error while computing stale sources.", (Exception)((Object)e));
            }
        }
        this.getLog().debug((CharSequence)"useIncrementalCompilation disabled");
        try {
            staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(this.staleMillis));
            canUpdateTarget = compiler.canUpdateTarget(compilerConfiguration);
            if (compiler.getCompilerOutputStyle().equals((Object)CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) && !canUpdateTarget) {
                this.getLog().info((CharSequence)"RESCANNING!");
                String inputFileEnding = compiler.getInputFileEnding(compilerConfiguration);
                staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(inputFileEnding));
            }
        }
        catch (CompilerException e) {
            throw new MojoExecutionException("Error while computing stale sources.", (Exception)((Object)e));
        }
        if (staleSources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
            return;
        }
        compilerConfiguration.setSourceFiles(staleSources);
        try {
            sources = this.getCompileSources(compiler, compilerConfiguration);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("#sources: " + sources.size()));
                for (File file : sources) {
                    this.getLog().debug((CharSequence)file.getPath());
                }
            }
            this.preparePaths(sources);
        }
        catch (CompilerException e) {
            throw new MojoExecutionException("Error while computing stale sources.", (Exception)((Object)e));
        }
        compilerConfiguration.setClasspathEntries(this.getClasspathElements());
        compilerConfiguration.setModulepathEntries(this.getModulepathElements());
        compilerConfiguration.setIncludes(this.getIncludes());
        compilerConfiguration.setExcludes(this.getExcludes());
        Map<String, String> effectiveCompilerArguments = this.getCompilerArguments();
        String effectiveCompilerArgument = this.getCompilerArgument();
        if (effectiveCompilerArguments != null || effectiveCompilerArgument != null || this.compilerArgs != null) {
            if (effectiveCompilerArguments != null) {
                for (Map.Entry<String, String> me : effectiveCompilerArguments.entrySet()) {
                    String key = me.getKey();
                    String value = me.getValue();
                    if (!key.startsWith("-")) {
                        key = "-" + key;
                    }
                    if (key.startsWith("-A") && StringUtils.isNotEmpty((String)value)) {
                        compilerConfiguration.addCompilerCustomArgument(key + "=" + value, null);
                        continue;
                    }
                    compilerConfiguration.addCompilerCustomArgument(key, value);
                }
            }
            if (!StringUtils.isEmpty((String)effectiveCompilerArgument)) {
                compilerConfiguration.addCompilerCustomArgument(effectiveCompilerArgument, null);
            }
            if (this.compilerArgs != null) {
                for (String arg : this.compilerArgs) {
                    compilerConfiguration.addCompilerCustomArgument(arg, null);
                }
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Classpath:");
            for (String s : this.getClasspathElements()) {
                this.getLog().debug((CharSequence)(" " + s));
            }
            if (!this.getModulepathElements().isEmpty()) {
                this.getLog().debug((CharSequence)"Modulepath:");
                for (String s : this.getModulepathElements()) {
                    this.getLog().debug((CharSequence)(" " + s));
                }
            }
            this.getLog().debug((CharSequence)"Source roots:");
            for (String root : this.getCompileSourceRoots()) {
                this.getLog().debug((CharSequence)(" " + root));
            }
            try {
                String[] cl;
                if (this.fork && compilerConfiguration.getExecutable() != null) {
                    this.getLog().debug((CharSequence)"Excutable: ");
                    this.getLog().debug((CharSequence)(" " + compilerConfiguration.getExecutable()));
                }
                if ((cl = compiler.createCommandLine(compilerConfiguration)) != null && cl.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(cl[0]);
                    for (int i = 1; i < cl.length; ++i) {
                        sb.append(" ");
                        sb.append(cl[i]);
                    }
                    this.getLog().debug((CharSequence)"Command line options:");
                    this.getLog().debug((CharSequence)sb);
                }
            }
            catch (CompilerException ce) {
                this.getLog().debug((Throwable)ce);
            }
        }
        ArrayList<String> jpmsLines = new ArrayList<String>();
        List<String> runtimeArgs = Arrays.asList("--upgrade-module-path", "--add-exports", "--add-reads", "--add-modules", "--limit-modules");
        Iterator entryIter = compilerConfiguration.getCustomCompilerArgumentsEntries().iterator();
        while (entryIter.hasNext()) {
            String[] files;
            String value;
            Map.Entry entry = (Map.Entry)entryIter.next();
            if (runtimeArgs.contains(entry.getKey())) {
                jpmsLines.add((String)entry.getKey());
                value = (String)entry.getValue();
                if (value == null) {
                    entry = (Map.Entry)entryIter.next();
                    value = (String)entry.getKey();
                }
                jpmsLines.add(value);
                continue;
            }
            if (!"--patch-module".equals(entry.getKey())) continue;
            value = (String)entry.getValue();
            if (value == null) {
                entry = (Map.Entry)entryIter.next();
                value = (String)entry.getKey();
            }
            String[] values = value.split("=");
            StringBuilder patchModule = new StringBuilder(values[0]);
            patchModule.append('=');
            LinkedHashSet<String> patchModules = new LinkedHashSet<String>();
            HashSet<Path> sourceRoots = new HashSet<Path>(this.getCompileSourceRoots().size());
            for (String string : this.getCompileSourceRoots()) {
                sourceRoots.add(Paths.get(string, new String[0]));
            }
            for (String file : files = values[1].split(PS)) {
                Path filePath = Paths.get(file, new String[0]);
                if (this.getOutputDirectory().toPath().equals(filePath)) {
                    patchModules.add("_");
                    continue;
                }
                if (this.getOutputDirectory().toPath().startsWith(filePath)) continue;
                if (sourceRoots.contains(filePath)) {
                    patchModules.add("_");
                    continue;
                }
                JavaModuleDescriptor descriptor = this.getPathElements().get(file);
                if (descriptor == null) {
                    if (Files.isDirectory(filePath, new LinkOption[0])) {
                        patchModules.add(file);
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Can't locate " + file));
                    continue;
                }
                if (values[0].equals(descriptor.name())) continue;
                patchModules.add(descriptor.name());
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (patchModules.isEmpty()) continue;
            for (String mod : patchModules) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(mod);
            }
            jpmsLines.add("--patch-module");
            jpmsLines.add(patchModule + stringBuilder.toString());
        }
        if (!jpmsLines.isEmpty()) {
            Path jpmsArgs = Paths.get(this.getOutputDirectory().getAbsolutePath(), "META-INF/jpms.args");
            try {
                Files.createDirectories(jpmsArgs.getParent(), new FileAttribute[0]);
                Files.write(jpmsArgs, jpmsLines, Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)compilerConfiguration.getSourceEncoding())) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        if (this.useIncrementalCompilation) {
            incrementalBuildHelperRequest.outputDirectory(this.getOutputDirectory());
            incrementalBuildHelper.beforeRebuildExecution(incrementalBuildHelperRequest);
            this.getLog().debug((CharSequence)"incrementalBuildHelper#beforeRebuildExecution");
        }
        try {
            compilerResult = compiler.performCompile(compilerConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fatal error compiling", e);
        }
        if (this.createMissingPackageInfoClass && compilerResult.isSuccess() && compiler.getCompilerOutputStyle() == CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            try {
                SourceMapping sourceMapping = this.getSourceMapping(compilerConfiguration, compiler);
                this.createMissingPackageInfoClasses(compilerConfiguration, sourceMapping, sources);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Error creating missing package info classes", (Throwable)e);
            }
        }
        if (this.useIncrementalCompilation) {
            if (incrementalBuildHelperRequest.getOutputDirectory().exists()) {
                this.getLog().debug((CharSequence)"incrementalBuildHelper#afterRebuildExecution");
                incrementalBuildHelper.afterRebuildExecution(incrementalBuildHelperRequest);
            } else {
                this.getLog().debug((CharSequence)"skip incrementalBuildHelper#afterRebuildExecution as the output directory doesn't exist");
            }
        }
        ArrayList<CompilerMessage> warnings = new ArrayList<CompilerMessage>();
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        ArrayList<CompilerMessage> others = new ArrayList<CompilerMessage>();
        for (CompilerMessage message : compilerResult.getCompilerMessages()) {
            if (message.getKind() == CompilerMessage.Kind.ERROR) {
                errors.add(message);
                continue;
            }
            if (message.getKind() == CompilerMessage.Kind.WARNING || message.getKind() == CompilerMessage.Kind.MANDATORY_WARNING) {
                warnings.add(message);
                continue;
            }
            others.add(message);
        }
        if (this.failOnError && !compilerResult.isSuccess()) {
            for (CompilerMessage message : others) {
                assert (message.getKind() != CompilerMessage.Kind.ERROR && message.getKind() != CompilerMessage.Kind.WARNING && message.getKind() != CompilerMessage.Kind.MANDATORY_WARNING);
                this.getLog().info((CharSequence)message.toString());
            }
            if (!warnings.isEmpty()) {
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                this.getLog().warn((CharSequence)"COMPILATION WARNING : ");
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                for (CompilerMessage warning : warnings) {
                    this.getLog().warn((CharSequence)warning.toString());
                }
                this.getLog().info((CharSequence)(warnings.size() + (warnings.size() > 1 ? " warnings " : " warning")));
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
            }
            if (!errors.isEmpty()) {
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                this.getLog().error((CharSequence)"COMPILATION ERROR : ");
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                for (CompilerMessage error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                this.getLog().info((CharSequence)(errors.size() + (errors.size() > 1 ? " errors " : " error")));
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
            }
            if (!errors.isEmpty()) {
                throw new CompilationFailureException(errors);
            }
            throw new CompilationFailureException(warnings);
        }
        block38: for (CompilerMessage message : compilerResult.getCompilerMessages()) {
            switch (message.getKind()) {
                case NOTE: 
                case OTHER: {
                    this.getLog().info((CharSequence)message.toString());
                    continue block38;
                }
                case ERROR: {
                    this.getLog().error((CharSequence)message.toString());
                    continue block38;
                }
            }
            this.getLog().warn((CharSequence)message.toString());
        }
    }

    private void createMissingPackageInfoClasses(CompilerConfiguration compilerConfiguration, SourceMapping sourceMapping, Set<File> sources) throws InclusionScanException, IOException {
        for (File source : sources) {
            String path = source.toString();
            if (!path.endsWith(File.separator + "package-info.java")) continue;
            for (String root : this.getCompileSourceRoots()) {
                if (!path.startsWith(root = root + File.separator)) continue;
                String rel = path.substring(root.length());
                Set files = sourceMapping.getTargetFiles(this.getOutputDirectory(), rel);
                for (File file : files) {
                    if (file.exists()) continue;
                    File parentFile = file.getParentFile();
                    if (!parentFile.exists()) {
                        Files.createDirectories(parentFile.toPath(), new FileAttribute[0]);
                    }
                    byte[] bytes = this.generatePackage(compilerConfiguration, rel);
                    Files.write(file.toPath(), bytes, new OpenOption[0]);
                }
            }
        }
    }

    private byte[] generatePackage(CompilerConfiguration compilerConfiguration, String javaFile) {
        int version = this.getOpcode(compilerConfiguration);
        String internalPackageName = javaFile.substring(0, javaFile.length() - ".java".length());
        if (File.separatorChar != '/') {
            internalPackageName = internalPackageName.replace(File.separatorChar, '/');
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(version, 5632, internalPackageName, null, "java/lang/Object", null);
        cw.visitSource("package-info.java", null);
        return cw.toByteArray();
    }

    private int getOpcode(CompilerConfiguration compilerConfiguration) {
        int iVersion;
        String version = compilerConfiguration.getReleaseVersion();
        if (version == null && (version = compilerConfiguration.getTargetVersion()) == null) {
            version = "1.5";
        }
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        if ((iVersion = Integer.parseInt(version)) < 2) {
            throw new IllegalArgumentException("Unsupported java version '" + version + "'");
        }
        return iVersion - 2 + 46;
    }

    protected boolean isTestCompile() {
        return false;
    }

    private Set<File> getCompileSources(Compiler compiler, CompilerConfiguration compilerConfiguration) throws MojoExecutionException, CompilerException {
        String inputFileEnding = compiler.getInputFileEnding(compilerConfiguration);
        if (StringUtils.isEmpty((String)inputFileEnding)) {
            inputFileEnding = ".*";
        }
        SourceInclusionScanner scanner = this.getSourceInclusionScanner(inputFileEnding);
        SourceMapping mapping = this.getSourceMapping(compilerConfiguration, compiler);
        scanner.addSourceMapping(mapping);
        HashSet<File> compileSources = new HashSet<File>();
        for (String sourceRoot : this.getCompileSourceRoots()) {
            File rootFile = new File(sourceRoot);
            if (!rootFile.isDirectory() || rootFile.getAbsoluteFile().equals(compilerConfiguration.getGeneratedSourcesDirectory())) continue;
            try {
                compileSources.addAll(scanner.getIncludedSources(rootFile, null));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceRoot + "' for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return compileSources;
    }

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();

    private boolean isSourceChanged(CompilerConfiguration compilerConfiguration, Compiler compiler) throws CompilerException, MojoExecutionException {
        Set<File> staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(this.staleMillis));
        if (this.getLog().isDebugEnabled() || this.showCompilationChanges) {
            for (File f : staleSources) {
                if (this.showCompilationChanges) {
                    this.getLog().info((CharSequence)("Stale source detected: " + f.getAbsolutePath()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Stale source detected: " + f.getAbsolutePath()));
            }
        }
        return !staleSources.isEmpty();
    }

    protected int getRequestThreadCount() {
        return this.session.getRequest().getDegreeOfConcurrency();
    }

    protected Date getBuildStartTime() {
        MavenExecutionRequest request = this.session.getRequest();
        Date buildStartTime = request == null ? new Date() : request.getStartTime();
        return buildStartTime == null ? new Date() : buildStartTime;
    }

    private String getMemoryValue(String setting) {
        String value = null;
        if (this.isDigits(setting)) {
            value = setting + "m";
        } else if (this.isDigits(setting.substring(0, setting.length() - 1)) && setting.toLowerCase().endsWith("m")) {
            value = setting;
        }
        return value;
    }

    protected final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.jdkToolchain != null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", this.jdkToolchain);
                if (tcs != null && !tcs.isEmpty()) {
                    tc = (Toolchain)tcs.get(0);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    private boolean isDigits(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Set<File> computeStaleSources(CompilerConfiguration compilerConfiguration, Compiler compiler, SourceInclusionScanner scanner) throws MojoExecutionException, CompilerException {
        SourceMapping mapping = this.getSourceMapping(compilerConfiguration, compiler);
        CompilerOutputStyle outputStyle = compiler.getCompilerOutputStyle();
        File outputDirectory = outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES ? this.buildDirectory : this.getOutputDirectory();
        scanner.addSourceMapping(mapping);
        HashSet<File> staleSources = new HashSet<File>();
        for (String sourceRoot : this.getCompileSourceRoots()) {
            File rootFile = new File(sourceRoot);
            if (!rootFile.isDirectory()) continue;
            try {
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceRoot + "' for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return staleSources;
    }

    private SourceMapping getSourceMapping(CompilerConfiguration compilerConfiguration, Compiler compiler) throws CompilerException, MojoExecutionException {
        SuffixMapping mapping;
        CompilerOutputStyle outputStyle = compiler.getCompilerOutputStyle();
        if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            mapping = new SuffixMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFileEnding(compilerConfiguration));
        } else if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) {
            mapping = new SingleTargetSourceMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFile(compilerConfiguration));
        } else {
            throw new MojoExecutionException("Unknown compiler output style: '" + outputStyle + "'.");
        }
        return mapping;
    }

    private static List<String> removeEmptyCompileSourceRoots(List<String> compileSourceRootsList) {
        ArrayList<String> newCompileSourceRootsList = new ArrayList<String>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                if (newCompileSourceRootsList.contains(srcDir) || !new File(srcDir).exists()) continue;
                newCompileSourceRootsList.add(srcDir);
            }
        }
        return newCompileSourceRootsList;
    }

    protected boolean isDependencyChanged() {
        if (this.session == null) {
            this.getLog().info((CharSequence)"Cannot determine build start date, skipping incremental build detection.");
            return false;
        }
        if (this.fileExtensions == null || this.fileExtensions.isEmpty()) {
            this.fileExtensions = Collections.unmodifiableList(Arrays.asList("class", "jar"));
        }
        Date buildStartTime = this.getBuildStartTime();
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.addAll(this.getClasspathElements());
        pathElements.addAll(this.getModulepathElements());
        for (String pathElement : pathElements) {
            File artifactPath = new File(pathElement);
            if (!artifactPath.isDirectory() && !artifactPath.isFile() || artifactPath.equals(this.getOutputDirectory()) || !this.hasNewFile(artifactPath, buildStartTime)) continue;
            if (this.showCompilationChanges) {
                this.getLog().info((CharSequence)("New dependency detected: " + artifactPath.getAbsolutePath()));
            } else {
                this.getLog().debug((CharSequence)("New dependency detected: " + artifactPath.getAbsolutePath()));
            }
            return true;
        }
        return false;
    }

    private boolean hasNewFile(File classPathEntry, Date buildStartTime) {
        File[] children;
        if (!classPathEntry.exists()) {
            return false;
        }
        if (classPathEntry.isFile()) {
            return classPathEntry.lastModified() >= buildStartTime.getTime() && this.fileExtensions.contains(FileUtils.getExtension((String)classPathEntry.getName()));
        }
        for (File child : children = classPathEntry.listFiles()) {
            if (!this.hasNewFile(child, buildStartTime)) continue;
            return true;
        }
        return false;
    }

    private List<String> resolveProcessorPathEntries() throws MojoExecutionException {
        if (this.annotationProcessorPaths == null || this.annotationProcessorPaths.isEmpty()) {
            return null;
        }
        LinkedHashSet<String> elements = new LinkedHashSet<String>();
        try {
            List<Dependency> dependencies = this.convertToDependencies(this.annotationProcessorPaths);
            CollectRequest collectRequest = new CollectRequest(dependencies, Collections.emptyList(), this.project.getRemoteProjectRepositories());
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setCollectRequest(collectRequest);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.session.getRepositorySession(), dependencyRequest);
            for (ArtifactResult resolved : dependencyResult.getArtifactResults()) {
                elements.add(resolved.getArtifact().getFile().getAbsolutePath());
            }
            return new ArrayList<String>(elements);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Resolution of annotationProcessorPath dependencies failed: " + e.getLocalizedMessage(), e);
        }
    }

    private List<Dependency> convertToDependencies(List<DependencyCoordinate> annotationProcessorPaths) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (DependencyCoordinate annotationProcessorPath : annotationProcessorPaths) {
            ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(annotationProcessorPath.getType());
            DefaultArtifact artifact = new DefaultArtifact(annotationProcessorPath.getGroupId(), annotationProcessorPath.getArtifactId(), annotationProcessorPath.getClassifier(), handler.getExtension(), annotationProcessorPath.getVersion());
            Set<Exclusion> exclusions = this.convertToAetherExclusions(annotationProcessorPath.getExclusions());
            dependencies.add(new Dependency((Artifact)artifact, "runtime", Boolean.valueOf(false), exclusions));
        }
        return dependencies;
    }

    private Set<Exclusion> convertToAetherExclusions(Set<DependencyExclusion> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Exclusion> aetherExclusions = new HashSet<Exclusion>();
        for (DependencyExclusion exclusion : exclusions) {
            Exclusion aetherExclusion = new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), exclusion.getClassifier(), exclusion.getExtension());
            aetherExclusions.add(aetherExclusion);
        }
        return aetherExclusions;
    }

    private void writePlugin(MessageBuilder mb) {
        mb.a((CharSequence)"    <plugin>").newline();
        mb.a((CharSequence)"      <groupId>org.apache.maven.plugins</groupId>").newline();
        mb.a((CharSequence)"      <artifactId>maven-compiler-plugin</artifactId>").newline();
        String version = this.getMavenCompilerPluginVersion();
        if (version != null) {
            mb.a((CharSequence)"      <version>").a((CharSequence)version).a((CharSequence)"</version>").newline();
        }
        this.writeConfig(mb);
        mb.a((CharSequence)"    </plugin>").newline();
    }

    private void writeConfig(MessageBuilder mb) {
        mb.a((CharSequence)"      <configuration>").newline();
        if (this.release != null) {
            mb.a((CharSequence)"        <release>").a((CharSequence)this.release).a((CharSequence)"</release>").newline();
        } else if (JavaVersion.JAVA_VERSION.isAtLeast("9")) {
            String rls = this.target.replaceAll(".\\.", "");
            mb.a((CharSequence)"        <release>").a((CharSequence)rls).a((CharSequence)"</release>").newline();
        } else {
            mb.a((CharSequence)"        <source>").a((CharSequence)this.source).a((CharSequence)"</source>").newline();
            mb.a((CharSequence)"        <target>").a((CharSequence)this.target).a((CharSequence)"</target>").newline();
        }
        mb.a((CharSequence)"      </configuration>").newline();
    }

    private String getMavenCompilerPluginVersion() {
        Properties pomProperties = new Properties();
        try (InputStream is = AbstractCompilerMojo.class.getResourceAsStream("/META-INF/maven/org.apache.maven.plugins/maven-compiler-plugin/pom.properties");){
            if (is != null) {
                pomProperties.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pomProperties.getProperty("version");
    }

    private DirectoryScanResult computeInputFileTreeChanges(IncrementalBuildHelper ibh, Set<File> inputFiles) throws MojoExecutionException {
        File mojoConfigBase = ibh.getMojoStatusDirectory();
        File mojoConfigFile = new File(mojoConfigBase, INPUT_FILES_LST_FILENAME);
        String[] oldInputFiles = new String[]{};
        if (mojoConfigFile.exists()) {
            try {
                oldInputFiles = FileUtils.fileReadArray((File)mojoConfigFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading old mojo status " + mojoConfigFile, (Exception)e);
            }
        }
        String[] inputFileNames = (String[])inputFiles.stream().map(File::getAbsolutePath).toArray(String[]::new);
        DirectoryScanResult dsr = DirectoryScanner.diffFiles((String[])oldInputFiles, (String[])inputFileNames);
        try {
            FileUtils.fileWriteArray((File)mojoConfigFile, (String[])inputFileNames);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while storing the mojo status", (Exception)e);
        }
        return dsr;
    }

    private boolean hasInputFileTreeChanged(DirectoryScanResult dsr) {
        return dsr.getFilesAdded().length > 0 || dsr.getFilesRemoved().length > 0;
    }

    public void setTarget(String target) {
        this.target = target;
        this.targetOrReleaseSet = true;
    }

    public void setRelease(String release) {
        this.release = release;
        this.targetOrReleaseSet = true;
    }

    final String getImplicit() {
        return this.implicit;
    }
}

