/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.Status;
import io.grpc.alts.CallCredentialsInterceptor;
import io.grpc.alts.CheckGcpEnvironment;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.GoogleDefaultProtocolNegotiator;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLException;

public final class ComputeEngineChannelBuilder
extends ForwardingChannelBuilder<GoogleDefaultChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private GoogleDefaultProtocolNegotiator negotiatorForTest;

    private ComputeEngineChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget((String)target);
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate(), (InternalNettyChannelBuilder.ProtocolNegotiatorFactory)new ProtocolNegotiatorFactory());
        CallCredentials credentials = MoreCallCredentials.from((Credentials)ComputeEngineCredentials.create());
        Status status = Status.OK;
        if (!CheckGcpEnvironment.isOnGcp()) {
            status = Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform");
        }
        this.delegate().intercept(new ClientInterceptor[]{new CallCredentialsInterceptor(credentials, status)});
    }

    public static final ComputeEngineChannelBuilder forTarget(String target) {
        return new ComputeEngineChannelBuilder(target);
    }

    public static ComputeEngineChannelBuilder forAddress(String name, int port) {
        return ComputeEngineChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    GoogleDefaultProtocolNegotiator getProtocolNegotiatorForTest() {
        return this.negotiatorForTest;
    }

    private final class ProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private ProtocolNegotiatorFactory() {
        }

        public GoogleDefaultProtocolNegotiator buildProtocolNegotiator() {
            SslContext sslContext;
            final AltsProtocolNegotiator.LazyChannel lazyHandshakerChannel = new AltsProtocolNegotiator.LazyChannel((ObjectPool<Channel>)SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL));
            TsiHandshakerFactory altsHandshakerFactory = new TsiHandshakerFactory(){

                @Override
                public TsiHandshaker newHandshaker(String authority) {
                    AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).setTargetName(authority).build();
                    return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub(lazyHandshakerChannel.get()), handshakerOptions);
                }
            };
            try {
                sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException ex) {
                throw new RuntimeException(ex);
            }
            return ComputeEngineChannelBuilder.this.negotiatorForTest = new GoogleDefaultProtocolNegotiator(altsHandshakerFactory, lazyHandshakerChannel, sslContext);
        }
    }
}

