//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.TimeSeriesProduct");
report.setReport("/com/openbravo/reports/timeseriesproduct");
report.setResourceBundle("com/openbravo/reports/timeseriesproduct_messages");

report.setSentence("SELECT " +
        "CATEGORIES.NAME AS CATNAME, " +
        "PRODUCTS.NAME AS PRODUCT, " +
//        "PRODUCTS.IMAGE AS PRODIMG, " +
        "PRODUCTS.REFERENCE AS REF, " +
        "PRODUCTS.CODE AS BARCODE, " +
        "PRODUCTS.PRICEBUY, " +
        "PRODUCTS.PRICESELL, " +
        "PRODUCTS.STOCKCOST, " +
        "PRODUCTS.STOCKVOLUME, " +
        "TAXCATEGORIES.ID AS TAXCAT, " +
        "TAXCATEGORIES.NAME AS TAXCATNAME, " +
        "PEOPLE.NAME AS SELLER, " +
        "RECEIPTS.DATENEW AS RECEIPTDATE, " +
    "SUM(TICKETLINES.UNITS) AS TOTALUNIT " +
    "FROM RECEIPTS LEFT OUTER JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID LEFT OUTER JOIN TICKETLINES ON " +
        "TICKETS.ID = TICKETLINES.TICKET, PRODUCTS LEFT OUTER JOIN CATEGORIES ON " +
        "PRODUCTS.CATEGORY = CATEGORIES.ID LEFT OUTER JOIN TAXCATEGORIES ON PRODUCTS.TAXCAT = TAXCATEGORIES.ID, " +
        "PRODUCTS_CAT, PEOPLE " +
    "WHERE PRODUCTS.ID = TICKETLINES.PRODUCT AND PEOPLE.ID = TICKETS.PERSON AND PRODUCTS.ID = PRODUCTS_CAT.PRODUCT AND ?(QBF_FILTER) " +
    "GROUP BY CATEGORIES.NAME, PRODUCTS.NAME, PRODUCTS.REFERENCE,PRODUCTS.CODE,PRODUCTS.PRICEBUY, " +
    "PRODUCTS.PRICESELL, PRODUCTS.STOCKCOST,PRODUCTS.STOCKVOLUME, TAXCATEGORIES.ID, TAXCATEGORIES.NAME, PEOPLE.NAME, RECEIPTS.DATENEW " +
    "ORDER BY CATEGORIES.NAME, PRODUCTS.NAME, RECEIPTS.DATENEW, PEOPLE.NAME");
//    "GROUP BY CATEGORIES.NAME, PRODUCTS.NAME, PRODUCTS.IMAGE, PRODUCTS.REFERENCE,PRODUCTS.CODE,PRODUCTS.PRICEBUY, " +
//    "PRODUCTS.PRICESELL, PRODUCTS.STOCKCOST,PRODUCTS.STOCKVOLUME, DAY(RECEIPTS.DATENEW), PEOPLE.ID " +
report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter());

report.addField("CATNAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("PRODUCT", com.procaisse.db.metadata.Datas.STRING);
//report.addField("PRODIMG", com.procaisse.db.metadata.Datas.IMAGE);
report.addField("REF", com.procaisse.db.metadata.Datas.STRING);
report.addField("BARCODE", com.procaisse.db.metadata.Datas.STRING);
report.addField("PRICEBUY", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("PRICESELL", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("STOCKCOST", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("STOCKVOLUME", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("TAXCAT", com.procaisse.db.metadata.Datas.STRING);
report.addField("TAXCATNAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("SALER", com.procaisse.db.metadata.Datas.STRING);
report.addField("RECEIPTDATE", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("TOTALUNIT", com.procaisse.db.metadata.Datas.DOUBLE);

report;

