//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.ReportTaxes");
report.setReport("/com/openbravo/reports/taxes");
report.setResourceBundle("com/openbravo/reports/taxes_messages");

report.setSentence(
                "SELECT TAXCATEGORIES.ID AS TAXID, TAXCATEGORIES.NAME AS TAXNAME, SUM(TAXLINES.AMOUNT) AS TOTALTAXES " +
                "FROM RECEIPTS, TAXLINES, TAXES, TAXCATEGORIES " + 
                "WHERE RECEIPTS.ID = TAXLINES.RECEIPT AND TAXLINES.TAXID = TAXES.ID AND TAXES.CATEGORY = TAXCATEGORIES.ID " +
                "AND ?(QBF_FILTER) " +
                "GROUP BY TAXCATEGORIES.ID,  TAXCATEGORIES.NAME");

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());


report.addQBFFilter(paramdates);

report.addField("TAXID", com.procaisse.db.metadata.Datas.STRING);
report.addField("TAXNAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("TOTALTAXES", com.procaisse.db.metadata.Datas.DOUBLE);

report;
