//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.TaxCatSales");
report.setReport("/com/openbravo/reports/taxcatsales");
report.setResourceBundle("com/openbravo/reports/taxcatsales_messages");

report.setSentence("SELECT " +
		"CLOSEDCASH.HOST, " +
		"CLOSEDCASH.MONEY, " +
		"CLOSEDCASH.DATEEND, " +
		"TAXES.NAME AS TAXNAME, CATEGORIES.NAME, " +
		"SUM(TICKETLINES.UNITS) AS QTY, " +
		"SUM(TICKETLINES.PRICE * TICKETLINES.UNITS) AS CATPRICE, " +
		"SUM((TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) AS CATTAX, " +
		"SUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) AS CATTOTAL " +
		"FROM CLOSEDCASH, TAXES, TICKETLINES " +
		"LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID " +
		"LEFT OUTER JOIN PRODUCTS_CAT ON PRODUCTS_CAT.PRODUCT = PRODUCTS.ID " +
		"LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
		"LEFT OUTER JOIN TICKETS ON TICKETS.ID = TICKETLINES.TICKET " +
		"LEFT OUTER JOIN RECEIPTS ON RECEIPTS.ID = TICKETS.ID " +
		"WHERE CLOSEDCASH.MONEY = RECEIPTS.MONEY " +
		"AND TICKETLINES.TAXID = TAXES.ID " +
		"AND ?(QBF_FILTER) " +
		"GROUP BY CLOSEDCASH.HOST, CLOSEDCASH.MONEY, CLOSEDCASH.DATEEND, TAXES.NAME, CATEGORIES.NAME " +
		"ORDER BY TAXES.NAME, CATEGORIES.NAME");

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("HOST", com.procaisse.db.metadata.Datas.STRING);
report.addField("MONEY", com.procaisse.db.metadata.Datas.STRING);
report.addField("DATEEND", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("TAXNAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("NAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("QTY", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("CATPRICE", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("CATTAX", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("CATTOTAL", com.procaisse.db.metadata.Datas.DOUBLE);

report;