//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.SalesByCustomer");
report.setReport("/com/openbravo/reports/salebycustomer");
report.setResourceBundle("com/openbravo/reports/salebycustomer_messages");

report.setSentence("SELECT " +
                "CUSTOMERS.NAME AS CNAME, " +
                "RECEIPTS.DATENEW, " +
                "TICKETS.TICKETID, " +
                "PRODUCTS.NAME AS PNAME, " +                
                "TICKETS.TICKETTYPE, " +
                "SUM(TICKETLINES.UNITS) AS UNITS, " +
                "SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL " +
                "FROM RECEIPTS, CUSTOMERS, TICKETS, TICKETLINES LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID " +
                "WHERE CUSTOMERS.ID = TICKETS.CUSTOMER AND TICKETLINES.PRODUCT = PRODUCTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND ?(QBF_FILTER) " +
                "GROUP BY CUSTOMERS.NAME, RECEIPTS.DATENEW, TICKETS.TICKETID, PRODUCTS.NAME, TICKETS.TICKETTYPE " +
                "ORDER BY CUSTOMERS.NAME, PRODUCTS.NAME, RECEIPTS.DATENEW");

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addParameter("CUSTOMERS.ID");
report.addParameter("CUSTOMERS.NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsCustomer());

report.addField("CNAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("DATENEW", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("TICKETID", com.procaisse.db.metadata.Datas.STRING);
report.addField("PNAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("TICKETTYPE", com.procaisse.db.metadata.Datas.INT);
report.addField("UNITS", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("TOTAL", com.procaisse.db.metadata.Datas.DOUBLE);

report;