//    uniCenta oPOS - Touch Friendly POS
//    Copyright (c) 2009 - 2014 uniCenta
//    www.unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <www.gnu.org/licenses/>.
//		added by g.irura @ 27/03/2010. 
// 		CALCULATES PROFIT FOR EACH ITEM THAT IS SOLD AS WELL AS QUANTITY OF ITEMS OCCURRING IN THE PARTICULAR SALE
//		IF A PRICE ADJUSTMENT OCCURS, IT IS REFLECTED IN THE TRAIL OF RECEIPTS ON DATES. THE REPORT ALSO SHOWS THE TOTAL PROFITS MADE ON PRODUCTS/SERVICES SOLD

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.SalesProfit");
report.setReport("/com/openbravo/reports/productsalesprofit");
report.setResourceBundle("com/openbravo/reports/productsalesprofit_messages");

// Amend: JG uniCenta May 2014
// Amend: JG uniCenta July 2014

report.setSentence("SELECT PRODUCTS.REFERENCE, " +
       "PRODUCTS.NAME, " +
       "PRODUCTS.PRICEBUY, " +
       "PRODUCTS.PRICESELL, " +
       "SUM(TICKETLINES.UNITS) AS SOLD_UNITS, " +
       "SUM(TICKETLINES.UNITS * PRODUCTS.PRICEBUY) AS COST_VALUE, " +
       "SUM(TICKETLINES.UNITS * PRODUCTS.PRICESELL) AS EXPECTED_SALES_VALUE, " +
       "SUM(TICKETLINES.PRICE) AS ACTUAL_SALES_VALUE, " +
         "SUM(TICKETLINES.UNITS * PRODUCTS.PRICESELL) " +
       "- SUM(TICKETLINES.UNITS * PRODUCTS.PRICEBUY) " +
          "AS EXPECTED_PROFIT, " +
       "SUM(TICKETLINES.PRICE) - SUM(TICKETLINES.UNITS * PRODUCTS.PRICEBUY) " +
          "AS ACTUAL_PROFIT " +
  "FROM (TICKETLINES TICKETLINES " +
       "INNER JOIN RECEIPTS RECEIPTS " +
           "ON (TICKETLINES.TICKET = RECEIPTS.ID)) " +
       "LEFT OUTER JOIN PRODUCTS PRODUCTS " +
          "ON (TICKETLINES.PRODUCT = PRODUCTS.ID) " +
    "WHERE ?(QBF_FILTER) " +
    "GROUP BY TICKETLINES.PRODUCT " +
    "ORDER BY PRODUCTS.REFERENCE ASC");

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("REFERENCE", com.procaisse.db.metadata.Datas.STRING);
report.addField("NAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("PRICEBUY", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("PRICESELL", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("SOLD_UNITS", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("COST_VALUE", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("EXPECTED_SALES_VALUE", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("ACTUAL_SALES_VALUE", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("EXPECTED_PROFIT", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("ACTUAL_PROFIT", com.procaisse.db.metadata.Datas.DOUBLE);


report;