//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.CategoryProductSalesChart");
report.setReport("/com/openbravo/reports/piesalescat");
report.setResourceBundle("com/openbravo/reports/piesalescat_messages");

report.setSentence("SELECT "+
                   "CATEGORIES.NAME AS CAT, " +
                   "SUM(TICKETLINES.UNITS) AS UNITS, " +
                   "SUM(TICKETLINES.PRICE * TICKETLINES.UNITS) AS TOTAL " +
                   "FROM TICKETLINES " +
                   "LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID " +
                   "LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID " +
                   "LEFT OUTER JOIN TICKETS ON TICKETLINES.TICKET = TICKETS.ID " +
                   "LEFT OUTER JOIN RECEIPTS ON TICKETS.ID = RECEIPTS.ID " +
                   "WHERE LENGTH(CATEGORIES.NAME) > '1' AND ?(QBF_FILTER) " +
                   "GROUP BY CATEGORIES.ID, CATEGORIES.NAME "+
                   "ORDER BY CATEGORIES.NAME ASC");

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("CAT", com.procaisse.db.metadata.Datas.STRING);
report.addField("UNITS", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("TOTAL", com.procaisse.db.metadata.Datas.DOUBLE);

report;
