//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2013 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

// *** NOT SUITABLE FOR DERBY DB'S***

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.ExtendedByProducts");
report.setReport("/com/openbravo/reports/extproducts");
report.setResourceBundle("com/openbravo/reports/extproducts_messages");

report.setSentence("SELECT " +
        "CUSTOMERS.TAXID,  " +
        "CUSTOMERS.NAME AS CUSTOMER, " +
        "CATEGORIES.NAME AS CATEGORY, " +
        "PRODUCTS.REFERENCE AS REFERENCE,  " +
        "PRODUCTS.NAME AS PRODUCT, " +
        "SUM(TICKETLINES.UNITS) AS UNIT,  " +
        "SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL, " +
        "SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) / SUM(TICKETLINES.UNITS) AS MEANPRICE " +
        "FROM TICKETS  " +
            "LEFT OUTER JOIN CUSTOMERS ON TICKETS.CUSTOMER = CUSTOMERS.ID, TICKETLINES " +
            "LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID " +
            "LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID, RECEIPTS " +
        "WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND ?(QBF_FILTER) " +
        "GROUP BY CUSTOMERS.ID, CATEGORIES.ID, PRODUCTS.ID " +
        "ORDER BY CUSTOMERS.NAME, CATEGORIES.NAME, PRODUCTS.NAME");

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsDatesInterval());

report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");
report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter());

report.addParameter("CUSTOMERS.ID");
report.addParameter("CUSTOMERS.NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsCustomer());

report.addField("TAXID", com.procaisse.db.metadata.Datas.STRING);
report.addField("CUSTOMER", com.procaisse.db.metadata.Datas.STRING);
report.addField("CATEGORY", com.procaisse.db.metadata.Datas.STRING);
report.addField("REFERENCE", com.procaisse.db.metadata.Datas.STRING);
report.addField("PRODUCT", com.procaisse.db.metadata.Datas.STRING);
report.addField("UNIT", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("TOTAL", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("MEANPRICE", com.procaisse.db.metadata.Datas.DOUBLE);

report;

