//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2014 Openbravo, S.L.
//    http://www.openbravo.com/product/pos
//
//    This file is part of Openbravo POS.
//
//    Openbravo POS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Openbravo POS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Openbravo POS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.ClosedProducts");
report.setReport("/com/openbravo/reports/closedproducts_1");
report.setResourceBundle("com/openbravo/reports/closedproducts_messages");

report.setSentence("SELECT " +
            "CLOSEDCASH.HOST, " +
            "CLOSEDCASH.DATESTART, " +
            "CLOSEDCASH.DATEEND, " +
            "TAXES.NAME AS TAXNAME, " +
            "PRODUCTS.REFERENCE, " +
            "PRODUCTS.NAME, " +
            "PRODUCTS.PRICESELL, " +
            "Sum(TICKETLINES.UNITS) AS UNITS, " +
            "Sum((TICKETLINES.PRICE+(TICKETLINES.PRICE*TAXES.RATE))*TICKETLINES.UNITS) AS TOTAL " +
        "FROM (TAXES INNER JOIN " +
            "((PRODUCTS INNER JOIN " +
            "(TICKETS INNER JOIN TICKETLINES ON TICKETS.ID = TICKETLINES.TICKET) " +
            "ON PRODUCTS.ID = TICKETLINES.PRODUCT) " +
            "INNER JOIN RECEIPTS ON TICKETS.ID = RECEIPTS.ID) " +
            "ON TAXES.ID = TICKETLINES.TAXID) INNER JOIN CLOSEDCASH " +
            "ON RECEIPTS.MONEY = CLOSEDCASH.MONEY " +
        "WHERE ?(QBF_FILTER) " +
        "GROUP BY CLOSEDCASH.HOST, CLOSEDCASH.DATESTART, CLOSEDCASH.DATEEND, TAXES.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.PRICESELL " +
        "ORDER BY CLOSEDCASH.HOST, TAXES.NAME, PRODUCTS.NAME");

report.addParameter("CLOSEDCASH.DATEEND");
report.addParameter("CLOSEDCASH.DATEEND");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("HOST", com.procaisse.db.metadata.Datas.STRING);
report.addField("DATESTART", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("DATEEND", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("TAXNAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("REFERENCE", com.procaisse.db.metadata.Datas.STRING);
report.addField("NAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("PRICE", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("UNITS", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("TOTAL", com.procaisse.db.metadata.Datas.DOUBLE);

report;