//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.ClosedProducts");
report.setReport("/com/openbravo/reports/closedproducts");
report.setResourceBundle("com/openbravo/reports/closedproducts_messages");

report.setSentence("SELECT " + 
                        "CLOSEDCASH.HOST, " +
                        "CLOSEDCASH.MONEY, " +
                        "CLOSEDCASH.DATEEND, " +
                        "PRODUCTS.REFERENCE, " +
                        "PRODUCTS.NAME, " +
                        "PRODUCTS.PRICESELL+(PRODUCTS.PRICESELL*TAXES.RATE) AS PRICE, " +
                            "Sum(TICKETLINES.UNITS) AS UNITS, " +
                            "Sum((PRODUCTS.PRICESELL+PRODUCTS.PRICESELL*TAXES.RATE)*UNITS) AS VALUE, " +
                            "Sum((PRODUCTS.PRICESELL+PRODUCTS.PRICESELL*TAXES.RATE)*TICKETLINES.UNITS-(TICKETLINES.PRICE+(TICKETLINES.PRICE*TAXES.RATE))*TICKETLINES.UNITS) AS DISCOUNT, " +
                            "Sum((TICKETLINES.PRICE+(TICKETLINES.PRICE*TAXES.RATE))*TICKETLINES.UNITS) AS TOTAL " +
                        "FROM ((TICKETS INNER JOIN (TICKETLINES INNER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID) " +
                            "ON TICKETS.ID = TICKETLINES.TICKET) INNER JOIN (RECEIPTS INNER JOIN CLOSEDCASH " +
                            "ON RECEIPTS.MONEY = CLOSEDCASH.MONEY) ON TICKETS.ID = RECEIPTS.ID) INNER JOIN TAXES ON TICKETLINES.TAXID = TAXES.ID " +
                        "WHERE CLOSEDCASH.MONEY = RECEIPTS.MONEY AND RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND ?(QBF_FILTER) " +
                        "GROUP BY CLOSEDCASH.HOST, CLOSEDCASH.MONEY, CLOSEDCASH.DATEEND, PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.PRICESELL+(PRODUCTS.PRICESELL*TAXES.RATE) " +
                        "ORDER BY PRODUCTS.NAME, CLOSEDCASH.HOST, CLOSEDCASH.DATEEND");

report.addParameter("CLOSEDCASH.DATEEND");
report.addParameter("CLOSEDCASH.DATEEND");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addParameter("PRODUCTS.NAME");
report.addParameter("PRODUCTS.PRICEBUY");
report.addParameter("PRODUCTS.PRICESELL");
report.addParameter("PRODUCTS.CATEGORY");
report.addParameter("PRODUCTS.CODE");

report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter());

report.addField("HOST", com.procaisse.db.metadata.Datas.STRING);
report.addField("MONEY", com.procaisse.db.metadata.Datas.STRING);
report.addField("DATEEND", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("REFERENCE", com.procaisse.db.metadata.Datas.STRING);
report.addField("NAME", com.procaisse.db.metadata.Datas.STRING);
report.addField("PRICE", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("UNITS", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("VALUE", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("DISCOUNT", com.procaisse.db.metadata.Datas.DOUBLE);
report.addField("TOTAL", com.procaisse.db.metadata.Datas.DOUBLE);

report;