//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2015 uniCenta & previous Openbravo POS works
//    http://www.unicenta.net
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Closing");
report.setReport("/com/openbravo/reports/closedpos");
report.setResourceBundle("com/openbravo/reports/closedpos_messages");

report.setSentence("SELECT " + 
                    "CLOSEDCASH.HOST, " +
                    "CLOSEDCASH.HOSTSEQUENCE, " +
                    "CLOSEDCASH.MONEY, " +
                    "CLOSEDCASH.DATESTART, " +
                    "CLOSEDCASH.DATEEND, " +
                    "PAYMENTS.PAYMENT, " +
                    "SUM(PAYMENTS.TOTAL) AS TOTAL " +
                    "FROM CLOSEDCASH, PAYMENTS, RECEIPTS " +
                    "WHERE CLOSEDCASH.MONEY = RECEIPTS.MONEY AND PAYMENTS.RECEIPT = RECEIPTS.ID AND ?(QBF_FILTER) " +
                    "GROUP BY CLOSEDCASH.HOST, CLOSEDCASH.HOSTSEQUENCE, CLOSEDCASH.MONEY, CLOSEDCASH.DATESTART, CLOSEDCASH.DATEEND, PAYMENTS.PAYMENT " +
                    "ORDER BY CLOSEDCASH.HOST, CLOSEDCASH.HOSTSEQUENCE");

report.addParameter("CLOSEDCASH.DATEEND");
report.addParameter("CLOSEDCASH.DATEEND");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("HOST", com.procaisse.db.metadata.Datas.STRING);
report.addField("HOSTSEQUENCE", com.procaisse.db.metadata.Datas.INT);
report.addField("MONEY", com.procaisse.db.metadata.Datas.STRING);
report.addField("DATESTART", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("DATEEND", com.procaisse.db.metadata.Datas.TIMESTAMP);
report.addField("PAYMENT", com.procaisse.db.metadata.Datas.STRING);
report.addField("TOTAL", com.procaisse.db.metadata.Datas.DOUBLE);

report;

