ALTER TABLE TRANSACTIONS_MEV ADD COLUMN SIGNATURE VARCHAR(2000) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN MODE_PRINT VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN FORM_PRINT VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN STATUS VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN TOTAL_BEFORE_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN TOTAL_AFTER_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN TIP INTEGER DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN DISCOUNT_AFTER_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN TYPE_OPERATION VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN ADJUSTMENT DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN MTDU DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN CERTIFICATE_THUMB_PRINT VARCHAR(1024) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN TPS DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN TVQ DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN USER_NAME VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN MODE_PAYMENT VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN DATE_SIGNATURE TIMESTAMP DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN DATE_MEV_TRANSACTION TIMESTAMP DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN NUMBER_MEV_TRANSACTION VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN COPIED SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTIONS_MEV ADD COLUMN OFFLINE_MESSAGE VARCHAR(255) DEFAULT NULL;
ALTER TABLE TRANSACTION_LINES_DELETETED ADD COLUMN ABANDONED SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE TRANSACTION_LINES_DELETETED ADD COLUMN TVA_GLOBAL_NO_APPLICABLE SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE LOG_PANIER ADD COLUMN NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL;
CREATE TABLE REFS_TRANSACTION(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_TRANSACTION TIMESTAMP DEFAULT NULL,
    TOTAL_BEFORE_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL,
    REF_TRANSACTION_ID INTEGER DEFAULT 0,
    TOTAL_AFTER_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TIP INTEGER DEFAULT 0 NOT NULL,
    TRANSACTION_ID INTEGER DEFAULT 0,
    PRIMARY KEY (ID),
    CONSTRAINT REF_TRANSACTION_FK FOREIGN KEY (TRANSACTION_ID) REFERENCES TRANSACTIONS_MEV(ID)
);
CREATE TABLE CONFIGURATION_MEV(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    KEY_CONFIG VARCHAR(255) DEFAULT NULL,
    VALUE_CONFIG VARCHAR(1024) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE ITEM_PRECISIONS(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    PRECISION_NAME VARCHAR(255) DEFAULT NULL,
    QUANTITY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE DOUBLE DEFAULT 0 NOT NULL,
    ITEM_ID INTEGER DEFAULT 0,
    PRECISION_TYPE VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT ITEM_PRECISION_FK FOREIGN KEY (ITEM_ID) REFERENCES TRANSACTION_LINES_DELETETED(ID)
);
CREATE TABLE SALES_SUMMARY(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME_USER VARCHAR(255) DEFAULT NULL,
    NUMBER_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    NUMBER_MEV_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    TOTAL_AFTER_TAX_LAST_TRANSACTION_PRINTED DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DATE_LAST_TRANSACTION_PRINTED timestamp,
    DATE_MEV_LAST_TRANSACTION_PRINTED timestamp,
    YEAR_TRANSACTIONS VARCHAR(255) DEFAULT NULL,
    NUMBER_TOTAL_TRANSACTIONS INTEGER DEFAULT 0,
    NUMBER_TRANSACTIONS_PAYMENTS INTEGER DEFAULT 0,
    TOTAL_BEFORE_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TPS DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TVQ DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_AFTER_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_ADJUSTMENT DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_MTDU DOUBLE DEFAULT 0 NOT NULL,
    DEVICE_ID VARCHAR(255) DEFAULT NULL,
    OFFLINE_MESSAGE_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE USER_REPORT(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NO_TPS VARCHAR(255) DEFAULT NULL,
    NO_TVQ VARCHAR(255) DEFAULT NULL,
    NAME_USER VARCHAR(255) DEFAULT NULL,
    NUMBER_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    NUMBER_MEV_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    TOTAL_AFTER_TAX_LAST_TRANSACTION_PRINTED DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DATE_LAST_TRANSACTION_PRINTED timestamp,
    DATE_MEV_LAST_TRANSACTION_PRINTED timestamp,
    YEAR_REPORT VARCHAR(255) DEFAULT NULL,
    NUMBER_TOTAL_TRANSACTIONS INTEGER DEFAULT 0,
    NUMBER_TRANSACTIONS_PAYMENTS INTEGER DEFAULT 0,
    TOTAL_BEFORE_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TPS DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TVQ DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_AFTER_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_ADJUSTMENT DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_MTDU DOUBLE DEFAULT 0 NOT NULL,
    SOURCE_REPORT VARCHAR(255) DEFAULT NULL,
    DEVICE_OR_BILLING_ID VARCHAR(255) DEFAULT NULL,
    USER_SCOPE VARCHAR(255) DEFAULT NULL,
    DEVICE_ID VARCHAR(255) DEFAULT NULL,
    ID_SEV VARCHAR(255) DEFAULT NULL,
    VERSION_SEV VARCHAR(255) DEFAULT NULL,
    USER_LOGIN_TIME timestamp,
    CREATED_AT timestamp,
    SIGNATURE VARCHAR(255) DEFAULT NULL,
    CERTIFICATE_THUMB_PRINT VARCHAR(255) DEFAULT NULL,
    RESTAURANT_ADDRESS VARCHAR(255) DEFAULT NULL,
    RESTAURANT_NAME VARCHAR(255) DEFAULT NULL,
    OFFLINE_MESSAGE_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE OFFLINE_MODE_JOURNAL(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_OFFLINE_EVENT timestamp,
    ID_USER_CONNECTED_IN_OFFLINE_EVENT VARCHAR(255) DEFAULT NULL,
    NAME_USER_CONNECTED_IN_OFFLINE_EVENT VARCHAR(255) DEFAULT NULL,
    DATE_ONLINE_EVENT timestamp,
    ID_USER_CONNECTED_IN_ONLINE_EVENT VARCHAR(255) DEFAULT NULL,
    NAME_USER_CONNECTED_IN_ONLINE_EVENT VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE ERRORS_MEV_WEB(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_ERROR VARCHAR(255) DEFAULT NULL,
    MESSAGE VARCHAR(1024) DEFAULT NULL,
    CODE_RETOUR VARCHAR(255) DEFAULT NULL,
    CREATED_AT timestamp,
    TYPE_REQUEST VARCHAR(255) DEFAULT NULL,
    NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE LOGS_DATA_MEV(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_OPERATION timestamp,
    ID_USER VARCHAR(255) DEFAULT NULL,
    NAME_USER VARCHAR(255) DEFAULT NULL,
    NAME_OPERATION VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
ALTER TABLE PEOPLE ADD COLUMN REGISTERED_IN_MEV SMALLINT DEFAULT 0 NOT NULL;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};