
CREATE TABLE Nutritional (
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    
    -- energie
    energy_kcal_value DOUBLE,
    energy_kcal_daily_percentage DOUBLE,
    
    -- Fibres
    fiber_g_value DOUBLE,
    fiber_g_daily_percentage DOUBLE,
    
    -- Lipides
    fat_g_value DOUBLE,
    fat_saturated_g DOUBLE,
    fat_g_daily_percentage DOUBLE,
    
    -- Glucides
    carbs_g_value DOUBLE,
    sugar_g DOUBLE,
    carbs_g_daily_percentage DOUBLE,
    
    -- Proteines
    protein_g_value DOUBLE,
    protein_g_daily_percentage DOUBLE,
    
    -- Sel
    salt_g_value DOUBLE,
    salt_g_daily_percentage DOUBLE,

    -- Image et couleur (supposees communes)
    image_path VARCHAR(255),
    color VARCHAR(20),
    idProductNutri INTEGER NOT NULL,
    
    -- Foreign key with a unique constraint name
    CONSTRAINT Nutritional_FK1 FOREIGN KEY (idProductNutri) REFERENCES PRODUCTS(ID)
);
CREATE TABLE NUTRIENT_DATA (
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    IMAGE VARCHAR(255),
    COLOR VARCHAR(100),
    NUTRIENT VARCHAR(100)
);
CREATE TABLE ALLERGENE (
    NAME VARCHAR(255),
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    idProductAllergene INTEGER NOT NULL,
    CONSTRAINT ALLERGENE_FK1 FOREIGN KEY (idProductAllergene) REFERENCES PRODUCTS(ID)
);
CREATE TABLE ALLERGENE_SUPPLEMENT (
    NAME VARCHAR(255),
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    ID_SUPPLEMENT INTEGER NOT NULL,
    CONSTRAINT ALLERGENE_SUPPLEMENT_ITEM_FK FOREIGN KEY (ID_SUPPLEMENT) REFERENCES supplement_item(id)
);
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};