ALTER TABLE ENTETE_NOTE ADD COLUMN HAS_RECAP_TAX SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE LINES_NOTE ADD COLUMN CODE_TAX VARCHAR(256);
ALTER TABLE LINES_NOTE ADD COLUMN RATE_TAX DOUBLE PRECISION;
ALTER TABLE LINES_NOTE ADD COLUMN TOTAL_HT DOUBLE PRECISION;
CREATE TABLE RECAP_TAX_NOTE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    CODE_TAX VARCHAR(256),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    REF_NOTE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT TAX_FK_NOTE FOREIGN KEY (REF_NOTE) REFERENCES ENTETE_NOTE(ID)
);
CREATE TABLE RECAP_GENERAL_NOTE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TOTAL_DISCOUNT DOUBLE PRECISION,
    REF_NOTE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT RECAP_GENERAL_FK_NOTE FOREIGN KEY (REF_NOTE) REFERENCES ENTETE_NOTE(ID)
);
ALTER TABLE TOTAL_ENCAISSEMENT ADD COLUMN TOTAL_DISCOUNT DOUBLE PRECISION;
CREATE TABLE LINES_FACTURE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    ORIGIN_DATA VARCHAR(256) DEFAULT 'IN' NOT NULL,
    NUM_LINE INTEGER,
    CODE_PRODUCT VARCHAR(256),
    LABEL_PRODUCT VARCHAR(256),
    QUANTITY DOUBLE PRECISION,
    PRICE_HT DOUBLE PRECISION,
    TAUX_DISCOUNT DOUBLE PRECISION,
    TOTAL_HT_DISCOUNTED  DOUBLE PRECISION,
    TOTAL_HT DOUBLE PRECISION,
    CODE_TAX VARCHAR(256),
    RATE_TAX DOUBLE PRECISION ,
    PRICE_TTC  DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    timestampGDH timestamp,
    horodatage VARCHAR(256) default NULL,
    REF_FACTURE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT LINE_KF_FACTURE FOREIGN KEY (REF_FACTURE) REFERENCES FACTURE(ID)
);
CREATE TABLE RECAP_TAX_FACTURE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    CODE_TAX VARCHAR(256),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    REF_FACTURE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT RECAP_TAX_FK_FACTURE FOREIGN KEY (REF_FACTURE) REFERENCES FACTURE(ID)
);
CREATE TABLE RECAP_GENERAL_FACTURE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_DISCOUNT DOUBLE PRECISION,
    REF_FACTURE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT RECAP_GENERAL_FK_TICKET FOREIGN KEY (REF_FACTURE) REFERENCES FACTURE(ID)
);
ALTER TABLE ENTETE ADD COLUMN RESTITUTION_TYPE VARCHAR(256) DEFAULT  'impression papier';
ALTER TABLE ENTETE ADD COLUMN NB_SEND_E_TICKET INTEGER default 0;
ALTER TABLE MARUQENF525 ADD COLUMN FIRST_CONNEXION TIMESTAMP DEFAULT NULL;
ALTER TABLE FACTURE ADD COLUMN REGLEMENT_TVA_SENDER VARCHAR(256) DEFAULT 'TVA sur les encaissements' NOT NULL;
ALTER TABLE FACTURE ADD COLUMN FACTURE_TYPE VARCHAR(256) DEFAULT 'Bien' NOT NULL;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};
