CREATE TABLE CATEGORY_DAYS_ON (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DAY_OF_WEEK INTEGER NOT NULL,
   ID_CATEGORY INTEGER NOT NULL,
   STATUS SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT CATEGORY_DAYS_ON_FK1 FOREIGN KEY (ID_CATEGORY) REFERENCES CATEGORIES(ID)
);
CREATE TABLE SHIFT_CATEGORY (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DATE_START VARCHAR(256) NOT NULL,
   DATE_END VARCHAR(256) NOT NULL,
   idCategory INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT SHIFT_CATEGORY_FK1 FOREIGN KEY (idCategory) REFERENCES CATEGORIES(ID)
);
CREATE TABLE SHIFT_PRODUCT (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DATE_START VARCHAR(256) NOT NULL,
   DATE_END   VARCHAR(256) NOT NULL,
   idproduct INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT SHIFT_PRODUCT_FK1 FOREIGN KEY (idproduct) REFERENCES PRODUCTS(ID)
);
ALTER TABLE CATEGORIES ADD COLUMN HAS_TIMETABLE SMALLINT DEFAULT 0 NOT NULL;
CREATE TABLE FILES_CHANGE_INFO(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    LAST_UPDATE TIMESTAMP DEFAULT NULL,
    PRIMARY KEY (ID)
);
ALTER TABLE CATEGORIES ADD COLUMN DATE_START_DISPLAY    TIMESTAMP default null;
ALTER TABLE CATEGORIES ADD COLUMN  DATE_END_DISPLAY    TIMESTAMP default null;

ALTER TABLE supplement ADD COLUMN DATE_START_DISPLAY    TIMESTAMP default null;
ALTER TABLE supplement ADD COLUMN  DATE_END_DISPLAY    TIMESTAMP default null;

ALTER TABLE PRODUCTS ADD COLUMN DATE_START_DISPLAY    TIMESTAMP default null;
ALTER TABLE PRODUCTS ADD COLUMN  DATE_END_DISPLAY    TIMESTAMP default null;

ALTER TABLE PROMOTIONS ADD COLUMN DATE_START_DISPLAY    TIMESTAMP default null;
ALTER TABLE PROMOTIONS ADD COLUMN  DATE_END_DISPLAY    TIMESTAMP default null;

ALTER TABLE GROUPE_SUB_SUPPLEMENTS ADD COLUMN DATE_START_DISPLAY    TIMESTAMP default null;
ALTER TABLE GROUPE_SUB_SUPPLEMENTS ADD COLUMN  DATE_END_DISPLAY    TIMESTAMP default null;

ALTER TABLE SUPPLEMENT_ITEM ADD COLUMN DATE_START_DISPLAY    TIMESTAMP default null;
ALTER TABLE SUPPLEMENT_ITEM ADD COLUMN  DATE_END_DISPLAY    TIMESTAMP default null;
CREATE TABLE IMAGES_PRODUCTS(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME VARCHAR(255) DEFAULT NULL,
    PATH VARCHAR(255) DEFAULT NULL,
    URL VARCHAR(1024) DEFAULT NULL,
    GRAPHIC_TYPE VARCHAR(255) DEFAULT NULL,
    ID_PRODUCT INTEGER,
    PRIMARY KEY (id),
    CONSTRAINT IMAGES_PRODUCTS_FK FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID)
);
CREATE TABLE CARTE_INFO(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    LAST_UPDATE TIMESTAMP DEFAULT NULL,
    FIRST_MENU_DOWNLOADED SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID)
);
insert into IMAGES_PRODUCTS (NAME, PATH, ID_PRODUCT) SELECT 'image_pos', path, id from products where path is not null and path <> '';
insert into IMAGES_PRODUCTS (NAME, PATH, ID_PRODUCT) SELECT 'image_platform', PATH_2, id from products where PATH_2 is not null and PATH_2 <> '';
insert into IMAGES_PRODUCTS (NAME, PATH, GRAPHIC_TYPE, ID_PRODUCT) SELECT 'image_product_moment', PATH_PRODUCT_MOMENT, type_image_product_moment, id from products where PATH_PRODUCT_MOMENT is not null and PATH_PRODUCT_MOMENT <> '';
ALTER TABLE supplement_item ADD COLUMN IMAGE_URL varchar(1024) DEFAULT NULL;
ALTER TABLE CATEGORIES ADD COLUMN IMAGE_URL varchar(1024) DEFAULT NULL;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};
