CREATE TABLE MULTILANGUAGE_PRODUCT(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    DESCRIPTION VARCHAR(1024),
    DESCRIPTION_PLATFORM VARCHAR(1024),
    ID_PRODUCT INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_PRODUCTS_FK FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID)
);
CREATE TABLE MULTILANGUAGE_CATEGORY(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_CATEGORY INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_CATEGORY_FK FOREIGN KEY (ID_CATEGORY) REFERENCES CATEGORIES(ID)
);
CREATE TABLE MULTILANGUAGE_SUPPLEMENT(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_SUPPLEMENT INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_SUPPLEMENT_FK FOREIGN KEY (ID_SUPPLEMENT) REFERENCES supplement(id)
);
CREATE TABLE MULTILANGUAGE_SUPPLEMENT_ITEM(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_SUPPLEMENT_ITEM INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_SUPPLEMENT_ITEM_FK FOREIGN KEY (ID_SUPPLEMENT_ITEM) REFERENCES supplement_item(id)
);
CREATE TABLE MULTILANGUAGE_CARTE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_CARTE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_CARTE_FK FOREIGN KEY (ID_CARTE) REFERENCES carte(id)
);
CREATE TABLE MULTILANGUAGE_PROMOTION(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    TEXT_PROMO VARCHAR(255),
    DESCRIPTION VARCHAR(1024),
    ID_PROMOTION INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_PROMOTION_FK FOREIGN KEY (ID_PROMOTION) REFERENCES PROMOTIONS(ID)
);
CREATE TABLE MULTILANGUAGE_GROUPE_SUB_SUPPLEMENTS(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    TITLE VARCHAR(255),
    LANGUAGE VARCHAR(255),
    TITLE_GROUP VARCHAR(255),
    ID_GROUPE_SUB_SUPPLEMENTS INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_GROUPE_SUB_SUPPLEMENTS_FK FOREIGN KEY (ID_GROUPE_SUB_SUPPLEMENTS) REFERENCES GROUPE_SUB_SUPPLEMENTS(ID)
);

UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};
