CREATE TABLE GTP_TAXES(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    ID_PERIOD VARCHAR(256),
    CODE_TAX VARCHAR(255),
    NAME VARCHAR(255),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TAXE_GLOBAL SMALLINT DEFAULT 0 NOT NULL,
    type_periode VARCHAR(256),
    PRIMARY KEY (id),
    CONSTRAINT GTP_TAXES_FK FOREIGN KEY (ID_PERIOD) REFERENCES GRAND_TOTAL_PERIODE(ID)
);
CREATE TABLE Z_GLOBAL_TAXES(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    ID_Z_GLOBAL INTEGER,
    CODE_TAX VARCHAR(255),
    NAME VARCHAR(255),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TAXE_GLOBAL SMALLINT DEFAULT 0 NOT NULL,
    ID_PERIODE VARCHAR(255) DEFAULT NULL,
    TYPE_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    ADDRESS_IP VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (id),
    CONSTRAINT Z_GLOBAL_TAXES_FK FOREIGN KEY (ID_Z_GLOBAL) REFERENCES Z_GLOBAL(ID)
);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED, TAXE_GLOBAL) VALUES ('hst', 'HST', 0.13, 0, 1);
update TAXCATEGORIES set ENABLED = 1 where ID in ('tps', 'tvq');
INSERT INTO GTP_TAXES (ID_PERIOD, CODE_TAX, NAME, RATE_TAX, TOTAL_TAX, TAXE_GLOBAL, type_periode) SELECT ID, 'tps', 'TPS', 0.05, TPS, 1, type_periode  FROM GRAND_TOTAL_PERIODE where TPS <> 0;
INSERT INTO GTP_TAXES (ID_PERIOD, CODE_TAX, NAME, RATE_TAX, TOTAL_TAX, TAXE_GLOBAL, type_periode) SELECT ID, 'tvq', 'TVQ', 0.09975, TVQ, 1, type_periode  FROM GRAND_TOTAL_PERIODE where TVQ <> 0;
INSERT INTO Z_GLOBAL_TAXES (ID_Z_GLOBAL, CODE_TAX, NAME, RATE_TAX, TOTAL_TAX, TAXE_GLOBAL, ID_PERIODE, TYPE_PERIODE, ADDRESS_IP) SELECT ID, 'tps', 'TPS', 0.05, TPS, 1, ID_PERIODE, type_periode, ADDRESS_IP  FROM Z_GLOBAL where TPS <> 0;
INSERT INTO Z_GLOBAL_TAXES (ID_Z_GLOBAL, CODE_TAX, NAME, RATE_TAX, TOTAL_TAX, TAXE_GLOBAL, ID_PERIODE, TYPE_PERIODE, ADDRESS_IP) SELECT ID, 'tvq', 'TVQ', 0.09975, TVQ, 1, ID_PERIODE, type_periode, ADDRESS_IP  FROM Z_GLOBAL where TVQ <> 0;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};
