CREATE TABLE TIMETABLE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DAY INTEGER NOT NULL,
   NAME_DAY VARCHAR(255) DEFAULT NULL,
   DAY_OFF SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);
CREATE TABLE WORKSHIFT(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   START_SHIFT VARCHAR(255) DEFAULT NULL,
   END_SHIFT VARCHAR(255) DEFAULT NULL,
   IDTIMETABLE INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT WORKSHIFT_FK FOREIGN KEY (IDTIMETABLE) REFERENCES TIMETABLE(ID)
);
CREATE TABLE ZONEDELIVERY(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   ZONE_NAME VARCHAR(255) DEFAULT NULL,
   MIN_TOTAL DOUBLE PRECISION DEFAULT 0,
   PRIMARY KEY (ID)
);
CREATE TABLE CITYDELIVERY(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   CITY VARCHAR(255) DEFAULT NULL,
   ZIP_CODE VARCHAR(255) DEFAULT NULL,
   IDZONEDELIVERY INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT CITYDELIVERY_FK FOREIGN KEY (IDZONEDELIVERY) REFERENCES ZONEDELIVERY(ID)
);
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};