CREATE TABLE EMPLOYEES (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME_EMPLOYEE VARCHAR(1024) NOT NULL,
    PHONE varchar(255) DEFAULT NULL,
    CREDIT DOUBLE PRECISION DEFAULT 0,
    REMOVED SMALLINT DEFAULT 0 NOT NULL,
    EMAIL varchar(255) DEFAULT NULL,
    FUNCTION_EMPLOYEE varchar(255) DEFAULT NULL,
    CODE_CARTE varchar(255) DEFAULT NULL,
    FIXED_AMOUNT DOUBLE PRECISION DEFAULT 0,
    PRIMARY KEY (ID)
);
CREATE TABLE CREDIT_EMPLOYEE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    AMOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DATE_PAYMENT timestamp,
    EMPLOYEE INTEGER NOT NULL,
    TICKET VARCHAR(256) NOT NULL,
    PAYMENT VARCHAR(256) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT CREDIT_EMPLOYEE_FK1 FOREIGN KEY (EMPLOYEE) REFERENCES EMPLOYEES(ID),
    CONSTRAINT CREDIT_EMPLOYEE_FK2 FOREIGN KEY (TICKET) REFERENCES TICKETS(ID),
    CONSTRAINT CREDIT_EMPLOYEE_FK3 FOREIGN KEY (PAYMENT) REFERENCES PAYMENTS(ID)
);
CREATE TABLE RECHARGE_CREDIT_EMPLOYEE (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_MAJ TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID)
);
INSERT INTO RECHARGE_CREDIT_EMPLOYEE (DATE_MAJ) VALUES(CURRENT_TIMESTAMP);
ALTER TABLE PEOPLE ADD COLUMN REF_SYNCHRO VARCHAR(256) DEFAULT NULL;
ALTER TABLE PHOTO_DISPLAY ADD COLUMN REF_SYNCH VARCHAR(255) DEFAULT NULL;
ALTER TABLE PHOTO_PUB_BORNE ADD COLUMN REF_SYNCH VARCHAR(255) DEFAULT NULL;
ALTER TABLE PHOTO_HOME_BORNE ADD COLUMN REF_SYNCH VARCHAR(255) DEFAULT NULL;

UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};