CREATE TABLE TICKETS_KITCHEN (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TYPE_ORDER VARCHAR(256) DEFAULT NULL,
    CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    CAISSE VARCHAR(255) DEFAULT NULL,
    NUM_ORDER INTEGER DEFAULT 0,
    NUM_TABLE INTEGER DEFAULT 0,
    BIPPER INTEGER DEFAULT 0,
    COUVERTS INTEGER DEFAULT 0,
    FINISHED SMALLINT DEFAULT 0 NOT NULL,
    DATE_ORDER TIMESTAMP,
    STATUS VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE LINES_KITCHEN (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TICKET INTEGER DEFAULT NULL,
    PRODUCT VARCHAR(256) DEFAULT NULL,
    UNITS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    MENU SMALLINT DEFAULT 0 NOT NULL,
    NOTE VARCHAR(1024) DEFAULT NULL,
    SIZE_PRODUCT VARCHAR(255) DEFAULT NULL,
    FINISHED SMALLINT DEFAULT 0 NOT NULL,
    SUPPLEMENTS VARCHAR(255) DEFAULT NULL,
    INGREDIENTS VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT LINES_KITCHEN_FK_TK FOREIGN KEY (TICKET) REFERENCES TICKETS_KITCHEN(ID)
);
CREATE TABLE ITEMS_LINE (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    LINE INTEGER DEFAULT NULL,
    PRODUCT VARCHAR(256) DEFAULT NULL,
    UNITS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    SIZE_PRODUCT VARCHAR(255) DEFAULT NULL,
    SUPPLEMENTS VARCHAR(255) DEFAULT NULL,
    INGREDIENTS VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT ITEMS_LINE_FK_LINE FOREIGN KEY (LINE) REFERENCES LINES_KITCHEN(ID)
);
ALTER TABLE TICKETS_KITCHEN ADD COLUMN ID_TICKET VARCHAR(256);
ALTER TABLE LINES_KITCHEN ADD COLUMN ID_LINE INTEGER;
ALTER TABLE ITEMS_LINE ADD COLUMN ID_PRODUCT INTEGER;
ALTER TABLE LINES_KITCHEN ADD COLUMN STATUS VARCHAR(255) DEFAULT NULL;

UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};