DROP TABLE ENTETE;
CREATE TABLE ENTETE (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    version_soft VARCHAR(256) DEFAULT '2.5' NOT NULL,
    nb_print INTEGER default 0,
    company VARCHAR(256) DEFAULT  NULL,
    address VARCHAR(256) DEFAULT  NULL,
    zip_code VARCHAR(256) DEFAULT  NULL,
    city VARCHAR(256) DEFAULT  NULL,
    country VARCHAR(256) DEFAULT  NULL,
    siret VARCHAR(256) DEFAULT  NULL,
    code_NAF VARCHAR(256) DEFAULT  NULL,
    num_tva VARCHAR(256) DEFAULT  NULL,
    code_operator VARCHAR(256) DEFAULT  NULL,
    name_operator VARCHAR(256) DEFAULT  NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    nb_customer INTEGER DEFAULT 1  NOT NULL,
    timestampGDH timestamp,
    type_operation VARCHAR(256) DEFAULT 'commande' NOT NULL,
    type_doc VARCHAR(256) DEFAULT 'ticket' NOT NULL,
    nb_lines INTEGER,
    ticket VARCHAR(256) NOT NULL,
    header_Supplementaire VARCHAR(256) ,
    footer_Supplementaire VARCHAR(256) ,
    ticket_status VARCHAR(256) Default 'normal' ,
    signature_Ticket VARCHAR(2000) default null,
    PRIMARY KEY (id),
    CONSTRAINT ENTETE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE LINES;
CREATE TABLE LINES(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    code_product VARCHAR(256),
    origin_data VARCHAR(256) DEFAULT 'IN' NOT NULL,
    descriptive_product VARCHAR(256),
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION ,
    price_HT DOUBLE PRECISION,
    price_TTC  DOUBLE PRECISION,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    type_operation VARCHAR(256) DEFAULT 'Vente' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT 'N/A' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    quantite DOUBLE PRECISION,
    discount  DOUBLE PRECISION,
    taux_discount DOUBLE PRECISION,
    PRIMARY KEY (id),
    CONSTRAINT LINE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_TAX;
CREATE TABLE TOTAL_TAX(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    total_ht DOUBLE PRECISION,
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION,
    total_tax DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TAX_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_ENCAISSEMENT;
CREATE TABLE TOTAL_ENCAISSEMENT(
  id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER DEFAULT 0,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TOTAL_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TICKET_PAYMENT;
CREATE TABLE TICKET_PAYMENT(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    type_regulation VARCHAR(256) DEFAULT 'ESPECE' NOT NULL,
    code_regulation VARCHAR(256) DEFAULT  NULL,
    mode_regulation VARCHAR(256) DEFAULT NULL,
    total DOUBLE PRECISION,
    quantity DOUBLE PRECISION DEFAULT 1 NOT NULL,
    type_operation VARCHAR(256) DEFAULT 'encaissement' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT '1' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT PAYMENT_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
 ALTER TABLE duplicata drop column is_first ;
ALTER TABLE item_supplements ADD COLUMN separate SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE Option_ticket ADD COLUMN separate SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE supplement_item ADD COLUMN path varchar(255) DEFAULT NULL;
ALTER TABLE PRODUCTS ADD COLUMN additional_sale SMALLINT DEFAULT 0 NOT NULL;
CREATE TABLE PHOTO_PUB_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE PHOTO_HOME_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
ALTER TABLE PRODUCTS ADD COLUMN moment_product SMALLINT DEFAULT 0 NOT NULL;
CREATE TABLE SOFTWARE(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(256) DEFAULT  NULL,
    DATABASE_VERSION VARCHAR(256) DEFAULT  NULL,
    SOFTWARE_VERSION VARCHAR(256) DEFAULT  NULL,
    LAST_UPGRADE_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID)
);
ALTER TABLE FACTURE drop column first_signature ;
ALTER TABLE TICKETS drop column invoice ;
ALTER TABLE TICKETS add column invoice INTEGER  default NULL ;
delete from FACTURE;
ALTER TABLE TOTAL_TAX add column timestampGDH timestamp ;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};