--    uniCenta oPOS - Touch Friendly Point Of Sale
--    Copyright (C) 2009-2015 uniCenta
--    http://sourceforge.net/projects/unicentaopos
--
--    This file is part of uniCenta oPOS.
--
--    uniCenta oPOS is free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    uniCenta oPOS is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

-- Database upgrade script for DERBY
-- Openbravo v2.30.2 - uniCenta v3.00


UPDATE PRODUCTS SET bar = 1, terasse = 1, happy_hour = 1;

CREATE TABLE Duplicata(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    id_Doc VARCHAR(256) DEFAULT NULL,
    impression_Number INTEGER,
    nbre_ligne INTEGER,
    type_doc VARCHAR(256),
    user_operator VARCHAR(256) DEFAULT NULL,
    date_impression TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    signature VARCHAR(2000),
    is_first SMALLINT DEFAULT 0 NOT NULL,
    num_doc INTEGER default 0 not null ,
    CONSTRAINT DUPLICAT_USER_FK_1 FOREIGN KEY (user_operator) REFERENCES PEOPLE(ID),
    CONSTRAINT DUPLICATA_FK_TICKET FOREIGN KEY (id_Doc) REFERENCES TICKETS(ID),
    PRIMARY KEY (id)
);
ALTER TABLE ENTETE ADD COLUMN header_Supplementaire VARCHAR(256) ;
ALTER TABLE ENTETE ADD COLUMN footer_Supplementaire VARCHAR(256) ;
ALTER TABLE ENTETE ADD COLUMN ticket_status VARCHAR(256) Default 'normal' ;
ALTER TABLE ENTETE ADD COLUMN signature_Ticket VARCHAR(256) Default null;
ALTER TABLE LINES ADD COLUMN  quantite DOUBLE PRECISION Default 0 ;
ALTER TABLE LINES ADD COLUMN    discount  DOUBLE PRECISION Default 0 ;
ALTER TABLE LINES ADD COLUMN   taux_discount DOUBLE PRECISION Default 0 ;

ALTER TABLE ENTETE DROP COLUMN signature_Ticket ;
ALTER TABLE ENTETE ADD COLUMN signature_Ticket VARCHAR(2000) Default null;

DROP TABLE FACTURE;
CREATE TABLE FACTURE (
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    company VARCHAR(256) DEFAULT 'societe 1' NOT NULL,
    name_contact VARCHAR(256) DEFAULT NULL,
    address VARCHAR(256) DEFAULT '12 rue II' NOT NULL,
    zip_code VARCHAR(256) DEFAULT '7500' NOT NULL,
    city VARCHAR(256) DEFAULT 'paris' NOT NULL,
    country VARCHAR(256) DEFAULT NULL,
    siret VARCHAR(256) DEFAULT NULL,
    code_NAF VARCHAR(256) DEFAULT NULL,
    num_tva VARCHAR(256) DEFAULT NULL,
    first_signature VARCHAR(256) DEFAULT 'oui' NOT NULL,
    signature VARCHAR(2000) DEFAULT  NULL,
    ticket VARCHAR(256) NOT NULL,
    physical_person SMALLINT DEFAULT 1 NOT NULL,
    cancel SMALLINT DEFAULT 0 NOT NULL,
    nb_print INTEGER,
    date_created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    num_doc INTEGER ,
    CONSTRAINT FACTURE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID),
    CONSTRAINT FACTURE_FK_Doc FOREIGN KEY (num_doc) REFERENCES DOCUMENT(ID),
    PRIMARY KEY (id)
);
Alter table GRAND_TOTAL_PERIODE drop column total_ttc;
Alter table GRAND_TOTAL_PERIODE add column type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL;
Alter table GRAND_TOTAL drop column first_signature ;
Alter table GRAND_TOTAL drop column report_signature ;
Alter table GRAND_TOTAL_PERIODE drop column first_signature ;
Alter table GRAND_TOTAL_PERIODE drop column report_signature ;

Alter table GRAND_TOTAL add column signature VARCHAR(2000) DEFAULT  NULL;
Alter table GRAND_TOTAL_PERIODE add column signature VARCHAR(2000) DEFAULT  NULL;
Alter table GRAND_TOTAL_PERIODE add column timestampGDH timestamp;
Alter table ingredient_ticket add column index_carte INTEGER NOT NULL DEFAULT 1;
Alter table Option_ticket add column index_carte INTEGER NOT NULL DEFAULT 1;
Alter table Product_ticket add column index_carte INTEGER NOT NULL DEFAULT 1;
Alter table TICKETLINES add column label_discount VARCHAR(255) DEFAULT NULL;
CREATE TABLE LOG_PANIER (
  id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
  user_delete VARCHAR(256) NOT NULL,
  numero_order INTEGER,
  multiply DOUBLE, 
  price DOUBLE,
  nameProduct VARCHAR(256) DEFAULT NULL,
  date_delete TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT log_PK PRIMARY KEY (ID),
  CONSTRAINT log_user_FK FOREIGN KEY (user_delete) REFERENCES PEOPLE(ID)
);
ALTER TABLE supplement ADD COLUMN path varchar(255) DEFAULT NULL;
ALTER TABLE supplement ADD COLUMN order_name SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE item_supplements ADD COLUMN free_able SMALLINT DEFAULT 1 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN option_free INTEGER DEFAULT 0;
ALTER TABLE Option_ticket ADD COLUMN number_free INTEGER NOT NULL DEFAULT 0;
ALTER TABLE supplement_item ADD COLUMN many_size SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN special_option SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN number_line INTEGER NOT NULL DEFAULT 0;
ALTER TABLE PRODUCTS ADD COLUMN number_column INTEGER NOT NULL DEFAULT 0;
ALTER TABLE PRODUCTS ADD COLUMN max_line INTEGER NOT NULL DEFAULT 0;
ALTER TABLE caisse ADD COLUMN user_keenio_id VARCHAR(100) DEFAULT NULL;
ALTER TABLE TICKETS ADD COLUMN is_sync_keenio SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE TICKETS ADD COLUMN detach_sync_keenio SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE LOG_PANIER ADD COLUMN discount DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE LOG_PANIER ADD COLUMN label_discount VARCHAR(255) DEFAULT NULL;
CREATE TABLE ARCHIV_PERIODE(
    id VARCHAR(256) NOT NULL,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    signature VARCHAR(2000) DEFAULT  NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    timestampGDH timestamp,
    chemin  VARCHAR(256) Default NULL,
    type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    PRIMARY KEY (id)
);
CREATE TABLE Maintenance_Operation(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    operation_Name VARCHAR(256) DEFAULT  NULL,
    date_Start timestamp,
    date_end timestamp,
    finiched SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id)
);
ALTER TABLE TICKETS ADD COLUMN canceled_ticket_id VARCHAR(256) Default null;
ALTER TABLE TICKETS ADD COLUMN canceled_ticket_id_Int  INTEGER  default NULL;
delete from grand_total_periode;  
DROP TABLE ENTETE;
CREATE TABLE ENTETE (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    version_soft VARCHAR(256) DEFAULT '2.5' NOT NULL,
    nb_print INTEGER default 0,
    company VARCHAR(256) DEFAULT  NULL,
    address VARCHAR(256) DEFAULT  NULL,
    zip_code VARCHAR(256) DEFAULT  NULL,
    city VARCHAR(256) DEFAULT  NULL,
    country VARCHAR(256) DEFAULT  NULL,
    siret VARCHAR(256) DEFAULT  NULL,
    code_NAF VARCHAR(256) DEFAULT  NULL,
    num_tva VARCHAR(256) DEFAULT  NULL,
    code_operator VARCHAR(256) DEFAULT  NULL,
    name_operator VARCHAR(256) DEFAULT  NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    nb_customer INTEGER DEFAULT 1  NOT NULL,
    timestampGDH timestamp,
    type_operation VARCHAR(256) DEFAULT 'commande' NOT NULL,
    type_doc VARCHAR(256) DEFAULT 'ticket' NOT NULL,
    nb_lines INTEGER,
    ticket VARCHAR(256) NOT NULL,
    header_Supplementaire VARCHAR(256) ,
    footer_Supplementaire VARCHAR(256) ,
    ticket_status VARCHAR(256) Default 'normal' ,
    signature_Ticket VARCHAR(2000) default null,
    PRIMARY KEY (id),
    CONSTRAINT ENTETE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE LINES;
CREATE TABLE LINES(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    code_product VARCHAR(256),
    origin_data VARCHAR(256) DEFAULT 'IN' NOT NULL,
    descriptive_product VARCHAR(256),
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION ,
    price_HT DOUBLE PRECISION,
    price_TTC  DOUBLE PRECISION,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    type_operation VARCHAR(256) DEFAULT 'Vente' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT 'N/A' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    quantite DOUBLE PRECISION,
    discount  DOUBLE PRECISION,
    taux_discount DOUBLE PRECISION,
    PRIMARY KEY (id),
    CONSTRAINT LINE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_TAX;
CREATE TABLE TOTAL_TAX(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    total_ht DOUBLE PRECISION,
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION,
    total_tax DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TAX_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_ENCAISSEMENT;
CREATE TABLE TOTAL_ENCAISSEMENT(
  id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER DEFAULT 0,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TOTAL_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TICKET_PAYMENT;
CREATE TABLE TICKET_PAYMENT(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    type_regulation VARCHAR(256) DEFAULT 'ESPECE' NOT NULL,
    code_regulation VARCHAR(256) DEFAULT  NULL,
    mode_regulation VARCHAR(256) DEFAULT NULL,
    total DOUBLE PRECISION,
    quantity DOUBLE PRECISION DEFAULT 1 NOT NULL,
    type_operation VARCHAR(256) DEFAULT 'encaissement' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT '1' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT PAYMENT_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
 ALTER TABLE duplicata drop column is_first ;
ALTER TABLE item_supplements ADD COLUMN separate SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE Option_ticket ADD COLUMN separate SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE supplement_item ADD COLUMN path varchar(255) DEFAULT NULL;
ALTER TABLE PRODUCTS ADD COLUMN additional_sale SMALLINT DEFAULT 0 NOT NULL;
CREATE TABLE PHOTO_PUB_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE PHOTO_HOME_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
ALTER TABLE PRODUCTS ADD COLUMN moment_product SMALLINT DEFAULT 0 NOT NULL;
CREATE TABLE SOFTWARE(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(256) DEFAULT  NULL,
    DATABASE_VERSION VARCHAR(256) DEFAULT  NULL,
    SOFTWARE_VERSION VARCHAR(256) DEFAULT  NULL,
    LAST_UPGRADE_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID)
);
ALTER TABLE FACTURE drop column first_signature ;
ALTER TABLE TICKETS drop column invoice ;
ALTER TABLE TICKETS add column invoice INTEGER  default NULL ;
delete from FACTURE;
ALTER TABLE TOTAL_TAX add column timestampGDH timestamp ;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};