--    uniCenta oPOS - Touch Friendly Point Of Sale
--    Copyright (C) 2009-2015 uniCenta
--    http://sourceforge.net/projects/unicentaopos
--
--    This file is part of uniCenta oPOS.
--
--    uniCenta oPOS is free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    uniCenta oPOS is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

-- Database upgrade script for DERBY
-- Openbravo v2.30.2 - uniCenta v3.00



CREATE TABLE PHOTO_DISPLAY (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
ALTER TABLE TICKETS ADD COLUMN transferred_date TIMESTAMP DEFAULT NULL;
ALTER TABLE TICKETS ADD COLUMN transferred SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE TICKETS ADD COLUMN olduser VARCHAR(256) DEFAULT NULL;
ALTER TABLE TICKETS ADD COLUMN operation_user VARCHAR(256) DEFAULT NULL;
INSERT INTO PERMISSIONS(ID, NAME) VALUES('4', 'Transferer commande');
ALTER TABLE supplement_item ADD COLUMN order_item INTEGER NOT NULL DEFAULT 0;
ALTER TABLE supplement ADD COLUMN order_supplement INTEGER NOT NULL DEFAULT 0;
ALTER TABLE Option_ticket ADD COLUMN numberoption  INTEGER NOT NULL DEFAULT 1;
ALTER TABLE supplement_item ADD COLUMN price2 DOUBLE PRECISION DEFAULT 0;
ALTER TABLE supplement_item ADD COLUMN price3 DOUBLE PRECISION DEFAULT 0;
ALTER TABLE TAXCATEGORIES ADD COLUMN RATE DOUBLE PRECISION DEFAULT 0 NOT NULL;
UPDATE TAXCATEGORIES SET NAME = '5.5%', RATE = 0.055 WHERE  ID = '000';
UPDATE TAXCATEGORIES SET RATE = 0.1 WHERE  ID = '001';
UPDATE TAXCATEGORIES SET RATE = 0.2 WHERE  ID = '002';
ALTER TABLE PRODUCTS ADD COLUMN TAXEMP VARCHAR(256) DEFAULT NULL;
ALTER TABLE PRODUCTS ADD COLUMN TAXLV VARCHAR(256) DEFAULT NULL;
ALTER TABLE PRODUCTS ADD CONSTRAINT PRODUCTS_TAXEMP_FK FOREIGN KEY (TAXEMP) REFERENCES TAXCATEGORIES (ID);
ALTER TABLE PRODUCTS ADD CONSTRAINT PRODUCTS_TAXLV_FK FOREIGN KEY (TAXLV) REFERENCES TAXCATEGORIES (ID);
ALTER TABLE TICKETLINES DROP CONSTRAINT TICKETLINES_FK_3;
ALTER TABLE TICKETLINES ADD CONSTRAINT TICKETLINES_FK_3 FOREIGN KEY (TAXID) REFERENCES TAXCATEGORIES(ID);
CREATE TABLE PRODUCT_DIVERS (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    PRODUCT VARCHAR(256) DEFAULT NULL,
    PRICE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TAXID VARCHAR(256) DEFAULT NULL,
    TICKET VARCHAR(256) NOT NULL,
    htAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    taxAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    UNITS DOUBLE PRECISION DEFAULT 1 NOT NULL,
    CONSTRAINT PRODUCTD_primary_key PRIMARY KEY (ID),
    CONSTRAINT PRODUCTD_FK_TAX FOREIGN KEY (TAXID) REFERENCES TAXCATEGORIES(ID) ON DELETE SET NULL,
    CONSTRAINT PRODUCTD_FK_TICKET FOREIGN KEY (TICKET) REFERENCES TICKETS(ID) ON DELETE CASCADE
);
CREATE TABLE HISTORIQUE_CAISSE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    dateOpen TIMESTAMP DEFAULT NULL,
    dateClose TIMESTAMP DEFAULT NULL,
    caisse INTEGER DEFAULT NULL,
    user_open VARCHAR(256) DEFAULT NULL,
    user_close VARCHAR(256) DEFAULT NULL,
    htAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    taxAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ttcAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    cumul_Total DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CONSTRAINT Historique_primary_key PRIMARY KEY (ID),
    CONSTRAINT Historique_FK_1 FOREIGN KEY (user_open) REFERENCES PEOPLE(ID),
    CONSTRAINT Historique_FK_2 FOREIGN KEY (user_close) REFERENCES PEOPLE(ID),
    CONSTRAINT Historique_caisse_FK FOREIGN KEY (caisse) REFERENCES caisse(ID)
);
ALTER TABLE caisse ADD COLUMN fond_close DOUBLE PRECISION DEFAULT 0;
CREATE TABLE ENTETE (
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    version_soft VARCHAR(256) DEFAULT '1.1' NOT NULL,
    nb_print INTEGER,
    company VARCHAR(256) DEFAULT 'societe 1' NOT NULL,
    address VARCHAR(256) DEFAULT '12 rue II' NOT NULL,
    zip_code VARCHAR(256) DEFAULT '7500' NOT NULL,
    city VARCHAR(256) DEFAULT 'paris' NOT NULL,
    country VARCHAR(256) DEFAULT 'France' NOT NULL,
    siret VARCHAR(256) DEFAULT '362 521 879' NOT NULL,
    code_NAF VARCHAR(256) DEFAULT '147852' NOT NULL,
    num_tva VARCHAR(256) DEFAULT '12' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '123' NOT NULL,
    name_operator VARCHAR(256) DEFAULT 'operateur' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '147' NOT NULL,
    nb_customer INTEGER DEFAULT 10  NOT NULL,
    timestampGDH timestamp,
    type_operation VARCHAR(256) DEFAULT 'commande' NOT NULL,
    type_doc VARCHAR(256) DEFAULT 'ticket' NOT NULL,
    nb_lines INTEGER,
    restitution_signature VARCHAR(256) DEFAULT 'signature' NOT NULL,
    first_signature VARCHAR(256) DEFAULT 'oui' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT ENTETE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE LINES(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER,
    code_product VARCHAR(256),
    origin_data VARCHAR(256) DEFAULT 'origindata' NOT NULL,
    descriptive_product VARCHAR(256),
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION,
    price_HT DOUBLE PRECISION,
    price_TTC  DOUBLE PRECISION,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    type_operation VARCHAR(256) DEFAULT 'commade' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT '147' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '123' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '123' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT LINE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE TOTAL_TAX(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER,
    total_ht DOUBLE PRECISION,
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION,
    total_tax DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TAX_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE TOTAL_ENCAISSEMENT(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER DEFAULT 0,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TOTAL_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE TICKET_PAYMENT(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    type_regulation VARCHAR(256) DEFAULT 'transfert' NOT NULL,
    code_regulation VARCHAR(256) DEFAULT '147852' NOT NULL,
    mode_regulation VARCHAR(256) DEFAULT '147852' NOT NULL,
    total DOUBLE PRECISION,
    quantity DOUBLE PRECISION DEFAULT 1 NOT NULL,
    type_operation VARCHAR(256) DEFAULT 'commande' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT '147' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '123' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '123' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT PAYMENT_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE DOCUMENT(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT DOC_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE FACTURE (
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    company VARCHAR(256) DEFAULT 'societe 1' NOT NULL,
    name_contact VARCHAR(256) DEFAULT NULL,
    address VARCHAR(256) DEFAULT '12 rue II' NOT NULL,
    zip_code VARCHAR(256) DEFAULT '7500' NOT NULL,
    city VARCHAR(256) DEFAULT 'paris' NOT NULL,
    country VARCHAR(256) DEFAULT NULL,
    siret VARCHAR(256) DEFAULT NULL,
    code_NAF VARCHAR(256) DEFAULT NULL,
    num_tva VARCHAR(256) DEFAULT NULL,
    first_signature VARCHAR(256) DEFAULT 'oui' NOT NULL,
    signature VARCHAR(2000) DEFAULT  NULL,
    ticket VARCHAR(256) NOT NULL,
    physical_person SMALLINT DEFAULT 1 NOT NULL,
    cancel SMALLINT DEFAULT 0 NOT NULL,
    nb_print INTEGER,
    date_created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    num_doc INTEGER ,
    CONSTRAINT FACTURE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID),
    CONSTRAINT FACTURE_FK_Doc FOREIGN KEY (num_doc) REFERENCES DOCUMENT(ID),
    PRIMARY KEY (id)
);
CREATE TABLE GRAND_TOTAL(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    total_ttc DOUBLE PRECISION,
    timestampGDH timestamp,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    first_signature VARCHAR(256) DEFAULT 'oui' NOT NULL,
    report_signature VARCHAR(256) DEFAULT 'signature' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    PRIMARY KEY (id),
    CONSTRAINT GRAND_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE GRAND_TOTAL_PERIODE(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    total_ttc DOUBLE PRECISION,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    first_signature VARCHAR(256) DEFAULT 'oui' NOT NULL,
    report_signature VARCHAR(256) DEFAULT 'signature' NOT NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    PRIMARY KEY (id)
);
ALTER TABLE PRODUCTS ADD COLUMN label SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE ROLES DROP COLUMN PERMISSIONS;
ALTER TABLE PEOPLE DROP COLUMN CARD;
ALTER TABLE PEOPLE DROP COLUMN VISIBLE;
ALTER TABLE PEOPLE DROP COLUMN IMAGE;
ALTER TABLE PEOPLE ADD COLUMN hidden SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PEOPLE ADD COLUMN disabled SMALLINT DEFAULT 0 NOT NULL;
UPDATE PEOPLE SET NAME = 'User Maintenance', APPPASSWORD = $pwd{} WHERE ID = '0';
UPDATE PEOPLE SET ROLE = '2' WHERE ROLE = '3';
UPDATE PEOPLE SET ROLE = '3' WHERE ROLE = '4';
DELETE FROM ROLES WHERE ID = '4';
UPDATE ROLES SET NAME = 'livreur' WHERE ID = '3';
UPDATE ROLES SET NAME = 'Maintenance' WHERE ID = '0';
UPDATE ROLES SET NAME = 'Caissier' WHERE ID = '2';
INSERT INTO TAXCATEGORIES(ID, NAME, RATE) VALUES ('003', '0%', 0);
ALTER TABLE PRINTER ADD COLUMN typePrinter varchar(255) DEFAULT NULL;
ALTER TABLE PRODUCTS ADD COLUMN printerLabel INTEGER DEFAULT NULL;
UPDATE PRINTER SET typePrinter = 'caisse' WHERE ID = 1;
UPDATE PRINTER SET typePrinter = 'kitchen' WHERE ID <> 1;
CREATE TABLE MARUQENF525(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    SIRET VARCHAR(256) DEFAULT NULL,
    TVAINTRA VARCHAR(256) DEFAULT NULL,
    CODENAF VARCHAR(256) DEFAULT NULL,
    COMPANY VARCHAR(256) DEFAULT NULL,
    ADDRESS1 VARCHAR(256) DEFAULT NULL,
    ADDRESS2 VARCHAR(256) DEFAULT NULL,
    ZIPCODE VARCHAR(256) DEFAULT NULL,
    CITY VARCHAR(256) DEFAULT NULL,
    COUNTRY VARCHAR(256) DEFAULT NULL,
    PRIMARY KEY (ID)
);
UPDATE ROLES SET NAME = 'role' WHERE ID = '4';
UPDATE ROLES SET NAME = 'livreur' WHERE ID = '3';
UPDATE PEOPLE SET ROLE = '3' WHERE ROLE = '4';
DELETE FROM ROLES WHERE ID = '4';
CREATE TABLE TicketResto(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    num VARCHAR(256) DEFAULT NULL,
    type INTEGER,
    amount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    validity_year INTEGER,
    date_created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id)
);
CREATE TABLE Journal(
   id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   code_event INTEGER DEFAULT NULL,
   descriptif VARCHAR(256),
   code_operator VARCHAR(256),
   type_data VARCHAR(256),
   date_created TIMESTAMP,
   informations VARCHAR(256) DEFAULT NULL,
   PRIMARY KEY (ID)
);
ALTER TABLE TICKETS ADD COLUMN closed SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE TICKETS ADD COLUMN invoice VARCHAR(256) DEFAULT NULL;
ALTER TABLE supplement ADD COLUMN is_bold SMALLINT DEFAULT 0 NOT NULL;
UPDATE supplement SET IS_BOLD = 0;
ALTER TABLE Option_ticket ADD COLUMN is_bold SMALLINT DEFAULT 0 NOT NULL;
UPDATE Option_ticket SET IS_BOLD = 0;
ALTER TABLE Option_ticket ADD COLUMN price DOUBLE PRECISION DEFAULT 0;
ALTER TABLE carte_item ADD COLUMN price DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE carte_menu ADD COLUMN number_carte INTEGER NOT NULL DEFAULT 1;
CREATE TABLE Product_ticket (
   id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
   idCarte  INTEGER NOT NULL,
   nameCarte  varchar(255) DEFAULT NULL,
   idProduct  INTEGER NOT NULL,
   nameProduct  varchar(255) DEFAULT NULL,
   idTicketLine  INTEGER NOT NULL,
   numberoproduct INTEGER NOT NULL DEFAULT 1,
   price DOUBLE PRECISION DEFAULT 0,
   CONSTRAINT product_ticket_PK PRIMARY KEY (ID),
   CONSTRAINT product_ticket_FK FOREIGN KEY (idTicketLine) REFERENCES TICKETLINES(ID) ON DELETE CASCADE
);
ALTER TABLE supplement ADD COLUMN color varchar(255) DEFAULT NULL;
ALTER TABLE supplement ADD COLUMN number_click INTEGER NOT NULL DEFAULT 1;
ALTER TABLE PRODUCTS ADD COLUMN bar SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN terasse SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN happy_hour SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_bar DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_terasse DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_happy DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_bar_junior DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_bar_senior DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_bar_mega DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_terasse_junior DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_terasse_senior DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_terasse_mega DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_happy_junior DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_happy_senior DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN price_happy_mega DOUBLE PRECISION DEFAULT 0 NOT NULL;
UPDATE PRODUCTS SET bar = 1, terasse = 1, happy_hour = 1;

CREATE TABLE Duplicata(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    id_Doc VARCHAR(256) DEFAULT NULL,
    impression_Number INTEGER,
    nbre_ligne INTEGER,
    type_doc VARCHAR(256),
    user_operator VARCHAR(256) DEFAULT NULL,
    date_impression TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    signature VARCHAR(2000),
    is_first SMALLINT DEFAULT 0 NOT NULL,
    num_doc INTEGER default 0 not null ,
    CONSTRAINT DUPLICAT_USER_FK_1 FOREIGN KEY (user_operator) REFERENCES PEOPLE(ID),
    CONSTRAINT DUPLICATA_FK_TICKET FOREIGN KEY (id_Doc) REFERENCES TICKETS(ID),
    PRIMARY KEY (id)
);
ALTER TABLE ENTETE ADD COLUMN header_Supplementaire VARCHAR(256) ;
ALTER TABLE ENTETE ADD COLUMN footer_Supplementaire VARCHAR(256) ;
ALTER TABLE ENTETE ADD COLUMN ticket_status VARCHAR(256) Default 'normal' ;
ALTER TABLE ENTETE ADD COLUMN signature_Ticket VARCHAR(256) Default null;
ALTER TABLE LINES ADD COLUMN  quantite DOUBLE PRECISION Default 0 ;
ALTER TABLE LINES ADD COLUMN    discount  DOUBLE PRECISION Default 0 ;
ALTER TABLE LINES ADD COLUMN   taux_discount DOUBLE PRECISION Default 0 ;

ALTER TABLE ENTETE DROP COLUMN signature_Ticket ;
ALTER TABLE ENTETE ADD COLUMN signature_Ticket VARCHAR(2000) Default null;

Alter table GRAND_TOTAL_PERIODE drop column total_ttc;
Alter table GRAND_TOTAL_PERIODE add column type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL;
Alter table GRAND_TOTAL drop column first_signature ;
Alter table GRAND_TOTAL drop column report_signature ;
Alter table GRAND_TOTAL_PERIODE drop column first_signature ;
Alter table GRAND_TOTAL_PERIODE drop column report_signature ;

Alter table GRAND_TOTAL add column signature VARCHAR(2000) DEFAULT  NULL;
Alter table GRAND_TOTAL_PERIODE add column signature VARCHAR(2000) DEFAULT  NULL;
Alter table GRAND_TOTAL_PERIODE add column timestampGDH timestamp;
Alter table ingredient_ticket add column index_carte INTEGER NOT NULL DEFAULT 1;
Alter table Option_ticket add column index_carte INTEGER NOT NULL DEFAULT 1;
Alter table Product_ticket add column index_carte INTEGER NOT NULL DEFAULT 1;
Alter table TICKETLINES add column label_discount VARCHAR(255) DEFAULT NULL;
CREATE TABLE LOG_PANIER (
  id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
  user_delete VARCHAR(256) NOT NULL,
  numero_order INTEGER,
  multiply DOUBLE, 
  price DOUBLE,
  nameProduct VARCHAR(256) DEFAULT NULL,
  date_delete TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT log_PK PRIMARY KEY (ID),
  CONSTRAINT log_user_FK FOREIGN KEY (user_delete) REFERENCES PEOPLE(ID)
);
ALTER TABLE supplement ADD COLUMN path varchar(255) DEFAULT NULL;
ALTER TABLE supplement ADD COLUMN order_name SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE item_supplements ADD COLUMN free_able SMALLINT DEFAULT 1 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN option_free INTEGER DEFAULT 0;
ALTER TABLE Option_ticket ADD COLUMN number_free INTEGER NOT NULL DEFAULT 0;
ALTER TABLE supplement_item ADD COLUMN many_size SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN special_option SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN number_line INTEGER NOT NULL DEFAULT 0;
ALTER TABLE PRODUCTS ADD COLUMN number_column INTEGER NOT NULL DEFAULT 0;
ALTER TABLE PRODUCTS ADD COLUMN max_line INTEGER NOT NULL DEFAULT 0;
ALTER TABLE caisse ADD COLUMN user_keenio_id VARCHAR(100) DEFAULT NULL;
ALTER TABLE TICKETS ADD COLUMN is_sync_keenio SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE TICKETS ADD COLUMN detach_sync_keenio SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE LOG_PANIER ADD COLUMN discount DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE LOG_PANIER ADD COLUMN label_discount VARCHAR(255) DEFAULT NULL;
CREATE TABLE ARCHIV_PERIODE(
    id VARCHAR(256) NOT NULL,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    signature VARCHAR(2000) DEFAULT  NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    timestampGDH timestamp,
    chemin  VARCHAR(256) Default NULL,
    type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    PRIMARY KEY (id)
);
CREATE TABLE Maintenance_Operation(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    operation_Name VARCHAR(256) DEFAULT  NULL,
    date_Start timestamp,
    date_end timestamp,
    finiched SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id)
);
ALTER TABLE TICKETS ADD COLUMN canceled_ticket_id VARCHAR(256) Default null;
ALTER TABLE TICKETS ADD COLUMN canceled_ticket_id_Int  INTEGER  default NULL;
delete from grand_total_periode;  
DROP TABLE ENTETE;
CREATE TABLE ENTETE (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    version_soft VARCHAR(256) DEFAULT '2.5' NOT NULL,
    nb_print INTEGER default 0,
    company VARCHAR(256) DEFAULT  NULL,
    address VARCHAR(256) DEFAULT  NULL,
    zip_code VARCHAR(256) DEFAULT  NULL,
    city VARCHAR(256) DEFAULT  NULL,
    country VARCHAR(256) DEFAULT  NULL,
    siret VARCHAR(256) DEFAULT  NULL,
    code_NAF VARCHAR(256) DEFAULT  NULL,
    num_tva VARCHAR(256) DEFAULT  NULL,
    code_operator VARCHAR(256) DEFAULT  NULL,
    name_operator VARCHAR(256) DEFAULT  NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    nb_customer INTEGER DEFAULT 1  NOT NULL,
    timestampGDH timestamp,
    type_operation VARCHAR(256) DEFAULT 'commande' NOT NULL,
    type_doc VARCHAR(256) DEFAULT 'ticket' NOT NULL,
    nb_lines INTEGER,
    ticket VARCHAR(256) NOT NULL,
    header_Supplementaire VARCHAR(256) ,
    footer_Supplementaire VARCHAR(256) ,
    ticket_status VARCHAR(256) Default 'normal' ,
    signature_Ticket VARCHAR(2000) default null,
    PRIMARY KEY (id),
    CONSTRAINT ENTETE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE LINES;
CREATE TABLE LINES(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    code_product VARCHAR(256),
    origin_data VARCHAR(256) DEFAULT 'IN' NOT NULL,
    descriptive_product VARCHAR(256),
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION ,
    price_HT DOUBLE PRECISION,
    price_TTC  DOUBLE PRECISION,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    type_operation VARCHAR(256) DEFAULT 'Vente' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT 'N/A' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    quantite DOUBLE PRECISION,
    discount  DOUBLE PRECISION,
    taux_discount DOUBLE PRECISION,
    PRIMARY KEY (id),
    CONSTRAINT LINE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_TAX;
CREATE TABLE TOTAL_TAX(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    total_ht DOUBLE PRECISION,
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION,
    total_tax DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TAX_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_ENCAISSEMENT;
CREATE TABLE TOTAL_ENCAISSEMENT(
  id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER DEFAULT 0,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TOTAL_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TICKET_PAYMENT;
CREATE TABLE TICKET_PAYMENT(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    type_regulation VARCHAR(256) DEFAULT 'ESPECE' NOT NULL,
    code_regulation VARCHAR(256) DEFAULT  NULL,
    mode_regulation VARCHAR(256) DEFAULT NULL,
    total DOUBLE PRECISION,
    quantity DOUBLE PRECISION DEFAULT 1 NOT NULL,
    type_operation VARCHAR(256) DEFAULT 'encaissement' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT '1' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT PAYMENT_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
ALTER TABLE duplicata drop column is_first ;
ALTER TABLE item_supplements ADD COLUMN separate SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE Option_ticket ADD COLUMN separate SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE supplement_item ADD COLUMN path varchar(255) DEFAULT NULL;
ALTER TABLE PRODUCTS ADD COLUMN additional_sale SMALLINT DEFAULT 0 NOT NULL;
CREATE TABLE PHOTO_PUB_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE PHOTO_HOME_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    PRIMARY KEY (ID)
);
ALTER TABLE PRODUCTS ADD COLUMN moment_product SMALLINT DEFAULT 0 NOT NULL;
CREATE TABLE SOFTWARE(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(256) DEFAULT  NULL,
    DATABASE_VERSION VARCHAR(256) DEFAULT  NULL,
    SOFTWARE_VERSION VARCHAR(256) DEFAULT  NULL,
    LAST_UPGRADE_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID)
);
ALTER TABLE FACTURE drop column first_signature ;
ALTER TABLE TICKETS drop column invoice ;
ALTER TABLE TICKETS add column invoice INTEGER  default NULL ;
delete from FACTURE;
ALTER TABLE TOTAL_TAX add column timestampGDH timestamp ;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};
