--    uniCenta oPOS - Touch Friendly Point Of Sale
--    Copyright (C) 2009-2015 uniCenta
--    http://www.unicenta.net
--
--    This file is part of uniCenta oPOS.
--
--    uniCenta oPOS is free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    uniCenta oPOS is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

-- Database upgrade script for Derby
-- v3.91.2 - v3.91.3

-- UPDATE App' version
CREATE TABLE ARCHIV_PERIODE(
    id VARCHAR(256) NOT NULL,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    signature VARCHAR(2000) DEFAULT  NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    timestampGDH timestamp,
    chemin  VARCHAR(256) Default NULL,
    type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    PRIMARY KEY (id)
);
CREATE TABLE Maintenance_Operation(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    operation_Name VARCHAR(256) DEFAULT  NULL,
    date_Start timestamp,
    date_end timestamp,
    finiched SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id)
);
ALTER TABLE TICKETS ADD COLUMN canceled_ticket_id VARCHAR(256) Default null;
ALTER TABLE TICKETS ADD COLUMN canceled_ticket_id_Int  INTEGER  default NULL;
delete from grand_total_periode;  
ALTER TABLE ENTETE ADD COLUMN   id_entete INTEGER GENERATED BY DEFAULT AS IDENTITY ;
ALTER TABLE ENTETE drop column restitution_signature ;
ALTER TABLE ENTETE drop column first_signature ;
DROP TABLE LINES;
CREATE TABLE LINES(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    code_product VARCHAR(256),
    origin_data VARCHAR(256) DEFAULT 'IN' NOT NULL,
    descriptive_product VARCHAR(256),
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION ,
    price_HT DOUBLE PRECISION,
    price_TTC  DOUBLE PRECISION,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    type_operation VARCHAR(256) DEFAULT 'Vente' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT 'N/A' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    quantite DOUBLE PRECISION,
    discount  DOUBLE PRECISION,
    taux_discount DOUBLE PRECISION,
    PRIMARY KEY (id),
    CONSTRAINT LINE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_TAX;
CREATE TABLE TOTAL_TAX(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    total_ht DOUBLE PRECISION,
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION,
    total_tax DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TAX_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TOTAL_ENCAISSEMENT;
CREATE TABLE TOTAL_ENCAISSEMENT(
  id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER DEFAULT 0,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TOTAL_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
DROP TABLE TICKET_PAYMENT;
CREATE TABLE TICKET_PAYMENT(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    type_regulation VARCHAR(256) DEFAULT 'ESPECE' NOT NULL,
    code_regulation VARCHAR(256) DEFAULT  NULL,
    mode_regulation VARCHAR(256) DEFAULT NULL,
    total DOUBLE PRECISION,
    quantity DOUBLE PRECISION DEFAULT 1 NOT NULL,
    type_operation VARCHAR(256) DEFAULT 'encaissement' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT '1' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT PAYMENT_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
 ALTER TABLE duplicata drop column is_first ;
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};
