--    uniCenta oPOS - Touch Friendly Point Of Sale
--    Copyright (C) 2009-2015 uniCenta
--    http://sourceforge.net/projects/unicentaopos
--
--    This file is part of uniCenta oPOS.
--
--    uniCenta oPOS is free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    uniCenta oPOS is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

-- Database upgrade script for DERBY
-- Openbravo v2.30.2 - uniCenta v3.00
CREATE TABLE caisse (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    FOND_CAISSE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    token VARCHAR(255) DEFAULT NULL,
    OUVERTE SMALLINT DEFAULT 0 NOT NULL,
    dateOpen TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    dateClose TIMESTAMP DEFAULT NULL,
    user_open VARCHAR(256) DEFAULT NULL,
    user_close VARCHAR(256) DEFAULT NULL,
    CONSTRAINT caisse_primary_key PRIMARY KEY (ID),
    CONSTRAINT CAISSE_FK_1 FOREIGN KEY (user_open) REFERENCES PEOPLE(ID),
    CONSTRAINT CAISSE_FK_2 FOREIGN KEY (user_close) REFERENCES PEOPLE(ID)
);
ALTER TABLE TICKETS ADD COLUMN caisse INTEGER DEFAULT NULL;
ALTER TABLE TICKETS ADD CONSTRAINT TICKETS_ibfk_4 FOREIGN KEY (caisse) REFERENCES caisse (ID) ON DELETE CASCADE;
ALTER TABLE PRODUCTS DROP COLUMN many_price;
ALTER TABLE PRODUCTS ADD COLUMN many_size SMALLINT DEFAULT 0 NOT NULL;
ALTER TABLE PRODUCTS ADD COLUMN different_price SMALLINT DEFAULT 0 NOT NULL;
DROP INDEX PRODUCTS_INX_1;
ALTER TABLE PRODUCTS ALTER COLUMN CODE NULL;
UPDATE ROLES SET PERMISSIONS = $FILE{/com/openbravo/pos/templates/Role.Administrator.xml} WHERE ID = '0';
UPDATE ROLES SET PERMISSIONS =  $FILE{/com/openbravo/pos/templates/Role.Manager.xml} WHERE ID = '1';
UPDATE ROLES SET PERMISSIONS = $FILE{/com/openbravo/pos/templates/Role.Employee.xml} WHERE ID = '2';
ALTER TABLE adresseClient ADD autoCompletion VARCHAR(255) DEFAULT NULL ;
ALTER TABLE TICKETLINES ADD COLUMN htAmount DOUBLE PRECISION DEFAULT 0 NOT NULL;
ALTER TABLE TICKETLINES ADD COLUMN taxAmount DOUBLE PRECISION DEFAULT 0 NOT NULL;
UPDATE TAXES SET NAME = '0%' WHERE ID = '000';
UPDATE TAXES SET NAME = '10%' WHERE ID = '001';
UPDATE TAXES SET NAME = '20%' WHERE ID = '002';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Ticket.Line.xml} WHERE ID = '57';
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};