--    uniCenta oPOS - Touch Friendly Point Of Sale
--    Copyright (C) 2009-2015 uniCenta
--    http://www.unicenta.net
--
--    This file is part of uniCenta oPOS.
--
--    uniCenta oPOS is free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    uniCenta oPOS is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

-- Database upgrade script for DERBY
-- v3.50 - v3.55
--

--
-- UPDATE existing tables
--
UPDATE ROLES SET PERMISSIONS = $FILE{/com/openbravo/pos/templates/Role.Administrator.xml} WHERE ID = '0';

UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Menu.Root.txt} WHERE ID = '0';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Printer.CloseCash.xml} WHERE ID = '25';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Printer.CustomerPaid.XML} WHERE ID = '26';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Printer.CustomerPaid2.xml} WHERE ID = '27';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Printer.PartialCash.xml} WHERE ID = '31';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Printer.Ticket.xml} WHERE ID = '33';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Printer.Ticket2.xml} WHERE ID = '34';
UPDATE RESOURCES SET CONTENT = $FILE{/com/openbravo/pos/templates/Printer.TicketPreview.xml} WHERE ID = '37';

--
-- ALTER existing tables
--
ALTER TABLE CSVIMPORT ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE CSVIMPORT SET TMPCOLUMN=PRICEBUY;
ALTER TABLE CSVIMPORT DROP COLUMN PRICEBUY;
RENAME COLUMN CSVIMPORT.TMPCOLUMN TO PRICEBUY;

ALTER TABLE CSVIMPORT ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE CSVIMPORT SET TMPCOLUMN=PRICESELL;
ALTER TABLE CSVIMPORT DROP COLUMN PRICESELL;
RENAME COLUMN CSVIMPORT.TMPCOLUMN TO PRICESELL;

ALTER TABLE CSVIMPORT ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE CSVIMPORT SET TMPCOLUMN=PREVIOUSBUY;
ALTER TABLE CSVIMPORT DROP COLUMN PREVIOUSBUY;
RENAME COLUMN CSVIMPORT.TMPCOLUMN TO PREVIOUSBUY;

ALTER TABLE CSVIMPORT ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE CSVIMPORT SET TMPCOLUMN=PREVIOUSSELL;
ALTER TABLE CSVIMPORT DROP COLUMN PREVIOUSSELL;
RENAME COLUMN CSVIMPORT.TMPCOLUMN TO PREVIOUSSELL;

ALTER TABLE PAYMENTS ADD COLUMN CARDNAME VARCHAR(256);

ALTER TABLE PAYMENTS ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE PAYMENTS SET TMPCOLUMN=TENDERED;
ALTER TABLE PAYMENTS DROP COLUMN TENDERED;
RENAME COLUMN PAYMENTS.TMPCOLUMN TO TENDERED;

UPDATE PAYMENTS SET TENDERED = TOTAL WHERE TENDERED = 0;

ALTER TABLE PRODUCTS ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE PRODUCTS SET TMPCOLUMN=STOCKCOST;
ALTER TABLE PRODUCTS DROP COLUMN STOCKCOST;
RENAME COLUMN PRODUCTS.TMPCOLUMN TO STOCKCOST;

ALTER TABLE PRODUCTS ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE PRODUCTS SET TMPCOLUMN=STOCKVOLUME;
ALTER TABLE PRODUCTS DROP COLUMN STOCKVOLUME;
RENAME COLUMN PRODUCTS.TMPCOLUMN TO STOCKVOLUME;

ALTER TABLE STOCKCURRENT ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE STOCKCURRENT SET TMPCOLUMN=UNITS;
ALTER TABLE STOCKCURRENT DROP COLUMN UNITS;
RENAME COLUMN STOCKCURRENT.TMPCOLUMN TO UNITS;

ALTER TABLE STOCKDIARY ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE STOCKDIARY SET TMPCOLUMN=UNITS;
ALTER TABLE STOCKDIARY DROP COLUMN UNITS;
RENAME COLUMN STOCKDIARY.TMPCOLUMN TO UNITS;

ALTER TABLE STOCKDIARY ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE STOCKDIARY SET TMPCOLUMN=PRICE;
ALTER TABLE STOCKDIARY DROP COLUMN PRICE;
RENAME COLUMN STOCKDIARY.TMPCOLUMN TO PRICE;

ALTER TABLE STOCKLEVEL ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE STOCKLEVEL SET TMPCOLUMN=STOCKSECURITY;
ALTER TABLE STOCKLEVEL DROP COLUMN STOCKSECURITY;
RENAME COLUMN STOCKLEVEL.TMPCOLUMN TO STOCKSECURITY;

ALTER TABLE STOCKLEVEL ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE STOCKLEVEL SET TMPCOLUMN=STOCKMAXIMUM;
ALTER TABLE STOCKLEVEL DROP COLUMN STOCKMAXIMUM;
RENAME COLUMN STOCKLEVEL.TMPCOLUMN TO STOCKMAXIMUM;

ALTER TABLE TICKETLINES ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE TICKETLINES SET TMPCOLUMN=UNITS;
ALTER TABLE TICKETLINES DROP COLUMN UNITS;
RENAME COLUMN TICKETLINES.TMPCOLUMN TO UNITS;

ALTER TABLE TICKETLINES ADD COLUMN TMPCOLUMN DOUBLE PRECISION DEFAULT NULL;
UPDATE TICKETLINES SET TMPCOLUMN=PRICE;
ALTER TABLE TICKETLINES DROP COLUMN PRICE;
RENAME COLUMN TICKETLINES.TMPCOLUMN TO PRICE;

-- UPDATE App' version
UPDATE APPLICATIONS SET NAME = $APP_NAME{}, VERSION = $APP_VERSION{} WHERE ID = $APP_ID{};

-- final script
DELETE FROM SHAREDTICKETS;
