--    uniCenta oPOS - Touch Friendly Point Of Sale
--    Copyright (C) 2009-2015 uniCenta
--    http://sourceforge.net/projects/unicentaopos
--
--    This file is part of uniCenta oPOS.
--
--    uniCenta oPOS is free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either L.sizeproduct,version 3 of the License, or
--    (at your option) any later version.
--
--    uniCenta oPOS is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have receiveunitd a copy of the GNU General Public License
--    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

-- Database create script for DERBY
-- v3.91

 

CREATE TABLE APPLICATIONS (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    VERSION VARCHAR(1024) NOT NULL,
    PRIMARY KEY (ID)
);

CREATE TABLE ROLES (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ROLES_NAME_INX ON ROLES(NAME);
INSERT INTO ROLES(ID, NAME) VALUES('0', 'Maintenance');
INSERT INTO ROLES(ID, NAME) VALUES('1', 'Manager');
INSERT INTO ROLES(ID, NAME) VALUES('2', 'Caissier');
INSERT INTO ROLES(ID, NAME) VALUES('3', 'livreur');

CREATE TABLE PERMISSIONS (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    PRIMARY KEY (ID)
);
INSERT INTO PERMISSIONS(ID, NAME) VALUES('0', 'Ouverture terroir caisse');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('1', 'Deverrouillage caisse');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('2', 'Ajouter promotion');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('3', 'Annulation commande');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('4', 'Transferer commande');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('5', 'Recevoir les statistique par email');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('6', 'Ajouter Produit Divers');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('7', 'Verrouillage caisse');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('8', 'Accée aux fonctions du Monnayeur');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('9', 'Accée aux fonctions avancées du Monnayeur');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('10', 'Encaisser commande');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('11', 'Rappel Ticket');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('12', 'Ajouter des options gratuites');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('13', 'Voir le fond caisse');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('14', 'Supprimer les lignes de commandes');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('15', 'Imprimer Ticket caisse');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('16', 'Imprimer Ticket cuisine');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('17', 'Imprimer Justificatif paiement');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('18', 'Dupliquer commande');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('19', 'Imprimer Etiquette');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('20', 'X Global');
INSERT INTO PERMISSIONS(ID, NAME) VALUES ('21', 'Gestion de stock');
INSERT INTO PERMISSIONS(ID, NAME) VALUES('22', 'BackOffice Cashlogy');
CREATE TABLE PEOPLE (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    EMAIL VARCHAR(256) DEFAULT NULL,
    APPPASSWORD VARCHAR(1024),
    ROLE VARCHAR(256) NOT NULL,
    hidden SMALLINT DEFAULT 0 NOT NULL,
    removed SMALLINT DEFAULT 0 NOT NULL,
    disabled SMALLINT DEFAULT 0 NOT NULL,
    removedAt TIMESTAMP DEFAULT NULL,
    fingerprint VARCHAR(255) DEFAULT NULL,
    REF_SYNCHRO VARCHAR(256) DEFAULT NULL,
    TEMPORAYPSWD  VARCHAR(1024) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PEOPLE_FK_1 FOREIGN KEY (ROLE) REFERENCES ROLES(ID)
);
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE) VALUES ('0', 'User Maintenance', $pwd{}, '0');
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE) VALUES ('1', 'Manager', $pwdManager{}, '1');
INSERT INTO PEOPLE(ID, NAME, APPPASSWORD, ROLE) VALUES ('2', 'caissier', $pwdCaissier{}, '2');
CREATE TABLE USER_PERMISSION(
   idUser VARCHAR(256) NOT NULL,
   idPermission VARCHAR(256) NOT NULL,
   PRIMARY KEY (idUser, idPermission),
   CONSTRAINT USER_FK_1 FOREIGN KEY (idUser) REFERENCES PEOPLE(ID) ON DELETE CASCADE,
   CONSTRAINT PERMISSIONS_FK_2 FOREIGN KEY (idPermission) REFERENCES PERMISSIONS(ID) ON DELETE CASCADE
);
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '0');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '1');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '2');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '3');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '4');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '6');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '7');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '10');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '11');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '12');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '13');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '14');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '15');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '16');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '17');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '18');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '19');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '20');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '21');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '0');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '1');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '2');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '3');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '4');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '6');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '7');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '10');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '11');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '12');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '13');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '14');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '15');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '16');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '17');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '18');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '19');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('1', '20');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '1');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '7');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '14');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '15');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '16');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '17');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '18');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('2', '19');
INSERT INTO USER_PERMISSION(IDUSER, IDPERMISSION) VALUES ('1', '21');
INSERT INTO USER_PERMISSION(idUser, idPermission) VALUES ('0', '22');
CREATE TABLE RESOURCES (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    RESTYPE INTEGER NOT NULL,
    CONTENT BLOB,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX RESOURCES_NAME_INX ON RESOURCES(NAME);

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('0', 'Menu.Root', 0, $FILE{/com/openbravo/pos/templates/Menu.Root.txt});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('1', 'coin.2', 1, $FILE{/com/openbravo/pos/templates/coin.2.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('2', 'coin.1', 1, $FILE{/com/openbravo/pos/templates/coin.1.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('3', 'coin.50', 1, $FILE{/com/openbravo/pos/templates/coin.50.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('4', 'note.200', 1, $FILE{/com/openbravo/pos/templates/note.200.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('5', 'coin.10', 1, $FILE{/com/openbravo/pos/templates/coin.10.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('6', 'coin.05', 1, $FILE{/com/openbravo/pos/templates/coin.05.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('7', 'coin.02', 1, $FILE{/com/openbravo/pos/templates/coin.02.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('8', 'coin.01', 1, $FILE{/com/openbravo/pos/templates/coin.01.png});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('9', 'img.cash', 1, $FILE{/com/openbravo/pos/templates/img.cash.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('10', 'img.cashdrawer', 1, $FILE{/com/openbravo/pos/templates/img.cashdrawer.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('11', 'img.discount', 1, $FILE{/com/openbravo/pos/templates/img.discount.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('12', 'img.empty', 1, $FILE{/com/openbravo/pos/templates/img.empty.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('13', 'img.heart', 1, $FILE{/com/openbravo/pos/templates/img.heart.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('14', 'img.no_photo', 1, $FILE{/com/openbravo/pos/templates/img.no_photo.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('15', 'img.kit_print', 1, $FILE{/com/openbravo/pos/templates/img.kit_print.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('16', 'img.refundit', 1, $FILE{/com/openbravo/pos/templates/img.refundit.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('17', 'img.run_script', 1, $FILE{/com/openbravo/pos/templates/img.run_script.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('18', 'img.ticket_print', 1, $FILE{/com/openbravo/pos/templates/img.ticket_print.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('19', 'img.user', 1, $FILE{/com/openbravo/pos/templates/img.user.png});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('20', 'note.50', 1, $FILE{/com/openbravo/pos/templates/note.50.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('21', 'note.20', 1, $FILE{/com/openbravo/pos/templates/note.20.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('22', 'note.100', 1, $FILE{/com/openbravo/pos/templates/note.100.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('23', 'note.25', 1, $FILE{/com/openbravo/pos/templates/note.25.png});


INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('24', 'payment.cash', 0, $FILE{/com/openbravo/pos/templates/payment.cash.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('25', 'Printer.CloseCash', 0, $FILE{/com/openbravo/pos/templates/Printer.CloseCash.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('26', 'Printer.CustomerPaid', 0, $FILE{/com/openbravo/pos/templates/Printer.CustomerPaid.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('27', 'Printer.CustomerPaid2', 0, $FILE{/com/openbravo/pos/templates/Printer.CustomerPaid2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('28', 'Printer.FiscalTicket', 0, $FILE{/com/openbravo/pos/templates/Printer.FiscalTicket.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('29', 'Printer.Inventory', 0, $FILE{/com/openbravo/pos/templates/Printer.Inventory.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('30', 'Printer.OpenDrawer', 0, $FILE{/com/openbravo/pos/templates/Printer.OpenDrawer.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('31', 'Printer.PartialCash', 0, $FILE{/com/openbravo/pos/templates/Printer.PartialCash.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('32', 'Printer.Product', 0, $FILE{/com/openbravo/pos/templates/Printer.Product.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('33', 'Printer.Start', 0, $FILE{/com/openbravo/pos/templates/Printer.Start.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('34', 'Printer.Ticket', 0, $FILE{/com/openbravo/pos/templates/Printer.Ticket.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('35', 'Printer.Ticket2', 0, $FILE{/com/openbravo/pos/templates/Printer.Ticket2.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('36', 'Printer.TicketClose', 0, $FILE{/com/openbravo/pos/templates/Printer.TicketClose.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('37', 'Printer.TicketKitchen', 0, $FILE{/com/openbravo/pos/templates/Printer.TicketKitchen.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('38', 'Printer.TicketLine', 0, $FILE{/com/openbravo/pos/templates/Printer.TicketLine.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('39', 'Printer.TicketNew', 0, $FILE{/com/openbravo/pos/templates/Printer.TicketLine.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('40', 'Printer.TicketPreview', 0, $FILE{/com/openbravo/pos/templates/Printer.TicketPreview.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('41', 'Printer.TicketTotal', 0, $FILE{/com/openbravo/pos/templates/Printer.TicketTotal.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('42', 'Printer.Ticket.Logo', 1, $FILE{/com/openbravo/pos/templates/printer.ticket.logo.png});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('43', 'script.AddLineNote', 0, $FILE{/com/openbravo/pos/templates/script.AddLineNote.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('44', 'script.Event.Total', 0, $FILE{/com/openbravo/pos/templates/script.Event.Total.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('45', 'script.linediscount', 0, $FILE{/com/openbravo/pos/templates/script.linediscount.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('46', 'script.ReceiptConsolidate', 0, $FILE{/com/openbravo/pos/templates/script.ReceiptConsolidate.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('47', 'script.Refundit', 0, $FILE{/com/openbravo/pos/templates/script.Refundit.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('48', 'script.SendOrder', 0, $FILE{/com/openbravo/pos/templates/script.SendOrder.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('49', 'script.ServiceCharge', 0, $FILE{/com/openbravo/pos/templates/script.script.ServiceCharge.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('50', 'script.SetPerson', 0, $FILE{/com/openbravo/pos/templates/script.SetPerson.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('51', 'script.StockCurrentAdd', 0, $FILE{/com/openbravo/pos/templates/script.StockCurrentAdd.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('52', 'script.StockCurrentSet', 0, $FILE{/com/openbravo/pos/templates/script.StockCurrentSet.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('53', 'script.totaldiscount', 0, $FILE{/com/openbravo/pos/templates/script.totaldiscount.txt});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('54', 'Ticket.Buttons', 0, $FILE{/com/openbravo/pos/templates/Ticket.Buttons.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('55', 'Ticket.Close', 0, $FILE{/com/openbravo/pos/templates/Ticket.Close.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('56', 'Ticket.Discount', 0, $FILE{/com/openbravo/pos/templates/Ticket.Discount.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('57', 'Ticket.Line', 0, $FILE{/com/openbravo/pos/templates/Ticket.Line.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('58', 'Ticket.TicketLineTaxesIncluded', 0, $FILE{/com/openbravo/pos/templates/Ticket.TicketLineTaxesIncluded.xml});

INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('59', 'Window.Logo', 1, $FILE{/com/openbravo/pos/templates/window.logo.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('60', 'Window.Title', 0, $FILE{/com/openbravo/pos/templates/Window.Title.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('61', 'script.posapps', 0, $FILE{/com/openbravo/pos/templates/script.posapps.txt});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('62', 'img.posapps', 1, $FILE{/com/openbravo/pos/templates/img.posapps.png});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('63', 'Printer.kitchen', 0, $FILE{/com/openbravo/pos/templates/Printer.kitchen.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('64', 'Printer.Livraison', 0, $FILE{/com/openbravo/pos/templates/Printer.Livraison.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('65', 'Printer.DayTurnover', 0, $FILE{/com/openbravo/pos/templates/Printer.DayTurnover.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('66', 'Printer.MonthTurnover', 0, $FILE{/com/openbravo/pos/templates/Printer.MonthTurnover.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('67', 'Printer.DayTurnoverDetail', 0, $FILE{/com/openbravo/pos/templates/Printer.DayTurnoverDetail.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('68', 'Printer.MonthTurnoverDetail', 0, $FILE{/com/openbravo/pos/templates/Printer.MonthTurnoverDetail.xml});
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('69', 'coin.5', 0, $FILE{/com/openbravo/pos/templates/coin.5.png});

CREATE TABLE TAXCUSTCATEGORIES (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX TAXCUSTCAT_NAME_INX ON TAXCUSTCATEGORIES(NAME);

CREATE TABLE CUSTOMERS (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TAXID VARCHAR(1024),
    NAME VARCHAR(1024) NOT NULL,
    PHONE varchar(255) DEFAULT NULL,
    PHONE2 varchar(20) DEFAULT NULL,
    TAXCATEGORY VARCHAR(256),
    CARD VARCHAR(1024),
    MAXDEBT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NOTES VARCHAR(1024),
    VISIBLE SMALLINT DEFAULT 1 NOT NULL,
    CURDATE TIMESTAMP,
    CURDEBT DOUBLE PRECISION DEFAULT 0,
    removed SMALLINT DEFAULT 0 NOT NULL,
    EMAIL varchar(255) DEFAULT NULL,
    COMPANY integer DEFAULT NULL,
    DISCOUNT double DEFAULT 0,
    RESPONSIBLE varchar(255) DEFAULT NULL,
    COMPANYNAME varchar(255) DEFAULT NULL,
    INTERLOCUTOR varchar(255) DEFAULT NULL,
    FUNCTION_INT varchar(255) DEFAULT NULL,
    RANGECOMPANY varchar(255) DEFAULT NULL,
    TYPE varchar(255) DEFAULT NULL,
    TURNOVER DOUBLE PRECISION DEFAULT 0,
    NB_ORDERS integer DEFAULT 0,
    LAST_ORDER TIMESTAMP default null,
    PREFIX_PHONE varchar(255) DEFAULT NULL,
    SIRET VARCHAR(256) DEFAULT NULL,
    CODE_NAF VARCHAR(256) DEFAULT NULL,
    NUM_TVA VARCHAR(256) DEFAULT NULL,
    ISSYNCHROCLIENT SMALLINT DEFAULT 0 NOT NULL,
    CONSTRAINT CUSTOMERS_primary_key PRIMARY KEY (ID),
    CONSTRAINT CUSTOMERS_TAXCAT FOREIGN KEY (TAXCATEGORY) REFERENCES TAXCUSTCATEGORIES(ID)
);
CREATE INDEX CUSTOMERS_TAXID_INX ON CUSTOMERS(TAXID);
CREATE INDEX CUSTOMERS_NAME_INX ON CUSTOMERS(NAME);
CREATE INDEX CUSTOMERS_CARD_INX ON CUSTOMERS(CARD);

CREATE TABLE adresseClient (
  id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
  address varchar(255) NOT NULL,
  zipCode varchar(255) NOT NULL,
  city varchar(255) NOT NULL,
  entryCode varchar(255) NOT NULL,
  interphone varchar(255) NOT NULL,
  batiment varchar(255) NOT NULL,
  escalier varchar(255) NOT NULL,
  etage varchar(255) NOT NULL,
  appartement varchar(255) NOT NULL,
  societe varchar(255) NOT NULL,
  REMARQUE VARCHAR(255) DEFAULT NULL,
  idCustomer INTEGER NOT NULL,
  lat DOUBLE PRECISION DEFAULT 0 NOT NULL,
  lon DOUBLE PRECISION DEFAULT 0 NOT NULL,
  ISSYNCHROADDRESS SMALLINT DEFAULT 0 NOT NULL,
  CONSTRAINT adresseClient_primary_key PRIMARY KEY (id),
  CONSTRAINT CUSTOMERS_Add FOREIGN KEY (idCustomer) REFERENCES CUSTOMERS(ID)
);

CREATE TABLE TAXCATEGORIES (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    RATE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    removed SMALLINT DEFAULT 0 NOT NULL,
    ENABLED SMALLINT DEFAULT 1 NOT NULL,
    TAXE_GLOBAL SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID)
);


CREATE TABLE CATEGORIES (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(1024) NOT NULL,
    PARENTID INTEGER,
    TEXTTIP VARCHAR(256) DEFAULT NULL,
    CATSHOWNAME SMALLINT DEFAULT 1 NOT NULL,
    order_category INTEGER DEFAULT NULL,
    type VARCHAR(256) DEFAULT 'principale' NOT NULL,
    removed SMALLINT DEFAULT 0 NOT NULL,
    hidden SMALLINT DEFAULT 0 NOT NULL,
    path varchar(255) DEFAULT NULL,
    color varchar(255) DEFAULT NULL,
    REF_WEB VARCHAR(255) DEFAULT NULL,
    TAXEMP VARCHAR(256) DEFAULT NULL,
    TAXLV VARCHAR(256) DEFAULT NULL,
    TAXSP VARCHAR(256) DEFAULT NULL,
    APPLY_DISCOUNT SMALLINT DEFAULT 0 NOT NULL,
    HIDDEN_BORNE SMALLINT DEFAULT 0 NOT NULL,
    HIDDEN_CAISSE SMALLINT DEFAULT 0 NOT NULL,
    MOMENT_CATEGORY SMALLINT DEFAULT 0 NOT NULL,
    REMOVED_BY_ADMIN SMALLINT DEFAULT 0 NOT NULL,
    RAW_MATERIAL SMALLINT DEFAULT 0 NOT NULL,
    PRINTER INTEGER DEFAULT 0 NOT NULL,
    PRINTER_LABEL INTEGER DEFAULT 0 NOT NULL,
    SOLD_OUT SMALLINT DEFAULT 0 NOT NULL,
    PRODUCTS_FIRST SMALLINT DEFAULT 0 NOT NULL,
    NEXT_AVAILABLE SMALLINT DEFAULT 0 NOT NULL,
    HAS_DISPLAY_TIME SMALLINT DEFAULT 0 NOT NULL,
    FIRST_PERIOD INTEGER NOT NULL DEFAULT 0,
    END_PERIOD INTEGER NOT NULL DEFAULT 0,
    AVAILABLE_CAISSE SMALLINT DEFAULT 0 NOT NULL,
    HIDDEN_UBEREAT SMALLINT DEFAULT 0 NOT NULL,
    HIDE_NAME_IN_BORNE SMALLINT DEFAULT 0 NOT NULL,
    HIDDEN_ONLINE SMALLINT DEFAULT 0 NOT NULL,
    CATEGORY_UBEREAT SMALLINT DEFAULT 0 NOT NULL,
    OFFSET_PRINT_KITCEHN  INTEGER NOT NULL DEFAULT 0,
    ID_GLOBAL varchar(255) DEFAULT NULL,
    PATH_CATEGORY_MOMENT VARCHAR(255) DEFAULT NULL,
    type_image_category_moment VARCHAR(255) DEFAULT NULL,
    HAS_TIMETABLE SMALLINT DEFAULT 0 NOT NULL,
    DATE_START_DISPLAY    TIMESTAMP default null,
    DATE_END_DISPLAY    TIMESTAMP default null,
    IMAGE_URL varchar(1024) DEFAULT NULL,
    CATEGORY_OF_DISCOUNT SMALLINT DEFAULT 0 NOT NULL,
    CONSTRAINT CATEGORIES_primary_key PRIMARY KEY (ID),
    CONSTRAINT CATEGORIES_TAXEMP_FK FOREIGN KEY (TAXEMP) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT CATEGORIES_TAXLV_FK FOREIGN KEY (TAXLV) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT CATEGORIES_TAXSP_FK FOREIGN KEY (TAXSP) REFERENCES TAXCATEGORIES(ID)
);



CREATE UNIQUE INDEX TAXCAT_NAME_INX ON TAXCATEGORIES(NAME);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('001', '5.5%', 0.055, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('002', '10%', 0.1, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('003', '20%', 0.2, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('004', '0%', 0, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('005', '7.7%', 0.077, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('006', '2.5%', 0.025, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('007', '2.1%', 0.021, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('008', '8.5%', 0.085, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('009', '6%', 0.06, 0);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('010', '12%', 0.12, 0);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('011', '21%', 0.21, 0);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('012', '8.1%', 0.081, 0);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED) VALUES ('013', '2.6%', 0.026, 0);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED, TAXE_GLOBAL) VALUES ('tps', 'TPS', 0.05, 0, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED, TAXE_GLOBAL) VALUES ('tvq', 'TVQ', 0.09975, 0, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED, TAXE_GLOBAL) VALUES ('hst', 'HST', 0.13, 0, 1);
INSERT INTO TAXCATEGORIES(ID, NAME, RATE, ENABLED, TAXE_GLOBAL) VALUES ('014', 'TAX', 0.095, 0, 1);


CREATE TABLE ATTRIBUTE (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    PRIMARY KEY (ID)
);

CREATE TABLE ATTRIBUTEVALUE (
    ID VARCHAR(256) NOT NULL,
    ATTRIBUTE_ID VARCHAR(256) NOT NULL,
    VALUE VARCHAR(1024),
    PRIMARY KEY (ID),
    CONSTRAINT ATTVAL_ATT FOREIGN KEY (ATTRIBUTE_ID) REFERENCES ATTRIBUTE(ID) ON DELETE CASCADE
);

CREATE TABLE ATTRIBUTESET (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    PRIMARY KEY (ID)
);

CREATE TABLE ATTRIBUTEUSE (
    ID VARCHAR(256) NOT NULL,
    ATTRIBUTESET_ID VARCHAR(256) NOT NULL,
    ATTRIBUTE_ID VARCHAR(256) NOT NULL,
    LINENO INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT ATTUSE_SET FOREIGN KEY (ATTRIBUTESET_ID) REFERENCES ATTRIBUTESET(ID) ON DELETE CASCADE,
    CONSTRAINT ATTUSE_ATT FOREIGN KEY (ATTRIBUTE_ID) REFERENCES ATTRIBUTE(ID)
);
CREATE UNIQUE INDEX ATTUSE_LINE ON ATTRIBUTEUSE(ATTRIBUTESET_ID, LINENO);

CREATE TABLE ATTRIBUTESETINSTANCE (
    ID VARCHAR(256) NOT NULL,
    ATTRIBUTESET_ID VARCHAR(256) NOT NULL,
    DESCRIPTION VARCHAR(1024),
    PRIMARY KEY (ID),
    CONSTRAINT ATTSETINST_SET FOREIGN KEY (ATTRIBUTESET_ID) REFERENCES ATTRIBUTESET(ID) ON DELETE CASCADE
);

CREATE TABLE ATTRIBUTEINSTANCE (
    ID VARCHAR(256) NOT NULL,
    ATTRIBUTESETINSTANCE_ID VARCHAR(256) NOT NULL,
    ATTRIBUTE_ID VARCHAR(256) NOT NULL,
    VALUE VARCHAR(1024),
    PRIMARY KEY (ID),
    CONSTRAINT ATTINST_SET FOREIGN KEY (ATTRIBUTESETINSTANCE_ID) REFERENCES ATTRIBUTESETINSTANCE(ID) ON DELETE CASCADE,
    CONSTRAINT ATTINST_ATT FOREIGN KEY (ATTRIBUTE_ID) REFERENCES ATTRIBUTE(ID)
);
CREATE TABLE PRINTER (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME VARCHAR(255) DEFAULT NULL,
    NAME_PRINTER VARCHAR(255) DEFAULT NULL,
    TYPE varchar(255) DEFAULT NULL,
    IP VARCHAR(255) DEFAULT NULL,
    WITH_TICKET INTEGER DEFAULT 0 NOT NULL,
    NUMBER_TICKET INTEGER DEFAULT 1,
    typePrinter varchar(255) DEFAULT NULL,
    PORT varchar(255) DEFAULT NULL,
    BAND_RATE varchar(255) DEFAULT NULL,
    REF_WEB VARCHAR(255) DEFAULT NULL,
    MODEL VARCHAR(255) DEFAULT NULL,
    SUMMARY_KITCHEN SMALLINT DEFAULT 0 NOT NULL,
    NUMBER_PRINTER SMALLINT DEFAULT 0 NOT NULL,
    CONSTRAINT PRINTER_primary_key PRIMARY KEY (ID)
);

CREATE TABLE ZONES (
  ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  NAME VARCHAR(255) NOT NULL,
  POSITION INTEGER DEFAULT 0,
  COLOR CHAR(7) NOT NULL,
  ref_id INTEGER DEFAULT 0,
  NUMBER_ZONE SMALLINT DEFAULT 0 NOT NULL,
  CONSTRAINT zone_pk PRIMARY KEY (ID)
);

CREATE TABLE PRODUCTS (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    CODE VARCHAR(255) DEFAULT NULL,
    CODETYPE VARCHAR(1024),
    NAME VARCHAR(1024) NOT NULL,
    DESCRIPTION VARCHAR(1024) DEFAULT NULL,
    PRICEBUY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICESELL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CATEGORY INTEGER NOT NULL,
    TAXCAT VARCHAR(256) NOT NULL,
    ATTRIBUTESET_ID VARCHAR(256) DEFAULT NULL,
    STOCKCOST DOUBLE PRECISION DEFAULT 0 NOT NULL,
    STOCKVOLUME DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ISCOM SMALLINT DEFAULT 0 NOT NULL,
    ISSCALE SMALLINT DEFAULT 0 NOT NULL,
    ISKITCHEN SMALLINT DEFAULT 0 NOT NULL,
    PRINTKB SMALLINT DEFAULT 0 NOT NULL,
    SENDSTATUS SMALLINT DEFAULT 0 NOT NULL,
    ISSERVICE SMALLINT DEFAULT 0 NOT NULL,
    ATTRIBUTES BLOB,
    DISPLAY VARCHAR(256),
    ISVPRICE SMALLINT DEFAULT 0 NOT NULL,
    ISVERPATRIB SMALLINT DEFAULT 0 NOT NULL,
    TEXTTIP VARCHAR(256) DEFAULT '',
    WARRANTY SMALLINT DEFAULT 0 NOT NULL,
    STOCKUNITS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    order_item INTEGER NOT NULL DEFAULT 0,
    price_type VARCHAR(256) NOT NULL DEFAULT 'per_piece',
    sp SMALLINT DEFAULT 0 NOT NULL,
    emp SMALLINT DEFAULT 0 NOT NULL,
    lv SMALLINT DEFAULT 0 NOT NULL,
    bar SMALLINT DEFAULT 0 NOT NULL,
    terasse SMALLINT DEFAULT 0 NOT NULL,
    happy_hour SMALLINT DEFAULT 0 NOT NULL,
    price_sp DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_emp DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_lv DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_bar DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_terasse DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_happy DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_junior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_senior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_mega DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_sp_junior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_sp_senior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_sp_mega DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_emp_junior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_emp_senior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_emp_mega DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_lv_junior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_lv_senior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_lv_mega DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_bar_junior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_bar_senior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_bar_mega DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_terasse_junior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_terasse_senior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_terasse_mega DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_happy_junior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_happy_senior DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_happy_mega DOUBLE PRECISION DEFAULT 0 NOT NULL,
    removed SMALLINT DEFAULT 0 NOT NULL,
    hidden SMALLINT DEFAULT 0 NOT NULL,
    menu SMALLINT DEFAULT 0 NOT NULL,
    path varchar(255) DEFAULT NULL,
    prepared SMALLINT DEFAULT 0 NOT NULL,
    printer INTEGER DEFAULT NULL,
    many_size SMALLINT DEFAULT 0 NOT NULL,
    different_price SMALLINT DEFAULT 0 NOT NULL,
    color varchar(255) DEFAULT NULL,
    TAXEMP VARCHAR(256) DEFAULT NULL,
    TAXLV VARCHAR(256) DEFAULT NULL,
    label SMALLINT DEFAULT 0 NOT NULL,
    printerLabel INTEGER DEFAULT NULL,
    display_kitchen INTEGER DEFAULT NULL,
    option_free INTEGER DEFAULT 0,
    special_option SMALLINT DEFAULT 0 NOT NULL,
    number_line INTEGER NOT NULL DEFAULT 0,
    number_column INTEGER NOT NULL DEFAULT 0,
    max_line INTEGER NOT NULL DEFAULT 0,
    additional_sale SMALLINT DEFAULT 0 NOT NULL,
    moment_product SMALLINT DEFAULT 0 NOT NULL,
    quantity DOUBLE PRECISION DEFAULT 0 NOT NULL,
    REF_WEB VARCHAR(255) DEFAULT NULL,
    unit varchar(255)  default 'piece',
    weight DOUBLE PRECISION DEFAULT 0 NOT NULL,
    extra_unit varchar(255) default null,
    APPLY_DISCOUNT SMALLINT DEFAULT 0 NOT NULL,
    PRINTER_KITCHEN varchar(255) default null,
    HIDDEN_BORNE SMALLINT DEFAULT 0 NOT NULL,
    SOLD_OUT SMALLINT DEFAULT 0 NOT NULL,
    FREE_PRICE SMALLINT DEFAULT 0 NOT NULL,
    ALIAS_KITCHEN VARCHAR(255) DEFAULT NULL,
    SEND_COLOR SMALLINT DEFAULT 0 NOT NULL,
    HAS_DISPLAY_TIME SMALLINT DEFAULT 0 NOT NULL,
    FIRST_PERIOD INTEGER NOT NULL DEFAULT 0,
    END_PERIOD INTEGER NOT NULL DEFAULT 0,
    REMOVED_BY_ADMIN SMALLINT DEFAULT 0 NOT NULL,
    STORABLE SMALLINT DEFAULT 0 NOT NULL,
    MIN_STORE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ADDITIONAL_SALE_AT_SPOT SMALLINT DEFAULT 0 NOT NULL,
    ADDITIONAL_SALE_TAKE_AWAY SMALLINT DEFAULT 0 NOT NULL,
    PRICE_UBER DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DELIVERO DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_UBER_JUNIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_UBER_SENIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_UBER_MEGA DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DELIVERO_JUNIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DELIVERO_SENIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DELIVERO_MEGA DOUBLE PRECISION DEFAULT 0 NOT NULL,
    LATER SMALLINT DEFAULT 0 NOT NULL,
    PRINT_INGREDIENTS SMALLINT DEFAULT 0 NOT NULL,
    OPTIONS_FREE_GROUPED SMALLINT DEFAULT 0 NOT NULL,
    PRICE_PLATFORM DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_PLATFORM_JUNIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_PLATFORM_SENIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_PLATFORM_MEGA DOUBLE PRECISION DEFAULT 0 NOT NULL,
    AVAILABLE_CAISSE SMALLINT DEFAULT 0 NOT NULL,
    SIZE_JUNIOR_ENABLED SMALLINT DEFAULT 1 NOT NULL,
    SIZE_SENIOR_ENABLED SMALLINT DEFAULT 1 NOT NULL,
    SIZE_MEGA_ENABLED SMALLINT DEFAULT 1 NOT NULL,
    LABELED SMALLINT DEFAULT 0 NOT NULL,
    BEST_SALE SMALLINT DEFAULT 0 NOT NULL,
    PROMO_BASKET SMALLINT DEFAULT 0 NOT NULL,
    DISPLAY_IMAGE_IN_KITCHEN SMALLINT DEFAULT 0 NOT NULL, 
    DAILY_STOCK INTEGER NOT NULL DEFAULT 0,
    HAS_BAR_CODE SMALLINT DEFAULT 0 NOT NULL, 
    HIDDEN_UBEREAT SMALLINT DEFAULT 0 NOT NULL, 
    DESCRIPTION_UBEREAT VARCHAR(1024) DEFAULT NULL,
    TOP_PRODUCT SMALLINT DEFAULT 0 NOT NULL,  
    HIDE_NAME_IN_BORNE SMALLINT DEFAULT 0 NOT NULL,  
    HIDE_PRICE_IN_BORNE SMALLINT DEFAULT 0 NOT NULL, 
    HAS_TIMETABLE SMALLINT DEFAULT 0 NOT NULL,
    UNAVAILABLE_ONLINE SMALLINT DEFAULT 0 NOT NULL,
    HIDDEN_ONLINE SMALLINT DEFAULT 0 NOT NULL,
    PRODUCT_UBEREAT SMALLINT DEFAULT 0 NOT NULL,
    MIXED_PRODUCT SMALLINT DEFAULT 0 NOT NULL,
    PRICE_DRIVE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DRIVE_JUNIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DRIVE_SENIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DRIVE_MEGA DOUBLE PRECISION DEFAULT 0 NOT NULL,
    RECTANGULAR_IMAGE SMALLINT DEFAULT 0 NOT NULL,
    PATH_2 varchar(255) DEFAULT NULL,
    PRODUCT_LOYALTY SMALLINT DEFAULT 0 NOT NULL,
    PRICE_POINT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    HIDDEN_ONLINE_TEMPORARY SMALLINT DEFAULT 0 NOT NULL,
    HIDDEN_UBEREAT_TEMPORARY SMALLINT DEFAULT 0 NOT NULL,
    HIDDEN_BORNE_TEMPORARY SMALLINT DEFAULT 0 NOT NULL,
    SOLD_OUT_TEMPORARY SMALLINT DEFAULT 0 NOT NULL,
    ENABLE_IN_OPENING SMALLINT DEFAULT 0 NOT NULL,
    PRICE_OPENING DOUBLE PRECISION DEFAULT 0 NOT NULL,
    HIDDEN_CAISSE SMALLINT DEFAULT 0 NOT NULL,
    ISVALID_CAISSE SMALLINT DEFAULT 0 NOT NULL,
    PRODUCT_PLU varchar(255) DEFAULT NULL,
    TVA_GLOBAL_NO_APPLICABLE SMALLINT DEFAULT 0 NOT NULL,
    PATH_PRODUCT_MOMENT VARCHAR(255) DEFAULT NULL,
    type_image_product_moment VARCHAR(255) DEFAULT NULL,
    DATE_START_DISPLAY TIMESTAMP default null,
    DATE_END_DISPLAY TIMESTAMP default null,
    marque INTEGER NOT NULL DEFAULT 0,
    ZONE_ID INTEGER DEFAULT NULL,
    CONSTRAINT PRODUCTS_primary_key PRIMARY KEY (id),
    CONSTRAINT PRODUCTS_FK_1 FOREIGN KEY (CATEGORY) REFERENCES CATEGORIES(ID),
    CONSTRAINT PRODUCTS_TAXCAT_FK FOREIGN KEY (TAXCAT) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT PRODUCTS_ATTRSET_FK FOREIGN KEY (ATTRIBUTESET_ID) REFERENCES ATTRIBUTESET(ID),
    CONSTRAINT PRODUCTS_printer_FK FOREIGN KEY (printer) REFERENCES PRINTER(ID) ON DELETE SET NULL,
    CONSTRAINT PRODUCTS_TAXEMP_FK FOREIGN KEY (TAXEMP) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT PRODUCTS_TAXLV_FK FOREIGN KEY (TAXLV) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT PRODUCTS_ZONE_FK FOREIGN KEY (ZONE_ID) REFERENCES ZONES(ID)
);



CREATE TABLE PRODUCTS_CAT (
    PRODUCT INTEGER NOT NULL,
    CATORDER INTEGER NOT NULL,
    PRIMARY KEY (PRODUCT),
    CONSTRAINT PRODUCTS_CAT_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID)
);
CREATE INDEX PRODUCTS_CAT_INX_1 ON PRODUCTS_CAT(CATORDER);


CREATE TABLE PRODUCTS_COM (
    ID VARCHAR(256) NOT NULL,
    PRODUCT INTEGER NOT NULL,
    PRODUCT2 INTEGER NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PRODUCTS_COM_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT PRODUCTS_COM_FK_2 FOREIGN KEY (PRODUCT2) REFERENCES PRODUCTS(ID)
);
CREATE UNIQUE INDEX PCOM_INX_PROD ON PRODUCTS_COM(PRODUCT, PRODUCT2);

CREATE TABLE carte (
  id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  name varchar(255) NOT NULL,
  sizeCarte varchar(255) DEFAULT NULL,
  removed SMALLINT DEFAULT 0 NOT NULL,
  REF_WEB VARCHAR(255) DEFAULT NULL,
  REMOVED_BY_ADMIN SMALLINT DEFAULT 0 NOT NULL,
  ID_GLOBAL varchar(255) DEFAULT NULL,
  CONSTRAINT carte_primary_key PRIMARY KEY (id)
);
CREATE TABLE carte_item (
   id_carte INTEGER NOT NULL,
   id_item INTEGER NOT NULL,
   price DOUBLE PRECISION DEFAULT 0 NOT NULL,
   order_item INTEGER NOT NULL DEFAULT 0,
   PRIMARY KEY (id_carte, id_item),
   CONSTRAINT CARTE_FK_1 FOREIGN KEY (id_carte) REFERENCES carte(id),
   CONSTRAINT PRODUCT_FK_2 FOREIGN KEY (id_item) REFERENCES PRODUCTS(ID)
);
CREATE TABLE carte_menu (
  id_carte INTEGER NOT NULL,
  id_item INTEGER NOT NULL,
  carteOrder INTEGER DEFAULT 0 NOT NULL,
  number_carte INTEGER NOT NULL DEFAULT 1,
  PRIMARY KEY (id_carte, id_item),
  CONSTRAINT CARTEM_FK_1 FOREIGN KEY (id_carte) REFERENCES carte(id),
  CONSTRAINT PRODUCT_FK_2M FOREIGN KEY (id_item) REFERENCES PRODUCTS(ID) 
);

CREATE TABLE supplement (
  id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  name varchar(255) NOT NULL,
  has_options SMALLINT DEFAULT 0 NOT NULL,
  is_bold SMALLINT DEFAULT 0 NOT NULL,
  min_options INTEGER DEFAULT NULL,
  max_options INTEGER DEFAULT NULL,
  is_ingredient SMALLINT DEFAULT 0 NOT NULL,
  removed SMALLINT DEFAULT 0 NOT NULL,
  order_supplement INTEGER NOT NULL DEFAULT 0,
  color varchar(255) DEFAULT NULL,
  number_click INTEGER NOT NULL DEFAULT 1,
  path varchar(255) DEFAULT NULL,
  order_name SMALLINT DEFAULT 0 NOT NULL,
  default_category SMALLINT DEFAULT 0 NOT NULL,
  multiple_category SMALLINT DEFAULT 0 NOT NULL,
  REF_WEB VARCHAR(255) DEFAULT NULL,
  display_free SMALLINT DEFAULT 0 NOT NULL,
  prepared SMALLINT DEFAULT 0 NOT NULL,
  printer INTEGER DEFAULT NULL,
  shift_option  INTEGER NOT NULL DEFAULT 0,
  display_screen_sorti SMALLINT DEFAULT 0 NOT NULL,
  HIDDEN_BORNE SMALLINT DEFAULT 0 NOT NULL,
  REMOVED_BY_ADMIN SMALLINT DEFAULT 0 NOT NULL,
  NO_PRINTABLE SMALLINT DEFAULT 0 NOT NULL,
  HIDDEN_UBEREAT SMALLINT DEFAULT 0 NOT NULL,
  HIDDEN_ONLINE SMALLINT DEFAULT 0 NOT NULL,
  SUPPLEMENT_UBEREAT SMALLINT DEFAULT 0 NOT NULL,
  PRINT_BLACK_BACKGROUND SMALLINT DEFAULT 0 NOT NULL,
  ID_GLOBAL varchar(255) DEFAULT NULL,
  DATE_START_DISPLAY TIMESTAMP default null,
  DATE_END_DISPLAY TIMESTAMP default null,
  CONSTRAINT supplement_primary_key PRIMARY KEY (id)
);
CREATE TABLE supplement_item (
  id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  name varchar(255) NOT NULL,
  price DOUBLE PRECISION DEFAULT NULL,
  price2 DOUBLE PRECISION DEFAULT 0,
  price3 DOUBLE PRECISION DEFAULT 0,
  price_junior DOUBLE PRECISION DEFAULT NULL,
  price_senior DOUBLE PRECISION DEFAULT NULL,
  price_mega DOUBLE PRECISION DEFAULT NULL,
  price_size1 DOUBLE PRECISION DEFAULT NULL,
  price_size2 DOUBLE PRECISION DEFAULT NULL,
  price_size3 DOUBLE PRECISION DEFAULT NULL,
  id_supplement INTEGER NOT NULL,
  removed SMALLINT DEFAULT 0 NOT NULL,
  order_item INTEGER NOT NULL DEFAULT 0,
  many_size SMALLINT DEFAULT 0 NOT NULL,
  path varchar(255) DEFAULT NULL,
  REF_WEB VARCHAR(255) DEFAULT NULL,
  HIDDEN_BORNE SMALLINT DEFAULT 0 NOT NULL,
  color varchar(255) DEFAULT NULL,
  ALIAS_KITCHEN VARCHAR(255) DEFAULT NULL,
  SEND_COLOR SMALLINT DEFAULT 0 NOT NULL,
  FLAME_ENABLED SMALLINT DEFAULT 0 NOT NULL,
  NUMBER_FLAME INTEGER NOT NULL DEFAULT 0,
  REMOVED_BY_ADMIN SMALLINT DEFAULT 0 NOT NULL,
  MANY_TYPE SMALLINT DEFAULT 0 NOT NULL,
  HIDDEN SMALLINT DEFAULT 0 NOT NULL,
  HIDDEN_UBEREAT SMALLINT DEFAULT 0 NOT NULL,
  HIDDEN_ONLINE SMALLINT DEFAULT 0 NOT NULL,
  PRICE_SIZE4 DOUBLE PRECISION DEFAULT 0 NOT NULL,
  PRICE_SIZE5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
  PRICE_SIZE6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
  PRICE_SIZE7 DOUBLE PRECISION DEFAULT 0 NOT NULL,
  SUPPLEMENT_ITEM_UBEREAT SMALLINT DEFAULT 0 NOT NULL,
  HIDE_NAME_IN_BORNE SMALLINT DEFAULT 0 NOT NULL, 
  ID_PRODUCT INTEGER DEFAULT NULL,
  SOLD_OUT SMALLINT DEFAULT 0 NOT NULL,
  HIDDEN_IN_KITCHEN SMALLINT DEFAULT 0 NOT NULL,
  ITEM_PLU varchar(255) DEFAULT NULL,
  TAX_ID varchar(255) DEFAULT NULL,
  PRICE_ALREADY_INCLUDED DOUBLE PRECISION DEFAULT 0,
  DATE_START_DISPLAY TIMESTAMP default null,
  DATE_END_DISPLAY TIMESTAMP default null,
  IMAGE_URL varchar(1024) DEFAULT NULL,
  COOKABLE SMALLINT DEFAULT 0 NOT NULL,
  CONSTRAINT supplement_item_primary_key PRIMARY KEY (id),
  CONSTRAINT SUPPLEMENT_FK_1SI FOREIGN KEY (id_supplement) REFERENCES supplement(id),
  CONSTRAINT supplement_item_FK2 FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID)
);
 CREATE TABLE item_ingredients (
  id_supplement_item INTEGER NOT NULL,
  id_item INTEGER NOT NULL,
  quantity SMALLINT DEFAULT 1 NOT NULL,
  PRIMARY KEY (id_supplement_item, id_item),
  CONSTRAINT supplement_item_FK_1 FOREIGN KEY (id_supplement_item) REFERENCES supplement_item(id),
  CONSTRAINT PRODUCT_FK_2I FOREIGN KEY (id_item) REFERENCES PRODUCTS(ID) 
);
CREATE TABLE item_supplements (
  id_supplement INTEGER NOT NULL,
  id_item INTEGER NOT NULL,
  free_able SMALLINT DEFAULT 1 NOT NULL,
  separate SMALLINT DEFAULT 0 NOT NULL,
  option_free INTEGER DEFAULT 0,
  has_limit_options SMALLINT DEFAULT 0 NOT NULL,
  min_options INTEGER DEFAULT NULL,
  max_options INTEGER DEFAULT NULL,
  option_free_size2 INTEGER DEFAULT 0,
  min_options_size2 INTEGER DEFAULT 0,
  max_options_size2 INTEGER DEFAULT 0,
  option_free_size3 INTEGER DEFAULT 0,
  min_options_size3 INTEGER DEFAULT 0,
  max_options_size3 INTEGER DEFAULT 0,
  option_free_size4 INTEGER DEFAULT 0,
  min_options_size4 INTEGER DEFAULT 0,
  max_options_size4 INTEGER DEFAULT 0,
  option_free_size5 INTEGER DEFAULT 0,
  min_options_size5 INTEGER DEFAULT 0,
  max_options_size5 INTEGER DEFAULT 0,
  option_free_size6 INTEGER DEFAULT 0,
  min_options_size6 INTEGER DEFAULT 0,
  max_options_size6 INTEGER DEFAULT 0,
  many_size SMALLINT DEFAULT 0 NOT NULL,
  OPTION_FREE_SIZE7 INTEGER DEFAULT 0,
  MIN_OPTIONS_SIZE7 INTEGER DEFAULT 0,
  MAX_OPTIONS_SIZE7 INTEGER DEFAULT 0,
  OPTION_FREE_SIZE8 INTEGER DEFAULT 0,
  MIN_OPTIONS_SIZE8 INTEGER DEFAULT 0,
  MAX_OPTIONS_SIZE8 INTEGER DEFAULT 0,
  OPTION_FREE_SIZE9 INTEGER DEFAULT 0,
  MIN_OPTIONS_SIZE9 INTEGER DEFAULT 0,
  MAX_OPTIONS_SIZE9 INTEGER DEFAULT 0,
  OPTION_FREE_SIZE10 INTEGER DEFAULT 0,
  MIN_OPTIONS_SIZE10 INTEGER DEFAULT 0,
  MAX_OPTIONS_SIZE10 INTEGER DEFAULT 0,
  PRIMARY KEY (id_supplement, id_item),
  CONSTRAINT supplement_FK_1IS FOREIGN KEY (id_supplement) REFERENCES supplement(id),
  CONSTRAINT PRODUCT_FK_2S FOREIGN KEY (id_item) REFERENCES PRODUCTS(ID) 
);
CREATE TABLE LOCATIONS (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    ADDRESS VARCHAR(1024),
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX LOCATIONS_NAME_INX ON LOCATIONS(NAME);
INSERT INTO LOCATIONS(ID, NAME,ADDRESS) VALUES('0', 'General', NULL);

CREATE TABLE STOCKDIARY (
    ID VARCHAR(256) NOT NULL,
    DATENEW TIMESTAMP NOT NULL,
    REASON INTEGER NOT NULL,
    LOCATION VARCHAR(256) NOT NULL,
    PRODUCT INTEGER NOT NULL,
    ATTRIBUTESETINSTANCE_ID VARCHAR(256),
    UNITS DOUBLE PRECISION NOT NULL,
    PRICE DOUBLE PRECISION NOT NULL,
    APPUSER VARCHAR(256),
    PRIMARY KEY (ID),
    CONSTRAINT STOCKDIARY_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT STOCKDIARY_ATTSETINST FOREIGN KEY (ATTRIBUTESETINSTANCE_ID) REFERENCES ATTRIBUTESETINSTANCE(ID),
    CONSTRAINT STOCKDIARY_FK_2 FOREIGN KEY (LOCATION) REFERENCES LOCATIONS(ID)
);
CREATE INDEX STOCKDIARY_INX_1 ON STOCKDIARY(DATENEW);

CREATE TABLE STOCKLEVEL (
    ID VARCHAR(256) NOT NULL,
    LOCATION VARCHAR(256) NOT NULL,
    PRODUCT INTEGER NOT NULL,
    STOCKSECURITY DOUBLE PRECISION,
    STOCKMAXIMUM DOUBLE PRECISION,
    PRIMARY KEY (ID),
    CONSTRAINT STOCKLEVEL_PRODUCT FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT STOCKLEVEL_LOCATION FOREIGN KEY (LOCATION) REFERENCES LOCATIONS(ID)
);

CREATE TABLE STOCKCURRENT (
    LOCATION VARCHAR(256) NOT NULL,
    PRODUCT INTEGER NOT NULL,
    ATTRIBUTESETINSTANCE_ID VARCHAR(256),
    UNITS DOUBLE PRECISION NOT NULL,
    CONSTRAINT STOCKCURRENT_FK_1 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT STOCKCURRENT_ATTSETINST FOREIGN KEY (ATTRIBUTESETINSTANCE_ID) REFERENCES ATTRIBUTESETINSTANCE(ID),
    CONSTRAINT STOCKCURRENT_FK_2 FOREIGN KEY (LOCATION) REFERENCES LOCATIONS(ID)
);
CREATE UNIQUE INDEX STOCKCURRENT_INX ON STOCKCURRENT(LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID);

CREATE TABLE CLOSEDCASH (
    MONEY VARCHAR(256) NOT NULL,
    HOST VARCHAR(1024) NOT NULL,
    HOSTSEQUENCE INTEGER NOT NULL,
    DATESTART TIMESTAMP NOT NULL,
    DATEEND TIMESTAMP,
    NOSALES SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY(MONEY)
);
CREATE INDEX CLOSEDCASH_INX_1 ON CLOSEDCASH(DATESTART);
CREATE UNIQUE INDEX CLOSEDCASH_INX_SEQ ON CLOSEDCASH(HOST, HOSTSEQUENCE);

CREATE TABLE RECEIPTS (
    ID VARCHAR(256) NOT NULL,
    MONEY VARCHAR(256) NOT NULL,
    DATENEW TIMESTAMP NOT NULL,
    ATTRIBUTES BLOB,
    PERSON VARCHAR(256),
    PRIMARY KEY (ID),
    CONSTRAINT RECEIPTS_FK_MONEY FOREIGN KEY (MONEY) REFERENCES CLOSEDCASH(MONEY)
);
CREATE INDEX RECEIPTS_INX_1 ON RECEIPTS(DATENEW);
CREATE TABLE caisse (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    FOND_CAISSE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    token VARCHAR(255) DEFAULT NULL,
    OUVERTE SMALLINT DEFAULT 0 NOT NULL,
    dateOpen TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    dateClose TIMESTAMP DEFAULT NULL,
    user_open VARCHAR(256) DEFAULT NULL,
    user_close VARCHAR(256) DEFAULT NULL,
    fond_close DOUBLE PRECISION DEFAULT 0,
    user_keenio_id VARCHAR(100) DEFAULT NULL,
    disabled SMALLINT DEFAULT 0 NOT NULL,
    blocked SMALLINT DEFAULT 0 NOT NULL,
    active SMALLINT DEFAULT 0 NOT NULL,
    CONSTRAINT caisse_primary_key PRIMARY KEY (ID),
    CONSTRAINT CAISSE_FK_1 FOREIGN KEY (user_open) REFERENCES PEOPLE(ID),
    CONSTRAINT CAISSE_FK_2 FOREIGN KEY (user_close) REFERENCES PEOPLE(ID)
);
CREATE TABLE ORDER_NUMBER (
    id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ordernumber INTEGER,
    CONSTRAINT ORDER_NUMBER_key PRIMARY KEY (id)
);
CREATE TABLE SALLES (
  ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  NAME varchar(255) NOT NULL,
  CONSTRAINT SALLES_primary_key PRIMARY KEY (ID)
);
CREATE TABLE TABLES (
  ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  NUMBER INTEGER,
  TYPE varchar(255) NOT NULL,
  PERSONS INTEGER,
  POSITIONX INTEGER,
  POSITIONY INTEGER,
  available SMALLINT DEFAULT 1 NOT NULL,
  salle INTEGER NOT NULL,
  CONSTRAINT TABLES_primary_key PRIMARY KEY (ID),
  CONSTRAINT SALLES_FK FOREIGN KEY (salle) REFERENCES SALLES(ID)
);
CREATE TABLE TICKETS (
    ID VARCHAR(256) NOT NULL,
    TICKETTYPE INTEGER DEFAULT 0 NOT NULL,
    TICKETID INTEGER NOT NULL,
    PERSON VARCHAR(256) NOT NULL,
    CUSTOMER INTEGER,
    STATUS varchar(255) DEFAULT NULL,
    total DOUBLE PRECISION DEFAULT 0 NOT NULL,
    type VARCHAR(256) DEFAULT NULL,
    created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    comment VARCHAR(1024),
    paid SMALLINT DEFAULT 0 NOT NULL,
    livreur varchar(256) DEFAULT NULL,
    tempsLv varchar(255) DEFAULT NULL,
    modePayment varchar(255) DEFAULT NULL,
    address INTEGER DEFAULT NULL,
    reason_cancel VARCHAR(1024),
    caisse INTEGER DEFAULT NULL,
    numero_order INTEGER DEFAULT 0,
    idTable INTEGER DEFAULT NULL,
    discount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    typediscount VARCHAR(255) DEFAULT NULL,
    bipper INTEGER DEFAULT 0,
    transferred_date TIMESTAMP DEFAULT NULL,
    transferred SMALLINT DEFAULT 0 NOT NULL,
    olduser VARCHAR(256) DEFAULT NULL,
    operation_user VARCHAR(256) DEFAULT NULL,
    closed SMALLINT DEFAULT 0 NOT NULL,
    invoice INTEGER  default NULL,
    canceled_ticket_id VARCHAR(256)DEFAULT NULL,
    canceled_ticket_id_Int  INTEGER  default NULL,
    is_sync_keenio SMALLINT DEFAULT 0 NOT NULL,
    detach_sync_keenio SMALLINT DEFAULT 0 NOT NULL,
    is_agent_callcenter SMALLINT DEFAULT 0 NOT NULL,
    is_notified_callcenter SMALLINT DEFAULT 0 NOT NULL,
    accepted SMALLINT DEFAULT 0 NOT NULL,
    last_update  TIMESTAMP  default null,
    couverts INTEGER DEFAULT 0,
    SOURCE_ORDER VARCHAR(255)DEFAULT NULL,
    NAME_CUSTOMER VARCHAR(255)DEFAULT NULL,
    date_paid TIMESTAMP DEFAULT NULL,
    num_order_kitchen INTEGER  default NULL,
    DISBURSED SMALLINT DEFAULT 0 NOT NULL,
    DELIVERED SMALLINT DEFAULT 0 NOT NULL,
    ORDERED_FROM VARCHAR(255)DEFAULT 'inside',
    ID_ORDER_KITCHEN INTEGER DEFAULT 0,
    SENT_FROM VARCHAR(255)DEFAULT NULL,
    NUMERO_ONLINE_ORDER varchar(255) DEFAULT NULL,
    PRINT_AFTER_UPDATE SMALLINT DEFAULT 0 NOT NULL,
    NUM_TABLE INTEGER DEFAULT 0,
    NUM_PLATFORM_ORDER VARCHAR(255)DEFAULT NULL,
    LABEL_DISCOUNT VARCHAR(255) DEFAULT NULL,
    ID_SHARED_ORDER INTEGER DEFAULT 0,
    DELIVERED_AT TIMESTAMP DEFAULT NULL,
    DETACH_SYNC_KEENIO_VERIFIED SMALLINT DEFAULT 0 NOT NULL,
    LICENCE_ID_MACHINE VARCHAR(255) DEFAULT NULL,
    CUSTOMER_LOYALTY_VERIFIED SMALLINT DEFAULT 0 NOT NULL,
    IS_SYNC_SOURCE_ORDER SMALLINT DEFAULT 0 NOT NULL,
    PAID_IN_OTHER_CAISSE SMALLINT DEFAULT 0 NOT NULL,
    is_sync_postgre SMALLINT DEFAULT 0 NOT NULL,
    is_sync_cancled SMALLINT DEFAULT 0 NOT NULL,
    sendorder_progress VARCHAR(1024) DEFAULT '' NOT NULL,
    ID_ONLINE_ORDER VARCHAR(255) DEFAULT NULL,
    EASEL_NUMBER INTEGER DEFAULT 0,
    PLATFORM_ORDER SMALLINT DEFAULT 0 NOT NULL,
    TAKE_AWAY_PHONE SMALLINT DEFAULT 0 NOT NULL,
    TPS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVQ DOUBLE PRECISION DEFAULT 0 NOT NULL,
    SHARED_ORDER SMALLINT DEFAULT 0 NOT NULL,
    ORDER_ID_BASE VARCHAR(255) DEFAULT NULL,
    KEENIO_BASE_ORDER VARCHAR(255) DEFAULT NULL,
    noteIsSentToPostgre SMALLINT DEFAULT 0 NOT NULL,
    session_id  VARCHAR(255) DEFAULT NULL,
    tag_erc_stan  VARCHAR(255) DEFAULT NULL,
    eft_stan  VARCHAR(255) DEFAULT NULL,
    last_digit  VARCHAR(255) DEFAULT NULL,
    EcrDateTime VARCHAR(255) DEFAULT NULL,
    holder VARCHAR(1024) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT TICKETS_FK_ID FOREIGN KEY (ID) REFERENCES RECEIPTS(ID),
    CONSTRAINT TICKETS_FK_2 FOREIGN KEY (PERSON) REFERENCES PEOPLE(ID),
    CONSTRAINT TICKETS_CUSTOMERS_FK FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID),
    CONSTRAINT TICKETS_livreurs_FK FOREIGN KEY (livreur) REFERENCES PEOPLE(ID),
    CONSTRAINT TICKETS_addresses_FK FOREIGN KEY (address) REFERENCES adresseClient(id),
    CONSTRAINT TICKETS_caisse_FK FOREIGN KEY (caisse) REFERENCES caisse(ID),
    CONSTRAINT TICKETS_table_FK FOREIGN KEY (idTable) REFERENCES TABLES(ID) ON DELETE SET NULL
);
CREATE INDEX TICKETS_TICKETID ON TICKETS(TICKETTYPE, TICKETID);

CREATE TABLE TICKETSNUM (
    ID INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1)
);
INSERT INTO TICKETSNUM VALUES (DEFAULT);

CREATE TABLE TICKETSNUM_REFUND (
    ID INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1)
);
INSERT INTO TICKETSNUM_REFUND VALUES (DEFAULT);

CREATE TABLE TICKETSNUM_PAYMENT (
    ID INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1)
);
INSERT INTO TICKETSNUM_PAYMENT VALUES (DEFAULT);

CREATE TABLE TICKETLINES (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TICKET VARCHAR(256) NOT NULL,
    PRODUCT INTEGER DEFAULT NULL,
    UNITS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TAXID VARCHAR(256) DEFAULT NULL,
    ATTRIBUTES BLOB,
    menu SMALLINT DEFAULT 0 NOT NULL,
    htAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    taxAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    nextElement SMALLINT DEFAULT 0 NOT NULL,
    note VARCHAR(1024) DEFAULT NULL,
    discount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    sizeproduct VARCHAR(255) DEFAULT NULL,
    name_sizeproduct VARCHAR(255) DEFAULT NULL,
    label_discount VARCHAR(255) DEFAULT NULL,
    paid SMALLINT DEFAULT 0 NOT NULL,
    units_paid DOUBLE PRECISION DEFAULT 0 NOT NULL,
    place_served VARCHAR(255) DEFAULT NULL,
    time_served VARCHAR(255) DEFAULT NULL,
    numero_line INTEGER,
    label SMALLINT DEFAULT 0 NOT NULL,
    PRINTER_KITCHEN VARCHAR(255) DEFAULT NULL,
    PROMO_BASKET SMALLINT DEFAULT 0 NOT NULL,
    TYPE_DISCOUNT VARCHAR(255) DEFAULT 'pourcentage',
    PROMO_PRODUCT SMALLINT DEFAULT 0 NOT NULL,
    ID_LINE_KITCHEN INTEGER DEFAULT 0,
    POINTS_LOYALTY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NAME_PRODUCT VARCHAR(255) DEFAULT NULL,
    ALIAS_SIZE VARCHAR(255) DEFAULT NULL,
    PRODUCT_PROMOTION_APPLIED SMALLINT DEFAULT 0 NOT NULL,
    TVA_GLOBAL_NO_APPLICABLE SMALLINT DEFAULT 0 NOT NULL,
    CONSTRAINT TICKETLINES_primary_key PRIMARY KEY (ID),
    CONSTRAINT TICKETLINES_FK_TICKET FOREIGN KEY (TICKET) REFERENCES TICKETS(ID),
    CONSTRAINT TICKETLINES_FK_2 FOREIGN KEY (PRODUCT) REFERENCES PRODUCTS(ID),
    CONSTRAINT TICKETLINES_FK_3 FOREIGN KEY (TAXID) REFERENCES TAXCATEGORIES(ID)
);

CREATE TABLE LINEREMOVED (
  REMOVEDDATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  NAME VARCHAR(256) DEFAULT NULL,
  TICKETID VARCHAR(256) DEFAULT NULL,
  PRODUCTID INTEGER DEFAULT NULL,
  PRODUCTNAME VARCHAR(256) DEFAULT NULL,
  UNITS DOUBLE PRECISION NOT NULL
);

CREATE TABLE PAYMENTS (
    ID VARCHAR(256) NOT NULL,
    RECEIPT VARCHAR(256) NOT NULL,
    PAYMENT VARCHAR(1024) NOT NULL,
    TOTAL DOUBLE PRECISION NOT NULL,
    TRANSID VARCHAR(1024),
    RETURNMSG BLOB,
    NOTES VARCHAR(256),
    TENDERED DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CARDNAME VARCHAR(256),
    avoir_origin VARCHAR(255) DEFAULT  NULL,
    ID_PAYMENT_EXTERNE VARCHAR(255) DEFAULT  NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PAYMENTS_FK_RECEIPT FOREIGN KEY (RECEIPT) REFERENCES RECEIPTS(ID)
);
CREATE INDEX PAYMENTS_INX_1 ON PAYMENTS(PAYMENT);

CREATE TABLE FLOORS (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    IMAGE BLOB,
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX FLOORS_NAME_INX ON FLOORS(NAME);
INSERT INTO FLOORS(ID, NAME, IMAGE) VALUES ('0', 'Restaurant floor', $FILE{/com/openbravo/pos/templates/restaurant_floor.png});

CREATE TABLE PLACES (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    X INTEGER NOT NULL,
    Y INTEGER NOT NULL,
    FLOOR VARCHAR(256) NOT NULL,
    CUSTOMER VARCHAR(256),
    WAITER VARCHAR(256),
    TICKETID VARCHAR(256),
    TABLEMOVED SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PLACES_FK_1 FOREIGN KEY (FLOOR) REFERENCES FLOORS(ID)
);
CREATE UNIQUE INDEX PLACES_NAME_INX ON PLACES(NAME);
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('1', 'Table 1', 80, 70, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('2', 'Table 2', 250, 75, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('3', 'Table 3', 400, 75, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('4', 'Table 4', 80, 200, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('5', 'Table 5', 260, 210, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('6', 'Table 6', 430, 210, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('7', 'Table 7', 80, 330, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('8', 'Table 8', 190, 350, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('9', 'Table 9', 295, 350, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('10', 'Table 10', 430, 345, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('11', 'Table 11', 550, 135, '0');
INSERT INTO PLACES(ID, NAME, X, Y, FLOOR) VALUES ('12', 'Table 12', 550, 290, '0');

CREATE TABLE RESERVATIONS (
    ID VARCHAR(256) NOT NULL,
    CREATED TIMESTAMP NOT NULL,
    DATENEW TIMESTAMP DEFAULT '2013-01-01 00:00:00' NOT NULL,
    TITLE VARCHAR(1024) NOT NULL,
    CHAIRS INTEGER NOT NULL,
    ISDONE SMALLINT NOT NULL,
    DESCRIPTION VARCHAR(1024),
    PRIMARY KEY (ID)
);
CREATE INDEX RESERVATIONS_INX_1 ON RESERVATIONS(DATENEW);

CREATE TABLE RESERVATION_CUSTOMERS (
    ID VARCHAR(256) NOT NULL,
    CUSTOMER INTEGER NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT RES_CUST_FK_1 FOREIGN KEY (ID) REFERENCES RESERVATIONS(ID),
    CONSTRAINT RES_CUST_FK_2 FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID)
);

CREATE TABLE THIRDPARTIES (
    ID VARCHAR(256) NOT NULL,
    CIF VARCHAR(1024) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    ADDRESS VARCHAR(1024),
    CONTACTCOMM VARCHAR(1024),
    CONTACTFACT VARCHAR(1024),
    PAYRULE VARCHAR(1024),
    FAXNUMBER VARCHAR(1024),
    PHONENUMBER VARCHAR(1024),
    MOBILENUMBER VARCHAR(1024),
    EMAIL VARCHAR(1024),
    WEBPAGE VARCHAR(1024),
    NOTES VARCHAR(1024),
    PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX THIRDPARTIES_CIF_INX ON THIRDPARTIES(CIF);
CREATE UNIQUE INDEX THIRDPARTIES_NAME_INX ON THIRDPARTIES(NAME);

CREATE TABLE SHAREDTICKETS (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(1024) NOT NULL,
    CONTENT BLOB,
    APPUSER VARCHAR(256),
    PICKUPID SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID)
);

-- Added for Employee Presence Management
CREATE TABLE SHIFTS (
    ID VARCHAR(256) NOT NULL,
    STARTSHIFT TIMESTAMP NOT NULL,
    ENDSHIFT TIMESTAMP,
    PPLID VARCHAR(256) NOT NULL,
    PRIMARY KEY (ID)
);

INSERT INTO SHIFTS(ID, STARTSHIFT, ENDSHIFT, PPLID) VALUES ('0', '2014-01-01 00:00:00.001', '2014-01-01 00:00:00.002','0');

CREATE TABLE LEAVES (
    ID VARCHAR(256) NOT NULL,
    PPLID VARCHAR(256) NOT NULL,
    NAME VARCHAR(256) NOT NULL,
    STARTDATE TIMESTAMP NOT NULL,
    ENDDATE TIMESTAMP NOT NULL,
    NOTES VARCHAR(256),
    PRIMARY KEY (ID),
  CONSTRAINT LEAVES_PPLID FOREIGN KEY (PPLID) REFERENCES PEOPLE(ID)
);

CREATE TABLE BREAKS (
    ID VARCHAR(256) NOT NULL,
    NAME VARCHAR(256) NOT NULL,
    VISIBLE SMALLINT DEFAULT 1 NOT NULL,
    NOTES VARCHAR(256),
    PRIMARY KEY (ID)
);

INSERT INTO BREAKS(ID, NAME, VISIBLE, NOTES) VALUES ('0', 'Lunch Break', 1, NULL);
INSERT INTO BREAKS(ID, NAME, VISIBLE, NOTES) VALUES ('1', 'Tea Break', 1, NULL);
INSERT INTO BREAKS(ID, NAME, VISIBLE, NOTES) VALUES ('2', 'Mid Break', 1, NULL);

CREATE TABLE SHIFT_BREAKS (
    ID VARCHAR(256) NOT NULL,
    SHIFTID VARCHAR(256) NOT NULL,
    BREAKID VARCHAR(256) NOT NULL,
    STARTTIME TIMESTAMP NOT NULL,
    ENDTIME TIMESTAMP,
    PRIMARY KEY (ID),
    CONSTRAINT SHIFT_BREAKS_BREAKID FOREIGN KEY (BREAKID) REFERENCES BREAKS(ID),
    CONSTRAINT SHIFT_BREAKS_SHIFTID FOREIGN KEY (SHIFTID) REFERENCES SHIFTS(ID)
);

INSERT INTO SHIFT_BREAKS(ID, SHIFTID, BREAKID, STARTTIME, ENDTIME) VALUES ('0', '0', '0', '2014-01-01 00:00:00.003', '2014-01-01 00:00:00.004');

CREATE TABLE MOORERS (
    VESSELNAME VARCHAR(256),
    SIZE INTEGER,
    DAYS INTEGER,
    POWER SMALLINT DEFAULT 0 NOT NULL
);

CREATE TABLE CSVIMPORT (
    ID VARCHAR(256) NOT NULL,
    ROWNUMBER VARCHAR(256),
    CSVERROR VARCHAR(256),
    REFERENCE VARCHAR(1024),
    CODE VARCHAR(1024),
    NAME VARCHAR(1024),
    PRICEBUY DOUBLE PRECISION,
    PRICESELL DOUBLE PRECISION,
    PREVIOUSBUY DOUBLE PRECISION,
    PREVIOUSSELL DOUBLE PRECISION,
    CATEGORY VARCHAR(256),
    PRIMARY KEY (ID)
);

CREATE TABLE PICKUP_NUMBER (
    ID INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1)
);
INSERT INTO PICKUP_NUMBER VALUES (DEFAULT);

CREATE TABLE DRAWEROPENED (
    OPENDATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    NAME VARCHAR(256),
    TICKETID VARCHAR(256)
);
CREATE TABLE ingredient_ticket (
  id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
  idCarte INTEGER NOT NULL,
  nameCarte varchar(255) DEFAULT NULL,
  idProduct INTEGER NOT NULL,
  nameProduct varchar(255) DEFAULT NULL,
  idIngredient INTEGER NOT NULL,
  nameIngredient varchar(255) DEFAULT NULL,
  idTicketLine INTEGER NOT NULL,
  index_carte INTEGER NOT NULL DEFAULT 1,
  ID_INGREDIENT_KITCHEN INTEGER DEFAULT 0,
  CONSTRAINT ing_ticket_PK PRIMARY KEY (ID),
  CONSTRAINT ing_ticket_FK FOREIGN KEY (idTicketLine) REFERENCES TICKETLINES(ID) ON DELETE CASCADE
);

CREATE TABLE Option_ticket (
   id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
   idCarte  INTEGER NOT NULL,
   nameCarte  varchar(255) DEFAULT NULL,
   idProduct  INTEGER NOT NULL,
   nameProduct  varchar(255) DEFAULT NULL,
   idOption  INTEGER NOT NULL,
   nameOption  varchar(255) DEFAULT NULL,
   idTicketLine  INTEGER NOT NULL,
   numberoption  INTEGER NOT NULL DEFAULT 1,
   is_bold SMALLINT DEFAULT 0 NOT NULL,
   price DOUBLE PRECISION DEFAULT 0,
   index_carte INTEGER NOT NULL DEFAULT 1,
   number_free INTEGER NOT NULL DEFAULT 0,
   separate SMALLINT DEFAULT 0 NOT NULL,
   multiple SMALLINT DEFAULT 0 NOT NULL,
   weight  varchar(255) DEFAULT NULL,
   display_free SMALLINT DEFAULT 0 NOT NULL,
   force_free SMALLINT DEFAULT 0 NOT NULL,
   printer INTEGER,
   order_option  INTEGER,
   shift_option  INTEGER NOT NULL DEFAULT 0,
   NO_PRINTABLE SMALLINT DEFAULT 0 NOT NULL,
   parent_supplement_id INTEGER NOT NULL DEFAULT 0,
   ID_SUPPLEMENT_KITCHEN INTEGER DEFAULT 0,
   TAX_ID varchar(255) DEFAULT NULL,
   HT_AMOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
   TAX_AMOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
   FULL_PRICE DOUBLE PRECISION DEFAULT 0,
   CONSTRAINT option_ticket_PK PRIMARY KEY (ID),
   CONSTRAINT option_ticket_FK FOREIGN KEY (idTicketLine) REFERENCES TICKETLINES(ID) ON DELETE CASCADE
);
CREATE TABLE Product_ticket (
   id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
   idCarte  INTEGER NOT NULL,
   nameCarte  varchar(255) DEFAULT NULL,
   idProduct  INTEGER NOT NULL,
   nameProduct  varchar(255) DEFAULT NULL,
   idTicketLine  INTEGER NOT NULL,
   numberoproduct INTEGER NOT NULL DEFAULT 1,
   price DOUBLE PRECISION DEFAULT 0,
   index_carte INTEGER NOT NULL DEFAULT 1,
   ID_ITEM_KITCHEN INTEGER DEFAULT 0,
   sizeproduct VARCHAR(255) DEFAULT NULL,
   comment VARCHAR(1024) DEFAULT NULL,
   printer INTEGER DEFAULT NULL,
   printerLabel INTEGER DEFAULT NULL,
   ZONE_ID INTEGER DEFAULT NULL,
   CONSTRAINT product_ticket_PK PRIMARY KEY (ID),
   CONSTRAINT product_ticket_FK FOREIGN KEY (idTicketLine) REFERENCES TICKETLINES(ID) ON DELETE CASCADE
);
CREATE TABLE PRODUCT_ORDER (
   idProduct INTEGER NOT NULL,
   idTicketLine INTEGER NOT NULL,
   PRIMARY KEY (idProduct, idTicketLine),
   CONSTRAINT ORDERPRO_FK_1 FOREIGN KEY (idProduct) REFERENCES PRODUCTS(ID) ON DELETE CASCADE,
   CONSTRAINT ORDERPRO_FK_2 FOREIGN KEY (idTicketLine) REFERENCES TICKETLINES(ID) ON DELETE CASCADE
);
CREATE TABLE PHOTO_DISPLAY (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    REF_SYNCH VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE PRODUCT_DIVERS (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    PRODUCT VARCHAR(256) DEFAULT NULL,
    PRICE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TAXID VARCHAR(256) DEFAULT NULL,
    TICKET VARCHAR(256) NOT NULL,
    htAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    taxAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    UNITS DOUBLE PRECISION DEFAULT 1 NOT NULL,
    paid SMALLINT DEFAULT 0 NOT NULL,
    units_paid DOUBLE PRECISION DEFAULT 0 NOT NULL,
    place_served VARCHAR(255) DEFAULT NULL,
    time_served VARCHAR(255) DEFAULT NULL,
    CONSTRAINT PRODUCTD_primary_key PRIMARY KEY (ID),
    CONSTRAINT PRODUCTD_FK_TAX FOREIGN KEY (TAXID) REFERENCES TAXCATEGORIES(ID),
    CONSTRAINT PRODUCTD_FK_TICKET FOREIGN KEY (TICKET) REFERENCES TICKETS(ID) ON DELETE CASCADE
);
CREATE TABLE HISTORIQUE_CAISSE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    dateOpen TIMESTAMP DEFAULT NULL,
    dateClose TIMESTAMP DEFAULT NULL,
    caisse INTEGER DEFAULT NULL,
    user_open VARCHAR(256) DEFAULT NULL,
    user_close VARCHAR(256) DEFAULT NULL,
    htAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    taxAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ttcAmount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    cumul_Total DOUBLE PRECISION DEFAULT 0 NOT NULL,
    fund_open DOUBLE PRECISION DEFAULT 0 NOT NULL,
    fund_close DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CONSTRAINT Historique_primary_key PRIMARY KEY (ID),
    CONSTRAINT Historique_FK_1 FOREIGN KEY (user_open) REFERENCES PEOPLE(ID),
    CONSTRAINT Historique_FK_2 FOREIGN KEY (user_close) REFERENCES PEOPLE(ID),
    CONSTRAINT Historique_caisse_FK FOREIGN KEY (caisse) REFERENCES caisse(ID)
);
CREATE TABLE DOCUMENT(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    ticket VARCHAR(256) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT DOC_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE ENTETE (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    version_soft VARCHAR(256) DEFAULT '2.5' NOT NULL,
    nb_print INTEGER default 0,
    company VARCHAR(256) DEFAULT  NULL,
    address VARCHAR(256) DEFAULT  NULL,
    zip_code VARCHAR(256) DEFAULT  NULL,
    city VARCHAR(256) DEFAULT  NULL,
    country VARCHAR(256) DEFAULT  NULL,
    siret VARCHAR(256) DEFAULT  NULL,
    code_NAF VARCHAR(256) DEFAULT  NULL,
    num_tva VARCHAR(256) DEFAULT  NULL,
    code_operator VARCHAR(256) DEFAULT  NULL,
    name_operator VARCHAR(256) DEFAULT  NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    nb_customer INTEGER DEFAULT 1  NOT NULL,
    timestampGDH timestamp,
    type_operation VARCHAR(256) DEFAULT 'commande' NOT NULL,
    type_doc VARCHAR(256) DEFAULT 'ticket' NOT NULL,
    nb_lines INTEGER,
    ticket VARCHAR(256) NOT NULL,
    header_Supplementaire VARCHAR(256) ,
    footer_Supplementaire VARCHAR(256) ,
    ticket_status VARCHAR(256) Default 'normal' ,
    signature_Ticket VARCHAR(2000) default null,
    horodatage VARCHAR(256) default NULL,
    code_remise SMALLINT DEFAULT 1,
    NAME_SOFT VARCHAR(256) DEFAULT NULL,
    USE_ID_IN_SIGNATURE SMALLINT DEFAULT 0 NOT NULL,
    ROUND_AMOUNT SMALLINT DEFAULT 0 NOT NULL,
    RESTITUTION_TYPE VARCHAR(256) DEFAULT  NULL,
    NB_SEND_E_TICKET INTEGER default 0,
    PRIMARY KEY (id),
    CONSTRAINT ENTETE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE LINES(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    code_product VARCHAR(256),
    origin_data VARCHAR(256) DEFAULT 'IN' NOT NULL,
    descriptive_product VARCHAR(256),
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION ,
    price_HT DOUBLE PRECISION,
    price_TTC  DOUBLE PRECISION,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    type_operation VARCHAR(256) DEFAULT 'Vente' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT 'N/A' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    quantite DOUBLE PRECISION,
    discount  DOUBLE PRECISION,
    taux_discount DOUBLE PRECISION,
    horodatage VARCHAR(256) default NULL,
    REF_ORIGINE INTEGER,
    TOTAL_TAX DOUBLE PRECISION,
    PRIMARY KEY (id),
    CONSTRAINT LINE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE TOTAL_TAX(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    num_line INTEGER,
    total_ht DOUBLE PRECISION,
    code_tax VARCHAR(256),
    rate_tax DOUBLE PRECISION,
    total_tax DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    timestampGDH timestamp,
    REF_ORIGINE INTEGER,
    TAXE_GLOBAL SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TAX_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE TOTAL_ENCAISSEMENT(
  id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    num_line INTEGER DEFAULT 0,
    total_ht DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    ticket VARCHAR(256) NOT NULL,
    total_tax DOUBLE PRECISION,
    TOTAL_DISCOUNT DOUBLE PRECISION,
    REF_ORIGINE INTEGER,
    TOTAL_HT_TAXABLE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_NO_TAXABLE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT TOTAL_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE TICKET_PAYMENT(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    type_regulation VARCHAR(256) DEFAULT 'ESPECE' NOT NULL,
    code_regulation VARCHAR(256) DEFAULT  NULL,
    mode_regulation VARCHAR(256) DEFAULT NULL,
    total DOUBLE PRECISION,
    quantity DOUBLE PRECISION DEFAULT 1 NOT NULL,
    type_operation VARCHAR(256) DEFAULT 'encaissement' NOT NULL,
    code_user VARCHAR(256),
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT '1' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    ticket VARCHAR(256) NOT NULL,
    horodatage VARCHAR(256) default NULL,
    REF_ORIGINE INTEGER,
    PRIMARY KEY (id),
    CONSTRAINT PAYMENT_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE FACTURE (
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    company VARCHAR(256) DEFAULT 'societe 1' NOT NULL,
    name_contact VARCHAR(256) DEFAULT NULL,
    address VARCHAR(256) DEFAULT '12 rue II' NOT NULL,
    zip_code VARCHAR(256) DEFAULT '7500' NOT NULL,
    city VARCHAR(256) DEFAULT 'paris' NOT NULL,
    country VARCHAR(256) DEFAULT NULL,
    siret VARCHAR(256) DEFAULT NULL,
    code_NAF VARCHAR(256) DEFAULT NULL,
    num_tva VARCHAR(256) DEFAULT NULL,
    signature VARCHAR(2000) DEFAULT  NULL,
    ticket VARCHAR(256) NOT NULL,
    physical_person SMALLINT DEFAULT 1 NOT NULL,
    cancel SMALLINT DEFAULT 0 NOT NULL,
    nb_print INTEGER,
    date_created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    num_doc INTEGER ,
    horodatage VARCHAR(256) default NULL,
    TYPE_OPERATION VARCHAR(256) DEFAULT 'FACTURE' NOT NULL,
    CANCELED_FACTURE_ID  INTEGER  default 0,
    VERSION_SOFT VARCHAR(256) DEFAULT NULL,
    NAME_SOFT VARCHAR(256) DEFAULT NULL,
    ID_CUSTOMER INTEGER,
    COMPANY_SENDER VARCHAR(256) DEFAULT  NULL,
    ADDRESS_SENDER VARCHAR(256) DEFAULT  NULL,
    ZIP_CODE_SENDER VARCHAR(256) DEFAULT  NULL,
    CITY_SENDER VARCHAR(256) DEFAULT  NULL,
    COUNTREY_SENDER VARCHAR(256) DEFAULT  NULL,
    SIRET_SENDER VARCHAR(256) DEFAULT  NULL,
    CODE_NAF_SENDER VARCHAR(256) DEFAULT  NULL,
    NUM_TVA_SENDER VARCHAR(256) DEFAULT  NULL,
    FORME_JURIDIQUE_SENDER VARCHAR(256) DEFAULT NULL,
    CAPITAL_SOCIAL_SENDER VARCHAR(256) DEFAULT NULL,
    RCS_SENDER VARCHAR(256) DEFAULT NULL,
    GREFFE_SENDER VARCHAR(256) DEFAULT NULL,
    METIER_SENDER VARCHAR(256) DEFAULT NULL,
    code_operator VARCHAR(256) DEFAULT  NULL,
    name_operator VARCHAR(256) DEFAULT  NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    REF_TICKET INTEGER,
    INFO_SENDER_INCLUDED SMALLINT DEFAULT 0 NOT NULL,
    USE_TYPE_IN_SIGNATURE SMALLINT DEFAULT 0 NOT NULL,
    ROUND_AMOUNT SMALLINT DEFAULT 0 NOT NULL,
    FACTURE_TYPE VARCHAR(256) DEFAULT 'Bien' NOT NULL,
    REGLEMENT_TVA_SENDER VARCHAR(256) DEFAULT 'TVA sur les encaissements' NOT NULL,
    CONSTRAINT FACTURE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID),
    CONSTRAINT FACTURE_FK_Doc FOREIGN KEY (num_doc) REFERENCES DOCUMENT(ID),
    CONSTRAINT FACTURE_CUSTOMERS_FK FOREIGN KEY (ID_CUSTOMER) REFERENCES CUSTOMERS(ID),
    PRIMARY KEY (id)
);
CREATE TABLE GRAND_TOTAL(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    timestampGDH timestamp,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    signature VARCHAR(2000) DEFAULT NULL,
    ticket VARCHAR(256) NOT NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    PRIMARY KEY (id),
    horodatage VARCHAR(256) default NULL,
    grand_total_Perpetual_reel DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_0 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_7_7 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    BEFORE_PERPETUAL_RESET SMALLINT DEFAULT 0 NOT NULL,
    REF_ORIGINE INTEGER,
    ADD_PERPETUAL_IN_SIGNATURE SMALLINT DEFAULT 0 NOT NULL,
    ROUND_AMOUNT SMALLINT DEFAULT 0 NOT NULL,
    TVA_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_12 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_21 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CONSTRAINT GRAND_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);
CREATE TABLE GRAND_TOTAL_PERIODE(
    id VARCHAR(256) NOT NULL,
    num_doc VARCHAR(256) DEFAULT '1234' NOT NULL,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    signature VARCHAR(2000) DEFAULT  NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    timestampGDH timestamp,
    horodatage VARCHAR(256) default NULL,
    type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    grand_total_Perpetual_reel DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CASH_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CB_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TR_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DEBIT_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CREDIT_EMPLOYEE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    LOYALTY_CARD DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CASHDRO_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CACH_GLORY_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    VIRMENT_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CHEQUE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    AVOIR_DECAISSE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    AVOIR_ENCAISSE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_5_5_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_10_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_20_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_ORDERS INTEGER  DEFAULT 0 NOT NULL,
    NUMBER_PRODUCTS_SOLD DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TURNOVER_CANCELED DOUBLE  DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_AT_SPOT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_TAKE_AWAY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DELIVERY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_UBER DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DELIVERO DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_CB INTEGER  DEFAULT 0 NOT NULL,
    NUMBER_TR INTEGER  DEFAULT 0 NOT NULL,
    TOTAL_DISCOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_DISCOUNT_LINES DOUBLE PRECISION DEFAULT 0 NOT NULL,
    INSERT_FINANCIAL_INFOS SMALLINT DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_JUST_EAT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_0 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_0_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DRIVE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_7_7 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_7_7_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_5_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_1_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_5_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TWINT_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_SMOOD DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CHEQUE_VACANCES_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    BEFORE_PERPETUAL_RESET SMALLINT DEFAULT 0 NOT NULL,
    ROUND_AMOUNT SMALLINT DEFAULT 0 NOT NULL, 
    ISSYNCHRONIZED SMALLINT DEFAULT 0 NOT NULL,
    ADD_TO_Z_GLOBAL SMALLINT DEFAULT 0 NOT NULL,
    TURNOVER_PLATFORM DOUBLE PRECISION DEFAULT 0 NOT NULL,
    STATS_UPDATED SMALLINT DEFAULT 0 NOT NULL,
    NB_PLATFORM_STATS_UPDATED SMALLINT DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_PLATFORM INTEGER  DEFAULT 0 NOT NULL,
    CASH_LOGY_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DISHOP DOUBLE PRECISION DEFAULT 0 NOT NULL,
    STRIPE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DELIVEROO DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_12 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_21 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_6_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_12_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_21_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TPS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVQ DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CREDIT_CARD_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DEBIT_CARD_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TURNOVER_UBEREAT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_6 DOUBLE PRECISION DEFAULT 0 NOT NULL, 
    TVA_8_1_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_6_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_TAXABLE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_NO_TAXABLE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    FORCED_CLOTURE_GENERATED SMALLINT DEFAULT 0 NOT NULL,
    TVA_UBER_UPDATED SMALLINT DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_AT_SPOT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_TAKE_AWAY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_DELIVERY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_DRIVE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_AT_SPOT INTEGER DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_TAKE_AWAY INTEGER DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_DELIVERY INTEGER DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_DRIVE INTEGER DEFAULT 0 NOT NULL,
    CARTE_TR_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    BANK_TRANSFER_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_CARTE_TR INTEGER  DEFAULT 0 NOT NULL,
    CASHLOGY_UPDATED SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id)
);
CREATE TABLE MARUQENF525(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    SIRET VARCHAR(256) DEFAULT NULL,
    TVAINTRA VARCHAR(256) DEFAULT NULL,
    CODENAF VARCHAR(256) DEFAULT NULL,
    COMPANY VARCHAR(256) DEFAULT NULL,
    ADDRESS1 VARCHAR(256) DEFAULT NULL,
    ADDRESS2 VARCHAR(256) DEFAULT NULL,
    ZIPCODE VARCHAR(256) DEFAULT NULL,
    CITY VARCHAR(256) DEFAULT NULL,
    COUNTRY VARCHAR(256) DEFAULT NULL,
    NEW_SIRET SMALLINT DEFAULT 0 NOT NULL,
    UPDATE_SIRET_AT timestamp,
    OLD_SIRET VARCHAR(256) DEFAULT NULL,
    FORME_JURIDIQUE VARCHAR(256) DEFAULT NULL,
    CAPITAL_SOCIAL VARCHAR(256) DEFAULT NULL,
    RCS VARCHAR(256) DEFAULT NULL,
    GREFFE VARCHAR(256) DEFAULT NULL,
    METIER VARCHAR(256) DEFAULT NULL,
    FIRST_CONNEXION TIMESTAMP DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE TicketResto(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    num VARCHAR(256) DEFAULT NULL,
    type INTEGER,
    amount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    validity_year INTEGER,
    date_created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id)
);
CREATE TABLE Journal(
   id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   code_event INTEGER DEFAULT NULL,
   descriptif VARCHAR(256),
   code_operator VARCHAR(256),
   type_data VARCHAR(256),
   date_created TIMESTAMP,
   informations VARCHAR(256) DEFAULT NULL,
   PRIMARY KEY (ID)
);
CREATE TABLE Duplicata(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    id_Doc VARCHAR(256) DEFAULT NULL,
    impression_Number INTEGER,
    type_doc VARCHAR(256),
    user_operator VARCHAR(256) DEFAULT NULL,
    date_impression TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    signature VARCHAR(2000),
    num_doc INTEGER default 0 not null ,
    horodatage VARCHAR(256) default NULL,
    CHECK_TYPE_DOC SMALLINT DEFAULT 0 NOT NULL,
    version_soft VARCHAR(256) DEFAULT NULL,
    MOTIF_IMPRESSION VARCHAR(1024) default NULL,
    REF_FACTURE INTEGER default 0 not null,
    REF_TICKET INTEGER default 0 not null,
    CONSTRAINT DUPLICAT_USER_FK_1 FOREIGN KEY (user_operator) REFERENCES PEOPLE(ID),
    CONSTRAINT DUPLICATA_FK_TICKET FOREIGN KEY (id_Doc) REFERENCES TICKETS(ID),
    PRIMARY KEY (id)
);
CREATE TABLE ARCHIV_PERIODE(
    id VARCHAR(256) NOT NULL,
    grand_total DOUBLE PRECISION,
    grand_total_Perpetual DOUBLE PRECISION,
    signature VARCHAR(2000) DEFAULT  NULL,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    timestampGDH timestamp,
    chemin  VARCHAR(256) default NULL,
    type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    horodatage VARCHAR(256) default NULL,
    TVA_0 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_7_7 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ROUND_AMOUNT SMALLINT DEFAULT 0 NOT NULL,
    TVA_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_12 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_21 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ISSYNCHRONIZED SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id)
);


CREATE TABLE Maintenance_Operation(
    id INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    operation_Name VARCHAR(256) DEFAULT  NULL,
    date_Start timestamp,
    date_end timestamp,
    finiched SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id)
);

CREATE TABLE LOG_PANIER (
  id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
  user_delete VARCHAR(256) NOT NULL,
  numero_order INTEGER,
  multiply DOUBLE, 
  price DOUBLE,
  nameProduct VARCHAR(256) DEFAULT NULL,
  date_delete TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  discount DOUBLE PRECISION DEFAULT 0 NOT NULL,
  label_discount VARCHAR(255) DEFAULT NULL,
  IS_SYNCHRO SMALLINT DEFAULT 0 NOT NULL,
  validate SMALLINT DEFAULT 1 NOT NULL,
  NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL,
  CONSTRAINT log_PK PRIMARY KEY (ID),
  CONSTRAINT log_user_FK FOREIGN KEY (user_delete) REFERENCES PEOPLE(ID)
);
CREATE TABLE PHOTO_PUB_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    REF_SYNCH VARCHAR(255) DEFAULT NULL,
    LAST_UPDATE TIMESTAMP,
    PRIMARY KEY (ID)
);
CREATE TABLE PHOTO_HOME_BORNE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    path VARCHAR(255) NOT NULL,
    REF_SYNCH VARCHAR(255) DEFAULT NULL,
    LAST_UPDATE TIMESTAMP,
    PRIMARY KEY (ID)
);
CREATE TABLE SOFTWARE(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(256) DEFAULT  NULL,
    OLD_DATABASE_VERSION VARCHAR(256) DEFAULT  NULL,
    DATABASE_VERSION VARCHAR(256) DEFAULT  NULL,
    SOFTWARE_VERSION VARCHAR(256) DEFAULT  NULL,
    LAST_UPGRADE_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID)
);
CREATE TABLE HISTORIQUE_STOCK (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    product INTEGER NOT NULL,
    date_operation TIMESTAMP DEFAULT NULL,
    type_operation VARCHAR(256) DEFAULT  NULL,
    quantity DOUBLE PRECISION DEFAULT 0 NOT NULL,
    user_operator VARCHAR(256) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT HISTORIQUE_STOCK_FK1 FOREIGN KEY (product) REFERENCES PRODUCTS(ID),
    CONSTRAINT HISTORIQUE_STOCK_FK2 FOREIGN KEY (user_operator) REFERENCES PEOPLE(ID)
);
CREATE TABLE PRODUCTS_SIZE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    name_size VARCHAR(255) DEFAULT  NULL,
    label_size VARCHAR(255) DEFAULT  NULL,
    price DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_sp DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_emp DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_lv DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_bar DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_terasse DOUBLE PRECISION DEFAULT 0 NOT NULL,
    price_happy_hour DOUBLE PRECISION DEFAULT 0 NOT NULL,
    product INTEGER NOT NULL,
    REF_WEB VARCHAR(255) DEFAULT NULL,
    PRICE_UBER DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_DELIVERO DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_PLATFORM DOUBLE PRECISION DEFAULT 0 NOT NULL,
    SIZE_ENABLED SMALLINT DEFAULT 1 NOT NULL,
    PRICE_DRIVE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TARIFF INTEGER DEFAULT 1,
    ORDER_SIZE INTEGER DEFAULT 0,
    ID_GLOBAL varchar(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PRODUCT_SIZE_FK1 FOREIGN KEY (product) REFERENCES PRODUCTS(ID)
);
CREATE TABLE TICKET_AVOIR (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    amount DOUBLE PRECISION DEFAULT 0 NOT NULL,
    used SMALLINT DEFAULT 0 NOT NULL,
    expiration_date timestamp,
    bar_code VARCHAR(255) DEFAULT  NULL,
    origin VARCHAR(255) DEFAULT  NULL,
    TICKET VARCHAR(256) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT TICKET_AVOIR_FK FOREIGN KEY (TICKET) REFERENCES TICKETS(ID)
);
CREATE TABLE DEBIT_CUSTOMER (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    AMOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TRANSFER_NUM VARCHAR(256) DEFAULT NULL,
    PAID SMALLINT DEFAULT 0 NOT NULL,
    DATE_PAYMENT timestamp,
    CUSTOMER INTEGER NOT NULL,
    TICKET VARCHAR(256) NOT NULL,
    PAYMENT VARCHAR(256) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT DEBIT_CUSTOMER_FK1 FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID),
    CONSTRAINT DEBIT_CUSTOMER_FK2 FOREIGN KEY (TICKET) REFERENCES TICKETS(ID),
    CONSTRAINT DEBIT_CUSTOMER_FK3 FOREIGN KEY (PAYMENT) REFERENCES PAYMENTS(ID)
);
CREATE TABLE TICKETS_KITCHEN (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TYPE_ORDER VARCHAR(256) DEFAULT NULL,
    CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    CAISSE VARCHAR(255) DEFAULT NULL,
    NUM_ORDER INTEGER DEFAULT 0,
    NUM_TABLE INTEGER DEFAULT 0,
    BIPPER INTEGER DEFAULT 0,
    COUVERTS INTEGER DEFAULT 0,
    FINISHED SMALLINT DEFAULT 0 NOT NULL,
    DATE_ORDER TIMESTAMP,
    STATUS VARCHAR(255) DEFAULT NULL,
    ID_TICKET VARCHAR(256),
    PRIMARY KEY (ID)
);
CREATE TABLE LINES_KITCHEN (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TICKET INTEGER DEFAULT NULL,
    PRODUCT VARCHAR(256) DEFAULT NULL,
    UNITS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    MENU SMALLINT DEFAULT 0 NOT NULL,
    NOTE VARCHAR(1024) DEFAULT NULL,
    SIZE_PRODUCT VARCHAR(255) DEFAULT NULL,
    FINISHED SMALLINT DEFAULT 0 NOT NULL,
    SUPPLEMENTS VARCHAR(255) DEFAULT NULL,
    INGREDIENTS VARCHAR(255) DEFAULT NULL,
    ID_LINE INTEGER,
    STATUS VARCHAR(255) DEFAULT NULL,
    PAID SMALLINT DEFAULT 0 NOT NULL,
    NUMLINE INTEGER DEFAULT 0,
    LINES_SIZE INTEGER DEFAULT 0,
    AFTER_SEPARATOR VARCHAR(255) DEFAULT NULL,
    PLACE_SERVED VARCHAR(255) DEFAULT NULL,
    TIME_SERVED VARCHAR(255) DEFAULT NULL,
    NUMERO_LINE INTEGER,
    LABEL SMALLINT DEFAULT 0 NOT NULL,
    INGREDIENTS_INCLUS VARCHAR(255) DEFAULT NULL,
    FINISHED_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRINT_WARNING SMALLINT DEFAULT 0 NOT NULL,
    PRINTER_KITCHEN VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT LINES_KITCHEN_FK_TK FOREIGN KEY (TICKET) REFERENCES TICKETS_KITCHEN(ID)
);
CREATE TABLE ITEMS_LINE (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    LINE INTEGER DEFAULT NULL,
    PRODUCT VARCHAR(256) DEFAULT NULL,
    UNITS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    SIZE_PRODUCT VARCHAR(255) DEFAULT NULL,
    SUPPLEMENTS VARCHAR(255) DEFAULT NULL,
    INGREDIENTS VARCHAR(255) DEFAULT NULL,
    ID_PRODUCT INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT ITEMS_LINE_FK_LINE FOREIGN KEY (LINE) REFERENCES LINES_KITCHEN(ID)
);
CREATE TABLE COURSES(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    PRODUCT VARCHAR(255) DEFAULT NULL,
    UNITS DOUBLE,
    PRICE DOUBLE,
    VALID SMALLINT DEFAULT 0 NOT NULL,
    CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    DATE_VALIDATION  TIMESTAMP  DEFAULT NULL,
    CLOSED SMALLINT DEFAULT 0 NOT NULL,
    REMOVED SMALLINT DEFAULT 0 NOT NULL,
    USER_OPERATOR VARCHAR(256) DEFAULT NULL,
    CONSTRAINT COURSES_FK FOREIGN KEY (USER_OPERATOR) REFERENCES PEOPLE(ID)
);
CREATE TABLE INFOS_QOODOS(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    USERNAME VARCHAR(255) DEFAULT NULL,
    PASSWORD VARCHAR(255) DEFAULT NULL,
    DEVICE_ID VARCHAR(255) DEFAULT NULL,
    TOKEN VARCHAR(255) DEFAULT NULL,
    DATE_EXPIRATION  TIMESTAMP  DEFAULT NULL
);
CREATE TABLE BORNES(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME_BORNE VARCHAR(255) DEFAULT NULL,
    BLOCKED_BORNE SMALLINT DEFAULT 0 NOT NULL,
    ADDRESS_IP VARCHAR(256) DEFAULT NULL,
    PAYMENT_ENABLED SMALLINT DEFAULT 1 NOT NULL,
    EQUIPMENT_DISABLED SMALLINT DEFAULT 0 NOT NULL,
    ONSEAT_ENABLED SMALLINT DEFAULT 1 NOT NULL,
    IN_MAINTENANCE SMALLINT DEFAULT 0 NOT NULL
);

CREATE TABLE ENTETE_NOTE (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    num_doc VARCHAR(256) DEFAULT '1' NOT NULL,
    version_soft VARCHAR(256) DEFAULT '5.0.00' NOT NULL,
    nb_print INTEGER default 0,
    company VARCHAR(256) DEFAULT  NULL,
    address VARCHAR(256) DEFAULT  NULL,
    zip_code VARCHAR(256) DEFAULT  NULL,
    city VARCHAR(256) DEFAULT  NULL,
    country VARCHAR(256) DEFAULT  NULL,
    siret VARCHAR(256) DEFAULT  NULL,
    code_NAF VARCHAR(256) DEFAULT  NULL,
    num_tva VARCHAR(256) DEFAULT  NULL,
    code_operator VARCHAR(256) DEFAULT  NULL,
    name_operator VARCHAR(256) DEFAULT  NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    nb_customer INTEGER DEFAULT 1  NOT NULL,
    timestampGDH timestamp,
    type_operation VARCHAR(256) DEFAULT 'commande' NOT NULL,
    type_doc VARCHAR(256) DEFAULT 'commande' NOT NULL,
    nb_lines INTEGER,
    ticket VARCHAR(256) NOT NULL,
    header_Supplementaire VARCHAR(256) ,
    footer_Supplementaire VARCHAR(256) ,
    ticket_status VARCHAR(256) Default 'normal' ,
    signature_Ticket VARCHAR(2000) default null,
    horodatage VARCHAR(256) default NULL,
    code_remise SMALLINT DEFAULT 1,
    transient SMALLINT DEFAULT 1,
    total DOUBLE,
    tva5 DOUBLE,
    tva10 DOUBLE,
    tva20 DOUBLE,
    tva0 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    tva_7_7 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    tva_2_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    tva_2_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    tva_8_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NAME_SOFT VARCHAR(256) DEFAULT NULL,
    USE_ID_IN_SIGNATURE SMALLINT DEFAULT 1 NOT NULL,
    ROUND_AMOUNT SMALLINT DEFAULT 0 NOT NULL,
    tva_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    tva_12 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    tva_21 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    HAS_RECAP_TAX SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT ENTETE_NOTE_FK_TICKET FOREIGN KEY (ticket) REFERENCES TICKETS(ID)
);

CREATE TABLE COUNTER_USER(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_USER VARCHAR(256) NOT NULL,
    CONSTRAINT COUNTER_USER_FK FOREIGN KEY (ID_USER) REFERENCES PEOPLE(ID) ON DELETE CASCADE
);

CREATE TABLE SCREENS_SUPPLEMENT(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_SUPPLEMENT INTEGER,
    ID_SCREEN INTEGER DEFAULT NULL,
    NAME_SCREEN VARCHAR(255) DEFAULT NULL,
    REF_WEB VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT SCREENS_SUPPLEMENT_FK FOREIGN KEY (ID_SUPPLEMENT) REFERENCES supplement_item(id)
);
CREATE TABLE SCREENS_GROUP_SUPPLEMENT(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_GROUP_SUPPLEMENT INTEGER,
    ID_SCREEN INTEGER DEFAULT NULL,
    NAME_SCREEN VARCHAR(255) DEFAULT NULL,
    REF_WEB VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT SCREENS_GROUP_SUPPLEMENT_FK FOREIGN KEY (ID_GROUP_SUPPLEMENT) REFERENCES supplement(id)
);
CREATE TABLE SCREENS_PRODUCT(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_PRODUCT INTEGER,
    ID_SCREEN INTEGER DEFAULT NULL,
    IS_ID_UPDATED INTEGER DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT SCREENS_PRODUCT_FK FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID)
);
CREATE TABLE EMPLOYEES (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME_EMPLOYEE VARCHAR(1024) NOT NULL,
    PHONE varchar(255) DEFAULT NULL,
    CREDIT DOUBLE PRECISION DEFAULT 0,
    REMOVED SMALLINT DEFAULT 0 NOT NULL,
    EMAIL varchar(255) DEFAULT NULL,
    FUNCTION_EMPLOYEE varchar(255) DEFAULT NULL,
    CODE_CARTE varchar(255) DEFAULT NULL,
    FIXED_AMOUNT DOUBLE PRECISION DEFAULT 0,
    PRIMARY KEY (ID)
);
CREATE TABLE CREDIT_EMPLOYEE (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    AMOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DATE_PAYMENT timestamp,
    EMPLOYEE INTEGER NOT NULL,
    TICKET VARCHAR(256) NOT NULL,
    PAYMENT VARCHAR(256) NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT CREDIT_EMPLOYEE_FK1 FOREIGN KEY (EMPLOYEE) REFERENCES EMPLOYEES(ID),
    CONSTRAINT CREDIT_EMPLOYEE_FK2 FOREIGN KEY (TICKET) REFERENCES TICKETS(ID),
    CONSTRAINT CREDIT_EMPLOYEE_FK3 FOREIGN KEY (PAYMENT) REFERENCES PAYMENTS(ID)
);
CREATE TABLE RECHARGE_CREDIT_EMPLOYEE (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_MAJ TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID)
);
INSERT INTO RECHARGE_CREDIT_EMPLOYEE (DATE_MAJ) VALUES(CURRENT_TIMESTAMP);

CREATE TABLE TRANSACTION_MONEY(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    terminal VARCHAR(55),
    libelle VARCHAR(255) DEFAULT NULL,
    amount DOUBLE,
    timestampGDH timestamp,
    description VARCHAR(255) DEFAULT NULL,
    user_id VARCHAR(256) not NULL,
    PRIMARY KEY (ID),
    CONSTRAINT transaction_money_user_fk FOREIGN KEY (user_id) REFERENCES PEOPLE(ID)
); 
CREATE TABLE LOYALTYCARD (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    CODE_CARTE varchar(255) NOT NULL,
    CREDIT DOUBLE PRECISION DEFAULT 0,
    CUSTOMER INTEGER NOT NULL,
    NUMBER_USE INTEGER DEFAULT 0 NOT NULL,
    INITIALIZED_AT TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID),
    CONSTRAINT LOYALTYCARD_FK FOREIGN KEY (CUSTOMER) REFERENCES CUSTOMERS(ID)
);
CREATE TABLE CITIES (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME varchar(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE ZIPCODE (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME varchar(255) NOT NULL,
    IDCITY INTEGER NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT ZIPCODE_FK FOREIGN KEY (IDCITY) REFERENCES CITIES(ID)
);
CREATE TABLE SUPPLEMENT_ITEM_PRICES (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    TYPE_ORDER VARCHAR(255) DEFAULT  NULL,
    PRICE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_JUNIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_SENIOR DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_MEGA DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_SIZE1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_SIZE2 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_SIZE3 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    SUPPLEMENT_ID INTEGER NOT NULL,
    REF_SYNCHRO VARCHAR(255) DEFAULT NULL,
    PRICE_SIZE4 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_SIZE5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_SIZE6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE_SIZE7 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ID_GLOBAL varchar(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT SUPPLEMENT_ITEM_PRICES_FK1 FOREIGN KEY (SUPPLEMENT_ID) REFERENCES supplement_item(id)
);
CREATE TABLE REDUCTIONS (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    REDUCTION DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NAME varchar(255) DEFAULT NULL,
    TYPE varchar(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
INSERT INTO REDUCTIONS(REDUCTION, NAME, TYPE) VALUES(10, 'Réduction', 'pourcentage');
INSERT INTO REDUCTIONS(REDUCTION, NAME, TYPE) VALUES(20, 'Réduction', 'pourcentage');
INSERT INTO REDUCTIONS(REDUCTION, NAME, TYPE) VALUES(50, 'Réduction', 'pourcentage');
INSERT INTO REDUCTIONS(REDUCTION, NAME, TYPE) VALUES(100, 'Réduction', 'pourcentage');
INSERT INTO REDUCTIONS(REDUCTION, NAME, TYPE) VALUES(100, 'Offre employé', 'pourcentage');
INSERT INTO REDUCTIONS(REDUCTION, NAME, TYPE) VALUES(100, 'Carte de fidélité', 'pourcentage');
CREATE TABLE GROUPE_SUB_SUPPLEMENTS (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NAME_GROUP VARCHAR(255) DEFAULT NULL,
   TITLE_GROUP VARCHAR(255) DEFAULT NULL,
   REMOVED SMALLINT DEFAULT 0 NOT NULL,
   REF_SYNCHRO VARCHAR(255) DEFAULT NULL,
   HAS_LIMIT_OPTIONS SMALLINT DEFAULT 0 NOT NULL,
   MIN_OPTIONS INTEGER DEFAULT NULL,
   MAX_OPTIONS INTEGER DEFAULT NULL,
   OPTION_FREE INTEGER DEFAULT 0,
   ID_GLOBAL varchar(255) DEFAULT NULL,
   NUMBER_CLICK INTEGER DEFAULT 1,
   DATE_START_DISPLAY TIMESTAMP default null,
   DATE_END_DISPLAY TIMESTAMP default null,
   PRIMARY KEY (ID)
);
CREATE TABLE SUB_SUPPLEMENTS (
   ID_SUPPLEMENT INTEGER NOT NULL,
   ID_GROUPESUPPLEMENT INTEGER NOT NULL,
   PRIMARY KEY (ID_SUPPLEMENT, ID_GROUPESUPPLEMENT),
   CONSTRAINT SUB_SUPPELMENTS_FK_1 FOREIGN KEY (ID_SUPPLEMENT) REFERENCES supplement_item(id) ON DELETE CASCADE,
   CONSTRAINT SUB_SUPPELMENTS_FK_2 FOREIGN KEY (ID_GROUPESUPPLEMENT) REFERENCES GROUPE_SUB_SUPPLEMENTS(ID) ON DELETE CASCADE
);
CREATE TABLE SUPPLEMENTS_GROUPE (
   ID_SUPPLEMENT INTEGER NOT NULL,
   ID_GROUPESUPPLEMENT INTEGER NOT NULL,
   PRIMARY KEY (ID_SUPPLEMENT, ID_GROUPESUPPLEMENT),
   CONSTRAINT SUPPLEMENTS_GROUPE_FK_1 FOREIGN KEY (ID_SUPPLEMENT) REFERENCES supplement_item(id) ON DELETE CASCADE,
   CONSTRAINT SUPPLEMENTS_GROUPE_FK_2 FOREIGN KEY (ID_GROUPESUPPLEMENT) REFERENCES GROUPE_SUB_SUPPLEMENTS(ID) ON DELETE CASCADE
);
CREATE TABLE APPLICATION_LOGS (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   LAST_DELETE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
   PRIMARY KEY (ID)
);
CREATE TABLE TIMETABLE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DAY INTEGER NOT NULL,
   NAME_DAY VARCHAR(255) DEFAULT NULL,
   DAY_OFF SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);
CREATE TABLE WORKSHIFT(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   START_SHIFT VARCHAR(255) DEFAULT NULL,
   END_SHIFT VARCHAR(255) DEFAULT NULL,
   IDTIMETABLE INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT WORKSHIFT_FK FOREIGN KEY (IDTIMETABLE) REFERENCES TIMETABLE(ID)
);
CREATE TABLE ZONEDELIVERY(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   ZONE_NAME VARCHAR(255) DEFAULT NULL,
   MIN_TOTAL DOUBLE PRECISION DEFAULT 0,
   DELIVERY_COSTS DOUBLE PRECISION DEFAULT 0,
   PRIMARY KEY (ID)
);
CREATE TABLE CITYDELIVERY(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   CITY VARCHAR(255) DEFAULT NULL,
   ZIP_CODE VARCHAR(255) DEFAULT NULL,
   IDZONEDELIVERY INTEGER,
   PRIMARY KEY (ID)
);
CREATE TABLE ADDITIONAL_SALES(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   ID_PRODUCT INTEGER NOT NULL,
   ID_PRODUCT_PARENT INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT ADDITIONAL_SALES_FK_1 FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID) ON DELETE CASCADE,
   CONSTRAINT ADDITIONAL_SALES_FK_2 FOREIGN KEY (ID_PRODUCT_PARENT) REFERENCES PRODUCTS(ID) ON DELETE CASCADE
);
CREATE TABLE INFOS_UBER_EATS(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TOKEN_EATS_ORDERS VARCHAR(1024) DEFAULT NULL,
    TOKEN_ORDERS_READ VARCHAR(1024) DEFAULT NULL,
    STORE_ID VARCHAR(255) DEFAULT NULL,
    POS_INTEGRATION_ENABLED SMALLINT DEFAULT 0 NOT NULL,
    TOKEN_EATS_STORE VARCHAR(1024) DEFAULT NULL,
    TOKEN_EATS_STORE_CREATED_AT TIMESTAMP,
    TOKEN_EATS_STORE_WRITE_STATUS VARCHAR(1024) DEFAULT NULL,
    TOKEN_EATS_STORE_WRITE_STATUS_CREATED_AT TIMESTAMP,
    STATUS_STORE VARCHAR(255) DEFAULT NULL
);
CREATE TABLE PROMOTIONS(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NAME_PROMOTION VARCHAR(255) DEFAULT NULL,
   TYPE_ORDER VARCHAR(255) DEFAULT NULL,
   SIZE_PRODUCT VARCHAR(255) DEFAULT NULL,
   QUANTITY DOUBLE PRECISION DEFAULT 0 NOT NULL,
   DISCOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
   REMOVED SMALLINT DEFAULT 0 NOT NULL,
   REMOVED_BY_ADMIN SMALLINT DEFAULT 0 NOT NULL,
   REF_SYNCHRO VARCHAR(255) DEFAULT NULL,
   LABEL_SIZE_PRODUCT VARCHAR(255) DEFAULT NULL,
   LABEL_DISCOUNT VARCHAR(255) DEFAULT NULL,
   ID_GLOBAL varchar(255) DEFAULT NULL,
   DESCRIPTION VARCHAR(1024) DEFAULT NULL,
   TEXT_PROMOTION VARCHAR(255) DEFAULT NULL,
   DATE_START_DISPLAY TIMESTAMP default null,
   DATE_END_DISPLAY TIMESTAMP default null,
   PRIMARY KEY (ID)
);
CREATE TABLE PRODUCTS_PROMOTIONS (
   ID_PROMOTION INTEGER NOT NULL,
   ID_PRODUCT INTEGER NOT NULL,
   PRIMARY KEY (ID_PROMOTION, ID_PRODUCT),
   CONSTRAINT PRODUCTS_PROMOTIONS_FK1 FOREIGN KEY (ID_PROMOTION) REFERENCES PROMOTIONS(ID),
   CONSTRAINT PRODUCTS_PROMOTIONS_FK2 FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID) 
);
CREATE TABLE SUB_PRODUCTS(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   ID_PRODUCT INTEGER NOT NULL,
   ID_PRODUCT_PARENT INTEGER NOT NULL,
   NUMBER_EXEMPLARY INTEGER DEFAULT 1 NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT SUB_PRODUCTS_FK_1 FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID) ON DELETE CASCADE,
   CONSTRAINT SUB_PRODUCTS_FK_2 FOREIGN KEY (ID_PRODUCT_PARENT) REFERENCES PRODUCTS(ID) ON DELETE CASCADE
);
CREATE TABLE PRODUCT_DAYS_ON(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DAY_OF_WEEK INTEGER NOT NULL,
   ID_PRODUCT INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT PRODUCT_DAYS_ON_FK1 FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID) 
);
CREATE TABLE LOCAL_SCREENS(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NAME VARCHAR(255) DEFAULT NULL,
   NUMBER INTEGER DEFAULT 0 NOT NULL,
   DELETED SMALLINT DEFAULT 0 NOT NULL,
   ID_SYNCHRO INTEGER DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);
create table SETTINGS_BORNE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   SETTING_NAME VARCHAR(255) DEFAULT NULL,
   LAST_UPDATE BIGINT,
   PRIMARY KEY (ID)
);
create table INFO_LICENCE_GENERATED(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   LICENCE_ID BIGINT,
   ACTIVATION_ID BIGINT,
   PRIMARY KEY (ID)
);
CREATE TABLE JUSTIFICATIF_PAIEMENT (
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NUM_DOC INTEGER default 0 not null,
    HORODATAGE VARCHAR(256) default NULL,
    TICKET VARCHAR(256) NOT NULL,
    TIMESTAMPGDH timestamp,
    TOTAL DOUBLE PRECISION,
    SIGNATURE VARCHAR(2000) default null,
    REF_TICKET INTEGER default 0 not null,
    ROUND_AMOUNT SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT JUSTIFICATIF_PAIEMENT_FK_TICKET FOREIGN KEY (TICKET) REFERENCES TICKETS(ID)
);
CREATE TABLE DUPLICATA_JUSTIFICATIF_PAIEMENT(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    TYPE_DOCUMENT VARCHAR(256) DEFAULT NULL,
    IMPRESSION_NUMBER INTEGER,
    CODE_USER VARCHAR(256) DEFAULT NULL,
    DATE_IMPRESSION TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    NUM_JUSTIFICATIF_PAIEMENT INTEGER default 0 not null,
    MOTIF_IMPRESSION VARCHAR(1024) default NULL,
    HORODATAGE VARCHAR(256) default NULL,
    SIGNATURE VARCHAR(2000),
    version_soft VARCHAR(256) DEFAULT NULL,
    CONSTRAINT DUPLICATA_JUSTIFICATIF_PAIEMENT_USER_FK_1 FOREIGN KEY (CODE_USER) REFERENCES PEOPLE(ID),
    CONSTRAINT DUPLICATA_JUSTIFICATIF_PAIEMENT_FK_2 FOREIGN KEY (NUM_JUSTIFICATIF_PAIEMENT) REFERENCES JUSTIFICATIF_PAIEMENT(ID),
    PRIMARY KEY (ID)
);
create table PROMO_CODES(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   PROMO_CODE VARCHAR(255) DEFAULT NULL,
   TYPE VARCHAR(255) DEFAULT NULL,
   AMOUNT DOUBLE PRECISION DEFAULT 0,
   DATE_START TIMESTAMP DEFAULT NULL,
   DATE_END TIMESTAMP DEFAULT NULL,
   DELIVERY SMALLINT DEFAULT 0 NOT NULL,
   TAKE_AWAY SMALLINT DEFAULT 0 NOT NULL,
   AT_SPOT SMALLINT DEFAULT 0 NOT NULL,
   DRIVE SMALLINT DEFAULT 0 NOT NULL,
   LAST_UPDATE TIMESTAMP DEFAULT NULL,
   ID_SOURCE INTEGER NOT NULL DEFAULT 0,
   PRIMARY KEY (ID)
);
CREATE TABLE LINES_NOTE(
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    ref_note INTEGER,
    num_line INTEGER,
    code_product VARCHAR(256),
    origin_data VARCHAR(256) DEFAULT 'IN' NOT NULL,
    descriptive_product VARCHAR(256),
    price_TTC  DOUBLE PRECISION,
    total_ttc DOUBLE PRECISION,
    type_operation VARCHAR(256) DEFAULT 'Vente' NOT NULL,
    timestampGDH timestamp,
    centre_profit VARCHAR(256) DEFAULT 'N/A' NOT NULL,
    code_caisse VARCHAR(256) DEFAULT '1' NOT NULL,
    code_operator VARCHAR(256) DEFAULT '1' NOT NULL,
    quantite DOUBLE PRECISION,
    horodatage VARCHAR(256) default NULL,
    discount  DOUBLE PRECISION,
    taux_discount DOUBLE PRECISION,
    CODE_TAX VARCHAR(256),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_HT DOUBLE PRECISION,
    PRIMARY KEY (id)
);
CREATE TABLE PUBLICATION_BORNE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   PUBLICATION_TYPE VARCHAR(255) DEFAULT NULL,
   LAST_UPDATE BIGINT,
   START_DATE BIGINT,
   END_DATE BIGINT,
   CREATEDAT BIGINT,
   PUBLICATION_NAME VARCHAR(255) DEFAULT NULL,
   EXPIRED SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);

CREATE TABLE UBEREAT_TIMETABLE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NAME_DAY VARCHAR(255) DEFAULT NULL,
   START_SHIFT VARCHAR(255) DEFAULT NULL,
   END_SHIFT VARCHAR(255) DEFAULT NULL,
   DAY_OFF SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);
CREATE TABLE PRODUCTS_PRICES (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    PRICE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TYPE_ORDER VARCHAR(255) DEFAULT NULL,
    TARIFF INTEGER DEFAULT 1,
    PRODUCT INTEGER NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT PRODUCTS_PRICES_FK1 FOREIGN KEY (product) REFERENCES PRODUCTS(ID)
);
CREATE TABLE TARIFFS(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NUMBER INTEGER DEFAULT 0 NOT NULL,
   DELETED SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);
create table SETTINGS(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   SETTING_NAME VARCHAR(255) DEFAULT NULL,
   LAST_UPDATE BIGINT,
   PRIMARY KEY (ID)
);
CREATE TABLE UBEREAT_WORKSHIFT(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   START_SHIFT VARCHAR(255) DEFAULT NULL,
   END_SHIFT VARCHAR(255) DEFAULT NULL,
   IDTIMETABLE INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT UBEREAT_WORKSHIFT_FK FOREIGN KEY (IDTIMETABLE) REFERENCES UBEREAT_TIMETABLE(ID)
);
CREATE TABLE Z_GLOBAL(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    ID_PERIODE VARCHAR(255) DEFAULT NULL,
    CREATED timestamp,
    TYPE_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    TOTAL DOUBLE PRECISION,
    TVA_5_5 DOUBLE PRECISION,
    TVA_10 DOUBLE PRECISION,
    TVA_20 DOUBLE PRECISION,
    TVA_0 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_7_7 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_5 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_5_5_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_10_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_20_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_0_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_7_7_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_5_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_1_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_5_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CASH_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CB_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TR_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DEBIT_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CREDIT_EMPLOYEE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    LOYALTY_CARD DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CASHDRO_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CACH_GLORY_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    VIRMENT_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CHEQUE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    AVOIR_DECAISSE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    AVOIR_ENCAISSE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TWINT_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CHEQUE_VACANCES_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_AT_SPOT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_TAKE_AWAY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DELIVERY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_UBER DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DELIVERO DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_JUST_EAT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DRIVE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_SMOOD DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_ORDERS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_CB DOUBLE PRECISION  DEFAULT 0 NOT NULL,
    NUMBER_TR DOUBLE PRECISION  DEFAULT 0 NOT NULL,
    NUMBER_PRODUCTS_SOLD DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TURNOVER_CANCELED DOUBLE  DEFAULT 0 NOT NULL,
    TOTAL_DISCOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_DISCOUNT_LINES DOUBLE PRECISION DEFAULT 0 NOT NULL,
    SOURCE_PERIODE VARCHAR(255) DEFAULT NULL,
    HOST_NAME VARCHAR(255) DEFAULT NULL,
    ADDRESS_IP VARCHAR(255) DEFAULT NULL,
    TURNOVER_PLATFORM DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DISHOP DOUBLE PRECISION DEFAULT 0 NOT NULL,
    STRIPE_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_ORDERS_DELIVEROO DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_12 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_21 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_6_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_12_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_21_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TPS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVQ DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CREDIT_CARD_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DEBIT_CARD_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TURNOVER_UBEREAT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_1 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_6 DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_8_1_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVA_2_6_HT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_TAXABLE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_NO_TAXABLE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CASH_LOGY_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_AT_SPOT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_TAKE_AWAY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_DELIVERY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TOTAL_HT_ORDERS_DRIVE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_AT_SPOT INTEGER DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_TAKE_AWAY INTEGER DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_DELIVERY INTEGER DEFAULT 0 NOT NULL,
    NUMBER_ORDERS_DRIVE INTEGER DEFAULT 0 NOT NULL,
    CARTE_TR_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    BANK_TRANSFER_TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_CARTE_TR INTEGER  DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE TAGS(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NAME VARCHAR(255) DEFAULT NULL,
   NUMBER INTEGER DEFAULT 0 NOT NULL,
   DELETED SMALLINT DEFAULT 0 NOT NULL,
   LOGO_TAG VARCHAR(255) DEFAULT NULL,
   BACKGROUND_CATALOG VARCHAR(255) DEFAULT NULL,
   ENABLED SMALLINT DEFAULT 1 NOT NULL,
   CLOSED SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);
CREATE TABLE TAGS_CATEGORIES(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_CATEGORY INTEGER,
    ID_TAG INTEGER DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT TAGS_CATEGORIES_FK FOREIGN KEY (ID_CATEGORY) REFERENCES CATEGORIES(ID)
);
CREATE TABLE INFOS_RUSHOUR(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    STORE_ID VARCHAR(255) DEFAULT NULL
);
CREATE TABLE OTTER(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    TOKEN VARCHAR(1024) DEFAULT NULL,
    STORE_ID VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE DELIVEROO(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    BRAND_ID VARCHAR(255) DEFAULT NULL,
    LOCATION_ID VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE PERTE_MARCHANDISE(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    CAISSIER VARCHAR(255) DEFAULT NULL,
    RAISON VARCHAR(1024) DEFAULT NULL,
    CREATEDAT TIMESTAMP DEFAULT NULL,
    DELETED SMALLINT DEFAULT 0 NOT NULL,
    TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID)
   
);
CREATE TABLE LIGNES_PERTE_MARCHANDISE(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    PRODUCT_NAME VARCHAR(255) DEFAULT NULL,
    CATEGORY_NAME VARCHAR(255) DEFAULT NULL,
    NUMBER_ITEMS INTEGER DEFAULT 0,
    CREATEDAT TIMESTAMP DEFAULT NULL,
    DELETED SMALLINT DEFAULT 0 NOT NULL,
    TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PERTENTITY INTEGER NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT LIGNES_PERTE_MARCHANDISE_FK FOREIGN KEY (PERTENTITY) REFERENCES PERTE_MARCHANDISE(ID)
);

CREATE TABLE MONEY_MOUVEMENT(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    CAISSIER VARCHAR(255) DEFAULT NULL,
    SCREEN_TYPE VARCHAR(255) DEFAULT NULL,
    RAISON VARCHAR(1024) DEFAULT NULL,
    CREATEDAT TIMESTAMP DEFAULT NULL,
    DELETED SMALLINT DEFAULT 0 NOT NULL,
    TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE INFOS_DISHOP(
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    LOCATION_ID VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);

CREATE TABLE DELIVEROO_TIMETABLE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DAY INTEGER,
   DAY_OFF SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID)
);
CREATE TABLE DELIVEROO_WORKSHIFT(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   START_SHIFT VARCHAR(255) DEFAULT NULL,
   END_SHIFT VARCHAR(255) DEFAULT NULL,
   IDTIMETABLE INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT DELIVEROO_WORKSHIFT_FK FOREIGN KEY (IDTIMETABLE) REFERENCES DELIVEROO_TIMETABLE(ID)
);


CREATE TABLE TRANSACTIONS_MEV(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TYPE_TRANSACTION VARCHAR(255) DEFAULT NULL,
    DATE_TRANSACTION TIMESTAMP DEFAULT NULL,
    LOCAL_ID VARCHAR(255) DEFAULT NULL,
    TOTAL DOUBLE PRECISION DEFAULT 0 NOT NULL,
    SIGNATURE VARCHAR(2000) DEFAULT NULL,
    MODE_PRINT VARCHAR(255) DEFAULT NULL,
    FORM_PRINT VARCHAR(255) DEFAULT NULL,
    STATUS VARCHAR(255) DEFAULT NULL,
    TOTAL_BEFORE_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL,
    TOTAL_AFTER_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TIP INTEGER DEFAULT 0 NOT NULL,
    DISCOUNT_AFTER_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TYPE_OPERATION VARCHAR(255) DEFAULT NULL,
    ADJUSTMENT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    MTDU DOUBLE PRECISION DEFAULT 0 NOT NULL,
    CERTIFICATE_THUMB_PRINT VARCHAR(1024) DEFAULT NULL,
    TPS DOUBLE PRECISION DEFAULT 0 NOT NULL,
    TVQ DOUBLE PRECISION DEFAULT 0 NOT NULL,
    USER_NAME VARCHAR(255) DEFAULT NULL,
    MODE_PAYMENT VARCHAR(255) DEFAULT NULL,
    DATE_SIGNATURE TIMESTAMP DEFAULT NULL,
    DATE_MEV_TRANSACTION TIMESTAMP DEFAULT NULL,
    NUMBER_MEV_TRANSACTION VARCHAR(255) DEFAULT NULL,
    COPIED SMALLINT DEFAULT 0 NOT NULL,
    OFFLINE_MESSAGE VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE TRANSACTION_LINES_DELETETED(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    PRODUCT_NAME VARCHAR(255) DEFAULT NULL,
    PRODUCT_ID INTEGER DEFAULT 0,
    QUANTITY DOUBLE DEFAULT 0,
    PRICE DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DISCOUNT DOUBLE DEFAULT 0,
    LABEL_DISCOUNT VARCHAR(255) DEFAULT NULL,
    TRANSACTION_ID INTEGER DEFAULT 0,
    PRIMARY KEY (ID),
    CONSTRAINT TRANSACTION_LINES_FK FOREIGN KEY (TRANSACTION_ID) REFERENCES TRANSACTIONS_MEV(ID)
);
CREATE TABLE RECAP_TAX_NOTE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    CODE_TAX VARCHAR(256),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    REF_NOTE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT TAX_FK_NOTE FOREIGN KEY (REF_NOTE) REFERENCES ENTETE_NOTE(ID)
);
CREATE TABLE RECAP_GENERAL_NOTE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TOTAL_DISCOUNT DOUBLE PRECISION,
    REF_NOTE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT RECAP_GENERAL_FK_NOTE FOREIGN KEY (REF_NOTE) REFERENCES ENTETE_NOTE(ID)
);
CREATE TABLE LINES_FACTURE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    ORIGIN_DATA VARCHAR(256) DEFAULT 'IN' NOT NULL,
    NUM_LINE INTEGER,
    CODE_PRODUCT VARCHAR(256),
    LABEL_PRODUCT VARCHAR(256),
    QUANTITY DOUBLE PRECISION,
    PRICE_HT DOUBLE PRECISION,
    TAUX_DISCOUNT DOUBLE PRECISION,
    TOTAL_HT_DISCOUNTED  DOUBLE PRECISION,
    TOTAL_HT DOUBLE PRECISION,
    CODE_TAX VARCHAR(256),
    RATE_TAX DOUBLE PRECISION ,
    PRICE_TTC  DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    timestampGDH timestamp,
    horodatage VARCHAR(256) default NULL,
    REF_FACTURE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT LINE_KF_FACTURE FOREIGN KEY (REF_FACTURE) REFERENCES FACTURE(ID)
);
CREATE TABLE RECAP_TAX_FACTURE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    CODE_TAX VARCHAR(256),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    REF_FACTURE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT RECAP_TAX_FK_FACTURE FOREIGN KEY (REF_FACTURE) REFERENCES FACTURE(ID)
);
CREATE TABLE RECAP_GENERAL_FACTURE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_DISCOUNT DOUBLE PRECISION,
    REF_FACTURE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT RECAP_GENERAL_FK_TICKET FOREIGN KEY (REF_FACTURE) REFERENCES FACTURE(ID)
);
CREATE TABLE SecurityCheck (
    id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    lastValidationDateCrypted VARCHAR(1024) DEFAULT NULL,
    isTemporaryPasswordUsed BOOLEAN,
    temporary_use_period integer DEFAULT 0,
    lastVerificationCodeDateCrypted VARCHAR(1024) DEFAULT NULL,
    unlock_period integer DEFAULT 0
);
CREATE TABLE INFOS_CLOVER(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_CLOVER_DEVICE VARCHAR(255) DEFAULT NULL,
    TOKEN VARCHAR(255) DEFAULT NULL,
    IP_ADDRESS_CLOVER_DEVICE VARCHAR(255) DEFAULT NULL,
    ID_MERCHANT_CLOVER VARCHAR(255) DEFAULT NULL,
    CODE_AUTHORIZATION VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE TRANSACTIONS_CLOVER(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    TRANSACTION_NAME VARCHAR(255) DEFAULT NULL,
    IDEMPOTENCY_KEY VARCHAR(255) DEFAULT NULL,
    EXTERNAL_ID VARCHAR(255) DEFAULT NULL,
    PAYMENT_ID VARCHAR(255) DEFAULT NULL,
    AMOUNT DOUBLE PRECISION DEFAULT 0 NOT NULL,
    ADDITIONAL_DATA VARCHAR(255) DEFAULT NULL,
    DELIVERY_METHOD VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE CATEGORY_DAYS_ON (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DAY_OF_WEEK INTEGER NOT NULL,
   ID_CATEGORY INTEGER NOT NULL,
   STATUS SMALLINT DEFAULT 0 NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT CATEGORY_DAYS_ON_FK1 FOREIGN KEY (ID_CATEGORY) REFERENCES CATEGORIES(ID)
);
CREATE TABLE SHIFT_CATEGORY (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DATE_START VARCHAR(256) NOT NULL,
   DATE_END VARCHAR(256) NOT NULL,
   idCategory INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT SHIFT_CATEGORY_FK1 FOREIGN KEY (idCategory) REFERENCES CATEGORIES(ID)
);
CREATE TABLE SHIFT_PRODUCT (
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   DATE_START VARCHAR(256) NOT NULL,
   DATE_END VARCHAR(256) NOT NULL,
   idproduct INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT SHIFT_PRODUCT_FK1 FOREIGN KEY (idproduct) REFERENCES PRODUCTS(ID)
);
CREATE TABLE FILES_CHANGE_INFO(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    LAST_UPDATE TIMESTAMP DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE GTP_TAXES(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    ID_PERIOD VARCHAR(256),
    CODE_TAX VARCHAR(255),
    NAME VARCHAR(255),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TAXE_GLOBAL SMALLINT DEFAULT 0 NOT NULL,
    type_periode VARCHAR(256),
    PRIMARY KEY (id),
    CONSTRAINT GTP_TAXES_FK FOREIGN KEY (ID_PERIOD) REFERENCES GRAND_TOTAL_PERIODE(ID)
);
CREATE TABLE Z_GLOBAL_TAXES(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    ID_Z_GLOBAL INTEGER,
    CODE_TAX VARCHAR(255),
    NAME VARCHAR(255),
    RATE_TAX DOUBLE PRECISION,
    TOTAL_HT DOUBLE PRECISION,
    TOTAL_TAX DOUBLE PRECISION,
    TOTAL_TTC DOUBLE PRECISION,
    TAXE_GLOBAL SMALLINT DEFAULT 0 NOT NULL,
    ID_PERIODE VARCHAR(255) DEFAULT NULL,
    TYPE_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,
    ADDRESS_IP VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (id),
    CONSTRAINT Z_GLOBAL_TAXES_FK FOREIGN KEY (ID_Z_GLOBAL) REFERENCES Z_GLOBAL(ID)
);
CREATE TABLE IMAGES_PRODUCTS(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME VARCHAR(255) DEFAULT NULL,
    PATH VARCHAR(255) DEFAULT NULL,
    URL VARCHAR(1024) DEFAULT NULL,
    GRAPHIC_TYPE VARCHAR(255) DEFAULT NULL,
    ID_PRODUCT INTEGER,
    PRIMARY KEY (id),
    CONSTRAINT IMAGES_PRODUCTS_FK FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID)
);
CREATE TABLE CARTE_INFO(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    LAST_UPDATE TIMESTAMP DEFAULT NULL,
    FIRST_MENU_DOWNLOADED SMALLINT DEFAULT 0 NOT NULL,
    LOCAL_LAST_UPDATE TIMESTAMP DEFAULT NULL,
    LOCAL_LAST_UPLOAD TIMESTAMP DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE LANGUAGES(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    CODE_LANGUAGE VARCHAR(255),
    LABEL_LANGUAGE VARCHAR(255),
    ENABLED SMALLINT DEFAULT 0 NOT NULL,
    DEFAULT_LANGUAGE SMALLINT DEFAULT 0 NOT NULL,
    PRIMARY KEY (ID)
);
INSERT INTO LANGUAGES(CODE_LANGUAGE, LABEL_LANGUAGE, ENABLED) VALUES ('fr', 'Français', 0);
INSERT INTO LANGUAGES(CODE_LANGUAGE, LABEL_LANGUAGE, ENABLED) VALUES ('en', 'Anglais', 0);
INSERT INTO LANGUAGES(CODE_LANGUAGE, LABEL_LANGUAGE, ENABLED) VALUES ( 'es','Espanol', 0);
INSERT INTO LANGUAGES(CODE_LANGUAGE, LABEL_LANGUAGE, ENABLED) VALUES ( 'ar', 'Arabic',0);
CREATE TABLE MULTILANGUAGE_PRODUCT(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    DESCRIPTION VARCHAR(1024),
    DESCRIPTION_PLATFORM VARCHAR(1024),
    ID_PRODUCT INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_PRODUCTS_FK FOREIGN KEY (ID_PRODUCT) REFERENCES PRODUCTS(ID)
);
CREATE TABLE MULTILANGUAGE_CATEGORY(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_CATEGORY INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_CATEGORY_FK FOREIGN KEY (ID_CATEGORY) REFERENCES CATEGORIES(ID)
);
CREATE TABLE MULTILANGUAGE_SUPPLEMENT(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_SUPPLEMENT INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_SUPPLEMENT_FK FOREIGN KEY (ID_SUPPLEMENT) REFERENCES supplement(id)
);
CREATE TABLE MULTILANGUAGE_SUPPLEMENT_ITEM(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_SUPPLEMENT_ITEM INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_SUPPLEMENT_ITEM_FK FOREIGN KEY (ID_SUPPLEMENT_ITEM) REFERENCES supplement_item(id)
);
CREATE TABLE MULTILANGUAGE_CARTE(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    ID_CARTE INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_CARTE_FK FOREIGN KEY (ID_CARTE) REFERENCES carte(id)
);
CREATE TABLE MULTILANGUAGE_PROMOTION(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    LANGUAGE VARCHAR(255),
    TEXT_PROMO VARCHAR(255),
    DESCRIPTION VARCHAR(1024),
    ID_PROMOTION INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_PROMOTION_FK FOREIGN KEY (ID_PROMOTION) REFERENCES PROMOTIONS(ID)
);
CREATE TABLE MULTILANGUAGE_GROUPE_SUB_SUPPLEMENTS(
    ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
    NAME VARCHAR(255),
    TITLE VARCHAR(255),
    LANGUAGE VARCHAR(255),
    TITLE_GROUP VARCHAR(255),
    ID_GROUPE_SUB_SUPPLEMENTS INTEGER,
    PRIMARY KEY (ID),
    CONSTRAINT MULTI_LANGUAGE_GROUPE_SUB_SUPPLEMENTS_FK FOREIGN KEY (ID_GROUPE_SUB_SUPPLEMENTS) REFERENCES GROUPE_SUB_SUPPLEMENTS(ID)
);
CREATE TABLE BlockingCheck (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    BLOCKING_DATE_CRYPTED VARCHAR(1024) DEFAULT NULL,
    BLOCKED BOOLEAN,
    TO_BE_BLOCKED BOOLEAN
);
CREATE TABLE TYPE_ORDER_TIMETABLE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NAME_DAY VARCHAR(255) DEFAULT NULL,
   DAY_OFF SMALLINT DEFAULT 0 NOT NULL,
   TYPE_ORDER VARCHAR(255) NOT NULL, 
   PRIMARY KEY (ID)
);
CREATE TABLE TYPE_ORDER_WORKSHIFT(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   START_SHIFT VARCHAR(255) DEFAULT NULL,
   END_SHIFT VARCHAR(255) DEFAULT NULL,
   IDTIMETABLE INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT TYPE_ORDER_WORKSHIFT_FK FOREIGN KEY (IDTIMETABLE) REFERENCES TYPE_ORDER_TIMETABLE(ID)
);
CREATE TABLE MARQUES (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ACCOUNT_ID VARCHAR(255) DEFAULT NULL,
    NAME VARCHAR(255) DEFAULT NULL,
    NUMBER INTEGER DEFAULT 0 NOT NULL,
    DELETED SMALLINT DEFAULT 0 NOT NULL
);
CREATE TABLE TAGS_TIMETABLE(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   NAME_DAY VARCHAR(255) DEFAULT NULL,
   DAY_OFF SMALLINT DEFAULT 0 NOT NULL,
   TAGS INTEGER DEFAULT 0, 
   PRIMARY KEY (ID)
);
CREATE TABLE TAGS_WORKSHIFT(
   ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
   START_SHIFT VARCHAR(255) DEFAULT NULL,
   END_SHIFT VARCHAR(255) DEFAULT NULL,
   IDTIMETABLE INTEGER NOT NULL,
   PRIMARY KEY (ID),
   CONSTRAINT TAGS_WORKSHIFT_FK FOREIGN KEY (IDTIMETABLE) REFERENCES TAGS_TIMETABLE(ID)
);
CREATE TABLE INFOS_AVOMARK(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    USERNAME VARCHAR(255) DEFAULT NULL,
    PASSWORD VARCHAR(255) DEFAULT NULL,
    DEVICE_ID INTEGER DEFAULT 0,
    TOKEN VARCHAR(255) DEFAULT NULL
);
CREATE TABLE COMMENTS_LINES_ORDER (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    COMMENT VARCHAR(1024) DEFAULT NULL
);
CREATE TABLE REFS_TRANSACTION(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_TRANSACTION TIMESTAMP DEFAULT NULL,
    TOTAL_BEFORE_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL,
    TOTAL_AFTER_TAX DOUBLE PRECISION DEFAULT 0 NOT NULL,
    REF_TRANSACTION_ID INTEGER DEFAULT 0,
    TRANSACTION_ID INTEGER DEFAULT 0,
    PRIMARY KEY (ID),
    CONSTRAINT REF_TRANSACTION_FK FOREIGN KEY (TRANSACTION_ID) REFERENCES TRANSACTIONS_MEV(ID)
);
CREATE TABLE CONFIGURATION_MEV(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    KEY_CONFIG VARCHAR(255) DEFAULT NULL,
    VALUE_CONFIG VARCHAR(1024) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE ITEM_PRECISIONS(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    PRECISION_NAME VARCHAR(255) DEFAULT NULL,
    QUANTITY DOUBLE PRECISION DEFAULT 0 NOT NULL,
    PRICE DOUBLE DEFAULT 0 NOT NULL,
    ITEM_ID INTEGER DEFAULT 0,
    PRECISION_TYPE VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT ITEM_PRECISION_FK FOREIGN KEY (ITEM_ID) REFERENCES TRANSACTION_LINES_DELETETED(ID)
);
CREATE TABLE SALES_SUMMARY(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME_USER VARCHAR(255) DEFAULT NULL,
    NUMBER_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    NUMBER_MEV_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    TOTAL_AFTER_TAX_LAST_TRANSACTION_PRINTED DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DATE_LAST_TRANSACTION_PRINTED timestamp,
    DATE_MEV_LAST_TRANSACTION_PRINTED timestamp,
    YEAR_TRANSACTIONS VARCHAR(255) DEFAULT NULL,
    NUMBER_TOTAL_TRANSACTIONS INTEGER DEFAULT 0,
    NUMBER_TRANSACTIONS_PAYMENTS INTEGER DEFAULT 0,
    TOTAL_BEFORE_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TPS DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TVQ DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_AFTER_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_ADJUSTMENT DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_MTDU DOUBLE DEFAULT 0 NOT NULL,
    DEVICE_ID VARCHAR(255) DEFAULT NULL,
    OFFLINE_MESSAGE_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE USER_REPORT(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NO_TPS VARCHAR(255) DEFAULT NULL,
    NO_TVQ VARCHAR(255) DEFAULT NULL,
    NAME_USER VARCHAR(255) DEFAULT NULL,
    NUMBER_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    NUMBER_MEV_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    TOTAL_AFTER_TAX_LAST_TRANSACTION_PRINTED DOUBLE PRECISION DEFAULT 0 NOT NULL,
    DATE_LAST_TRANSACTION_PRINTED timestamp,
    DATE_MEV_LAST_TRANSACTION_PRINTED timestamp,
    YEAR_REPORT VARCHAR(255) DEFAULT NULL,
    NUMBER_TOTAL_TRANSACTIONS INTEGER DEFAULT 0,
    NUMBER_TRANSACTIONS_PAYMENTS INTEGER DEFAULT 0,
    TOTAL_BEFORE_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TPS DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_TVQ DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_AFTER_TAX DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_ADJUSTMENT DOUBLE DEFAULT 0 NOT NULL,
    TOTAL_MTDU DOUBLE DEFAULT 0 NOT NULL,
    SOURCE_REPORT VARCHAR(255) DEFAULT NULL,
    DEVICE_OR_BILLING_ID VARCHAR(255) DEFAULT NULL,
    USER_SCOPE VARCHAR(255) DEFAULT NULL,
    DEVICE_ID VARCHAR(255) DEFAULT NULL,
    ID_SEV VARCHAR(255) DEFAULT NULL,
    VERSION_SEV VARCHAR(255) DEFAULT NULL,
    USER_LOGIN_TIME timestamp,
    CREATED_AT timestamp,
    SIGNATURE VARCHAR(255) DEFAULT NULL,
    CERTIFICATE_THUMB_PRINT VARCHAR(255) DEFAULT NULL,
    RESTAURANT_ADDRESS VARCHAR(255) DEFAULT NULL,
    RESTAURANT_NAME VARCHAR(255) DEFAULT NULL,
    OFFLINE_MESSAGE_LAST_TRANSACTION_PRINTED VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE OFFLINE_MODE_JOURNAL(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_OFFLINE_EVENT timestamp,
    ID_USER_CONNECTED_IN_OFFLINE_EVENT VARCHAR(255) DEFAULT NULL,
    NAME_USER_CONNECTED_IN_OFFLINE_EVENT VARCHAR(255) DEFAULT NULL,
    DATE_ONLINE_EVENT timestamp,
    ID_USER_CONNECTED_IN_ONLINE_EVENT VARCHAR(255) DEFAULT NULL,
    NAME_USER_CONNECTED_IN_ONLINE_EVENT VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE ERRORS_MEV_WEB(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    ID_ERROR VARCHAR(255) DEFAULT NULL,
    MESSAGE VARCHAR(1024) DEFAULT NULL,
    CODE_RETOUR VARCHAR(255) DEFAULT NULL,
    CREATED_AT timestamp,
    TYPE_REQUEST VARCHAR(255) DEFAULT NULL,
    NUMBER_TRANSACTION VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE LOGS_DATA_MEV(
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    DATE_OPERATION timestamp,
    ID_USER VARCHAR(255) DEFAULT NULL,
    NAME_USER VARCHAR(255) DEFAULT NULL,
    NAME_OPERATION VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE Nutritional (
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    
    -- energie
    energy_kcal_value DOUBLE,
    energy_kcal_daily_percentage DOUBLE,
    
    -- Fibres
    fiber_g_value DOUBLE,
    fiber_g_daily_percentage DOUBLE,
    
    -- Lipides
    fat_g_value DOUBLE,
    fat_saturated_g DOUBLE,
    fat_g_daily_percentage DOUBLE,
    
    -- Glucides
    carbs_g_value DOUBLE,
    sugar_g DOUBLE,
    carbs_g_daily_percentage DOUBLE,
    
    -- Proteines
    protein_g_value DOUBLE,
    protein_g_daily_percentage DOUBLE,
    
    -- Sel
    salt_g_value DOUBLE,
    salt_g_daily_percentage DOUBLE,

    -- Image et couleur (supposees communes)
    image_path VARCHAR(255),
    color VARCHAR(20),
    idProductNutri INTEGER NOT NULL,
    
    -- Foreign key with a unique constraint name
    CONSTRAINT Nutritional_FK1 FOREIGN KEY (idProductNutri) REFERENCES PRODUCTS(ID)
);
CREATE TABLE NUTRIENT_DATA (
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    IMAGE VARCHAR(255),
    COLOR VARCHAR(100),
    NUTRIENT VARCHAR(100)
);
CREATE TABLE ALLERGENE (
    NAME VARCHAR(255),
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    idProductAllergene INTEGER NOT NULL,
    CONSTRAINT ALLERGENE_FK1 FOREIGN KEY (idProductAllergene) REFERENCES PRODUCTS(ID)
);
CREATE TABLE ALLERGENE_SUPPLEMENT (
    NAME VARCHAR(255),
    ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    ID_SUPPLEMENT INTEGER NOT NULL,
    CONSTRAINT ALLERGENE_SUPPLEMENT_ITEM_FK FOREIGN KEY (ID_SUPPLEMENT) REFERENCES supplement_item(id)
);

CREATE TABLE TAGS_SETTINGS (
    ID INTEGER UNIQUE NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    SETTING_NAME VARCHAR(255) NOT NULL,
    SETTING_VALUE VARCHAR(255) DEFAULT NULL,
    SETTING_READABLE_NAME VARCHAR(255) NOT NULL,
    TAG_ID INTEGER NOT NULL,
    CONSTRAINT TAG_ID_FK FOREIGN KEY (TAG_ID) REFERENCES TAGS(ID)
);
CREATE TABLE HEYPONGO (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    TOKEN VARCHAR(1024) DEFAULT NULL,
    TOKEN_TYPE  VARCHAR(1024) DEFAULT NULL,
    SCOPE VARCHAR(1024) DEFAULT NULL,
    PRIMARY KEY (ID)
);
CREATE TABLE CURRENCY (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    CODE VARCHAR(255) DEFAULT NULL,       
    SYMBOL VARCHAR(255) DEFAULT NULL,           
    LABEL VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (ID)      
);
CREATE TABLE BANKNOTES (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    CURRENCY_ID INTEGER NOT NULL,   
    VALUE DOUBLE DEFAULT 0 NOT NULL,           
    IS_ACTIVE SMALLINT DEFAULT 1 NOT NULL,   
    CONSTRAINT BANKNOTES_FK FOREIGN KEY (CURRENCY_ID) REFERENCES CURRENCY(ID)
);
insert into TARIFFS(NUMBER) values(1);
insert into TARIFFS(NUMBER) values(2);
insert into TARIFFS(NUMBER) values(3);
INSERT INTO PRINTER(NAME, NAME_PRINTER, TYPE, IP, WITH_TICKET, NUMBER_TICKET, typePrinter, NUMBER_PRINTER) VALUES('imprimante caisse', null, null, null, 0, 1, 'caisse', 1);
INSERT INTO ORDER_NUMBER(ordernumber) VALUES(1);
INSERT INTO caisse(FOND_CAISSE, token) VALUES(1000, $token{});
INSERT INTO supplement(name, min_options, max_options, is_ingredient, default_category) VALUES('Ingredients', 0, 0, 1, 1);
CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.connection.requireAuthentication', 'true');
CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.authentication.provider', 'BUILTIN');
CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user.APP','protactilepa42');
CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.database.fullAccessUsers','APP');
CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.database.propertiesOnly', 'true');
INSERT INTO APPLICATIONS(ID, NAME, VERSION) VALUES($APP_ID{}, $APP_NAME{}, $APP_VERSION{});
