/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places.exception;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import se.walkercrou.places.exception.InvalidRequestException;
import se.walkercrou.places.exception.NoResultsFoundException;
import se.walkercrou.places.exception.OverQueryLimitException;
import se.walkercrou.places.exception.RequestDeniedException;

public class GooglePlacesException
extends RuntimeException {
    private static final Map<String, Class<?>> statusClassMap = new HashMap();
    private String statusCode;
    private String errorMessage;

    public GooglePlacesException(String statusCode, String errorMessage) {
        super(statusCode + (String)(errorMessage == null ? "" : ": \"" + errorMessage + "\""));
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
    }

    public GooglePlacesException(String statusCode) {
        this(statusCode, (String)null);
    }

    public GooglePlacesException(Throwable t) {
        super(t);
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static GooglePlacesException parse(String statusCode, String errorMessage) {
        Class<?> clazz = statusClassMap.get(statusCode);
        if (clazz == null) {
            return null;
        }
        try {
            if (errorMessage == null || errorMessage.isEmpty()) {
                return (GooglePlacesException)clazz.newInstance();
            }
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return (GooglePlacesException)constructor.newInstance(errorMessage);
        }
        catch (Exception e) {
            throw new GooglePlacesException(e);
        }
    }

    static {
        statusClassMap.put("OK", null);
        statusClassMap.put("ZERO_RESULTS", NoResultsFoundException.class);
        statusClassMap.put("OVER_QUERY_LIMIT", OverQueryLimitException.class);
        statusClassMap.put("REQUEST_DENIED", RequestDeniedException.class);
        statusClassMap.put("INVALID_REQUEST", InvalidRequestException.class);
    }
}

