/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Review {
    private final List<Aspect> aspects = new ArrayList<Aspect>();
    private String author;
    private String authorUrl;
    private String lang;
    private String text;
    private int rating;
    private long time;

    protected Review() {
    }

    public String getAuthor() {
        return this.author;
    }

    protected Review setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    protected Review setAuthorUrl(String authorUrl) {
        this.authorUrl = authorUrl;
        return this;
    }

    public String getLanguage() {
        return this.lang;
    }

    protected Review setLanguage(String lang) {
        this.lang = lang;
        return this;
    }

    public String getText() {
        return this.text;
    }

    protected Review setText(String text) {
        this.text = text;
        return this;
    }

    public int getRating() {
        return this.rating;
    }

    protected Review setRating(int rating) {
        this.rating = rating;
        return this;
    }

    public long getTime() {
        return this.time;
    }

    protected Review setTime(long time) {
        this.time = time;
        return this;
    }

    protected Review addAspects(Collection<Aspect> aspects) {
        this.aspects.addAll(aspects);
        return this;
    }

    protected Review addAspect(Aspect aspect) {
        this.aspects.add(aspect);
        return this;
    }

    protected Review removeAspect(Aspect aspect) {
        this.aspects.remove(aspect);
        return this;
    }

    protected List<Aspect> getAspects() {
        return Collections.unmodifiableList(this.aspects);
    }

    public static class Aspect {
        private final int rating;
        private final String type;

        protected Aspect(int rating, String type) {
            this.rating = rating;
            this.type = type;
        }

        public int getRating() {
            return this.rating;
        }

        public String getType() {
            return this.type;
        }
    }
}

