/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import se.walkercrou.places.GoogleServices;
import se.walkercrou.places.Place;

public class Prediction {
    private final List<DescriptionTerm> terms = new ArrayList<DescriptionTerm>();
    private final List<String> types = new ArrayList<String>();
    private GoogleServices client;
    private String placeId;
    private String description;
    private int substrOffset;
    private int substrLength;

    protected Prediction() {
    }

    public static List<Prediction> parse(GoogleServices client, String rawJson) {
        ArrayList<Prediction> predictions = new ArrayList<Prediction>();
        JSONObject json = new JSONObject(rawJson);
        if (!"OK".equals(json.getString("status"))) {
            return predictions;
        }
        JSONArray jsonPredictions = json.getJSONArray("predictions");
        for (int i = 0; i < jsonPredictions.length(); ++i) {
            JSONObject jsonPrediction = jsonPredictions.getJSONObject(i);
            String placeId = jsonPrediction.getString("place_id");
            String description = jsonPrediction.getString("description");
            JSONArray jsonTerms = jsonPrediction.getJSONArray("terms");
            ArrayList<DescriptionTerm> terms = new ArrayList<DescriptionTerm>();
            for (int a = 0; a < jsonTerms.length(); ++a) {
                JSONObject jsonTerm = jsonTerms.getJSONObject(a);
                String value = jsonTerm.getString("value");
                int offset = jsonTerm.getInt("offset");
                terms.add(new DescriptionTerm(value, offset));
            }
            JSONArray jsonTypes = jsonPrediction.optJSONArray("types");
            ArrayList<String> types = new ArrayList<String>();
            if (jsonTypes != null) {
                for (int b = 0; b < jsonTypes.length(); ++b) {
                    types.add(jsonTypes.getString(b));
                }
            }
            JSONArray substrArray = jsonPrediction.getJSONArray("matched_substrings");
            JSONObject substr = substrArray.getJSONObject(0);
            int substrOffset = substr.getInt("offset");
            int substrLength = substr.getInt("length");
            predictions.add(new Prediction().setPlaceId(placeId).setDescription(description).addTerms(terms).addTypes(types).setSubstringLength(substrLength).setSubstringOffset(substrOffset).setClient(client));
        }
        return predictions;
    }

    public GoogleServices getClient() {
        return this.client;
    }

    protected Prediction setClient(GoogleServices client) {
        this.client = client;
        return this;
    }

    public Place getPlace() {
        return this.client.getPlaceById(this.placeId);
    }

    protected Prediction addTypes(Collection<String> types) {
        this.types.addAll(types);
        return this;
    }

    public List<String> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    protected Prediction addTerms(Collection<DescriptionTerm> terms) {
        this.terms.addAll(terms);
        return this;
    }

    public List<DescriptionTerm> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    public String getPlaceId() {
        return this.placeId;
    }

    protected Prediction setPlaceId(String placeId) {
        this.placeId = placeId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    protected Prediction setDescription(String description) {
        this.description = description;
        return this;
    }

    public int getSubstringOffset() {
        return this.substrOffset;
    }

    protected Prediction setSubstringOffset(int substrOffset) {
        this.substrOffset = substrOffset;
        return this;
    }

    public int getSubstringLength() {
        return this.substrLength;
    }

    protected Prediction setSubstringLength(int substrLength) {
        this.substrLength = substrLength;
        return this;
    }

    public String toString() {
        return "[" + this.description + "]";
    }

    public static class DescriptionTerm {
        private final String value;
        private final int offset;

        protected DescriptionTerm(String value, int offset) {
            this.value = value;
            this.offset = offset;
        }

        public String getValue() {
            return this.value;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

