/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;
import se.walkercrou.places.exception.GooglePlacesException;

public class PlaceBuilder {
    private final double lat;
    private final double lng;
    private final String name;
    private final List<String> types;
    private int accuracy = -1;
    private String phoneNumber;
    private String address;
    private String website;
    private Locale locale;

    public PlaceBuilder(String name, double lat, double lng, List<String> types) {
        if (name == null || name.isEmpty() || types.isEmpty()) {
            throw new GooglePlacesException("Must specify a name, location, and at least one type");
        }
        this.name = name;
        this.lat = lat;
        this.lng = lng;
        this.types = types;
    }

    public PlaceBuilder(String name, double lat, double lng, String ... types) {
        this(name, lat, lng, Arrays.asList(types));
    }

    public PlaceBuilder accuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public PlaceBuilder phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public PlaceBuilder address(String address) {
        this.address = address;
        return this;
    }

    public PlaceBuilder website(String website) {
        this.website = website;
        return this;
    }

    public PlaceBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public JSONObject toJson() {
        JSONObject obj = new JSONObject().put("location", (Object)new JSONObject().put("lat", this.lat).put("lng", this.lng)).put("name", (Object)this.name).put("types", (Object)new JSONArray(this.types));
        if (this.accuracy != -1) {
            obj.put("accuracy", this.accuracy);
        }
        if (this.phoneNumber != null) {
            obj.put("formatted_phone_number", (Object)this.phoneNumber);
        }
        if (this.address != null) {
            obj.put("formatted_address", (Object)this.address);
        }
        if (this.website != null) {
            obj.put("website", (Object)this.website);
        }
        if (this.locale != null) {
            obj.put("language", (Object)this.locale.getLanguage());
        }
        return obj;
    }
}

